/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryDefaultPeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryMaxPeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryMinPeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryPeriodType;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryMinMaxPeriod
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryMinMaxPeriod.class);
    public static final String ELM_LOCALNAME = "length";
    public static final String ELM_NAME = "registry:length";
    private EPPRegistryMinPeriodType min;
    private EPPRegistryMaxPeriodType max;
    private EPPRegistryDefaultPeriodType defaultLength;

    public EPPRegistryMinMaxPeriod() {
    }

    public EPPRegistryMinMaxPeriod(Integer aMinNumber, EPPRegistryPeriodType.Unit aMinUnit, Integer aMaxNumber, EPPRegistryPeriodType.Unit aMaxUnit, Integer aDefaultNumber, EPPRegistryPeriodType.Unit aDefaultUnit) {
        this.min = new EPPRegistryMinPeriodType(aMinNumber, aMinUnit);
        this.max = new EPPRegistryMaxPeriodType(aMaxNumber, aMaxUnit);
        this.defaultLength = new EPPRegistryDefaultPeriodType(aDefaultNumber, aDefaultUnit);
    }

    public EPPRegistryMinMaxPeriod(int aMinNumber, EPPRegistryPeriodType.Unit aMinUnit, int aMaxNumber, EPPRegistryPeriodType.Unit aMaxUnit, int aDefaultNumber, EPPRegistryPeriodType.Unit aDefaultUnit) {
        this.min = new EPPRegistryMinPeriodType(aMinNumber, aMinUnit);
        this.max = new EPPRegistryMaxPeriodType(aMaxNumber, aMaxUnit);
        this.defaultLength = new EPPRegistryDefaultPeriodType(aDefaultNumber, aDefaultUnit);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryMinMaxPeriod.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.min);
        EPPUtil.encodeComp(aDocument, root, this.max);
        EPPUtil.encodeComp(aDocument, root, this.defaultLength);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.min = (EPPRegistryMinPeriodType)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "min", EPPRegistryMinPeriodType.class);
        this.max = (EPPRegistryMaxPeriodType)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "max", EPPRegistryMaxPeriodType.class);
        this.defaultLength = (EPPRegistryDefaultPeriodType)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "default", EPPRegistryDefaultPeriodType.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryMinMaxPeriod clone = (EPPRegistryMinMaxPeriod)super.clone();
        if (this.min != null) {
            clone.min = (EPPRegistryMinPeriodType)this.min.clone();
        }
        if (this.max != null) {
            clone.max = (EPPRegistryMaxPeriodType)this.max.clone();
        }
        if (this.defaultLength != null) {
            clone.defaultLength = (EPPRegistryDefaultPeriodType)this.defaultLength.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryMinMaxPeriod)) {
            return false;
        }
        EPPRegistryMinMaxPeriod theComp = (EPPRegistryMinMaxPeriod)aObject;
        if (!EqualityUtil.equals(this.min, theComp.min)) {
            cat.error("EPPRegistryMinMaxPeriod.equals(): min not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.max, theComp.max)) {
            cat.error("EPPRegistryMinMaxPeriod.equals(): max not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.defaultLength, theComp.defaultLength)) {
            cat.error("EPPRegistryMinMaxPeriod.equals(): defaultLength not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.min == null) {
            throw new EPPCodecException("min element is not set");
        }
        this.min.validateState();
        if (this.max == null) {
            throw new EPPCodecException("max element is not set");
        }
        this.max.validateState();
        if (this.defaultLength == null) {
            throw new EPPCodecException("defaultLength element is not set");
        }
        this.defaultLength.validateState();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryMinPeriodType getMin() {
        return this.min;
    }

    public void setMin(EPPRegistryMinPeriodType aMin) {
        this.min = aMin;
    }

    public EPPRegistryMaxPeriodType getMax() {
        return this.max;
    }

    public void setMax(EPPRegistryMaxPeriodType aMax) {
        this.max = aMax;
    }

    public EPPRegistryDefaultPeriodType getDefaultLength() {
        return this.defaultLength;
    }

    public void setDefaultLength(EPPRegistryDefaultPeriodType aDefault) {
        this.defaultLength = aDefault;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }
}

