/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryAbstractMinMax;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryContactStreet
extends EPPRegistryAbstractMinMax {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryContactStreet.class);
    public static final String ELM_LOCALNAME = "street";
    public static final String ELM_NAME = "registry:street";
    public static final String ELM_MIN_ENTRY = "minEntry";
    public static final String ELM_MAX_ENTRY = "maxEntry";
    private Integer minEntry = null;
    private Integer maxEntry = null;

    public EPPRegistryContactStreet() {
    }

    public EPPRegistryContactStreet(Integer aMin, Integer aMax, Integer aMinEntry, Integer aMaxEntry) {
        super(aMin, aMax);
        this.minEntry = aMinEntry;
        this.maxEntry = aMaxEntry;
    }

    public EPPRegistryContactStreet(int aMin, int aMax, int aMinEntry, int aMaxEntry) {
        super(aMin, aMax);
        this.minEntry = aMinEntry;
        this.maxEntry = aMaxEntry;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        this.validateState();
        Element root = super.encode(aDocument);
        EPPUtil.encodeString(aDocument, root, this.minEntry.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:minEntry");
        EPPUtil.encodeString(aDocument, root, this.maxEntry.toString(), "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:maxEntry");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        super.decode(aElement);
        this.minEntry = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_MIN_ENTRY);
        this.maxEntry = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_MAX_ENTRY);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean equals(Object aObject) {
        if (!super.equals(aObject)) {
            return false;
        }
        if (!(aObject instanceof EPPRegistryContactStreet)) {
            return false;
        }
        EPPRegistryContactStreet theComp = (EPPRegistryContactStreet)aObject;
        if (!EqualityUtil.equals(this.minEntry, theComp.minEntry)) {
            cat.error("EPPRegistryContactStreet.equals(): minEntry not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.maxEntry, theComp.maxEntry)) {
            cat.error("EPPRegistryContactStreet.equals(): maxEntry not equal");
            return false;
        }
        return true;
    }

    public Integer getMinEntry() {
        return this.minEntry;
    }

    public void setMinEntry(Integer aMinEntry) {
        this.minEntry = aMinEntry;
    }

    public Integer getMaxEntry() {
        return this.maxEntry;
    }

    public void setMaxEntry(Integer aMaxEntry) {
        this.maxEntry = aMaxEntry;
    }

    @Override
    protected void validateState() throws EPPEncodeException {
        super.validateState();
        if (this.minEntry == null || this.minEntry < 0) {
            throw new EPPEncodeException("Invalid state on EPPRegistryContactStreet.encode: minEntry is required and should be greater than or equal to 0");
        }
        if (this.maxEntry == null || this.maxEntry < this.minEntry || this.maxEntry > 3) {
            throw new EPPEncodeException("Invalid state on EPPRegistryContactStreet.encode: maxEntry is required and should be greater than or equal to min, and less than or equal to 3");
        }
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    protected String getRootName() {
        return ELM_LOCALNAME;
    }

    @Override
    protected String getElmMin() {
        return "minLength";
    }

    @Override
    protected String getElmMax() {
        return "maxLength";
    }

    @Override
    protected Logger getLogger() {
        return cat;
    }
}

