/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactCity;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactPostalCode;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactStateProvince;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactStreet;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryContactAddress
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryContactAddress.class);
    public static final String ELM_LOCALNAME = "address";
    public static final String ELM_NAME = "registry:address";
    private EPPRegistryContactStreet street = null;
    private EPPRegistryContactCity city = null;
    private EPPRegistryContactStateProvince stateProvince = null;
    private EPPRegistryContactPostalCode postalCode = null;

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryContactAddress.encode: " + e);
        }
        Element aRoot = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeComp(aDocument, aRoot, this.street);
        EPPUtil.encodeComp(aDocument, aRoot, this.city);
        EPPUtil.encodeComp(aDocument, aRoot, this.stateProvince);
        EPPUtil.encodeComp(aDocument, aRoot, this.postalCode);
        return aRoot;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.setStreet((EPPRegistryContactStreet)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:street", EPPRegistryContactStreet.class));
        this.setCity((EPPRegistryContactCity)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:city", EPPRegistryContactCity.class));
        this.setStateProvince((EPPRegistryContactStateProvince)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:sp", EPPRegistryContactStateProvince.class));
        this.setPostalCode((EPPRegistryContactPostalCode)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:pc", EPPRegistryContactPostalCode.class));
    }

    void validateState() throws EPPCodecException {
        if (this.street == null) {
            throw new EPPCodecException("street required element is not set");
        }
        if (this.city == null) {
            throw new EPPCodecException("city required element is not set");
        }
        if (this.stateProvince == null) {
            throw new EPPCodecException("stateProvince required element is not set");
        }
        if (this.postalCode == null) {
            throw new EPPCodecException("postalCode required element is not set");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryContactAddress clone = (EPPRegistryContactAddress)super.clone();
        if (this.street != null) {
            clone.street = (EPPRegistryContactStreet)this.street.clone();
        }
        if (this.city != null) {
            clone.city = (EPPRegistryContactCity)this.city.clone();
        }
        if (this.stateProvince != null) {
            clone.stateProvince = (EPPRegistryContactStateProvince)this.stateProvince.clone();
        }
        if (this.postalCode != null) {
            clone.postalCode = (EPPRegistryContactPostalCode)this.postalCode.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryContactAddress)) {
            return false;
        }
        EPPRegistryContactAddress theComp = (EPPRegistryContactAddress)aObject;
        if (!EqualityUtil.equals(this.street, theComp.street)) {
            cat.error("EPPRegistryContactAddress.equals(): street not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.city, theComp.city)) {
            cat.error("EPPRegistryContactAddress.equals(): city not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.stateProvince, theComp.stateProvince)) {
            cat.error("EPPRegistryContactAddress.equals(): stateProvince not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.postalCode, theComp.postalCode)) {
            cat.error("EPPRegistryContactAddress.equals(): postalCode not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryContactCity getCity() {
        return this.city;
    }

    public void setCity(EPPRegistryContactCity city) {
        this.city = city;
    }

    public EPPRegistryContactStateProvince getStateProvince() {
        return this.stateProvince;
    }

    public void setStateProvince(EPPRegistryContactStateProvince stateProvince) {
        this.stateProvince = stateProvince;
    }

    public EPPRegistryContactPostalCode getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(EPPRegistryContactPostalCode postalCode) {
        this.postalCode = postalCode;
    }

    public EPPRegistryContactStreet getStreet() {
        return this.street;
    }

    public void setStreet(EPPRegistryContactStreet street) {
        this.street = street;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }
}

