/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.security.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPRegistryBatchSchedule
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryBatchSchedule.class);
    public static final String ELM_LOCALNAME = "schedule";
    public static final String ELM_NAME = "registry:schedule";
    public static final String ATTR_FREQUENCY = "frequency";
    public static final String ATTR_TZ = "tz";
    public static final String ATTR_DAY_OF_WEEK = "dayOfWeek";
    public static final String ATTR_DAY_OF_MONTH = "dayOfMonth";
    Frequency frequency = null;
    String time = null;
    String timeZone = null;
    DayOfWeek dayOfWeek = null;
    Integer dayOfMonth = null;

    public EPPRegistryBatchSchedule() {
    }

    public EPPRegistryBatchSchedule(Frequency aFrequency, String aTime) {
        this.frequency = aFrequency;
        this.time = aTime;
    }

    public EPPRegistryBatchSchedule(String aTime, String aTimeZone) {
        this(Frequency.daily, aTime);
        this.timeZone = aTimeZone;
    }

    public EPPRegistryBatchSchedule(String aTime, DayOfWeek aDayOfWeek, String aTimeZone) {
        this(Frequency.weekly, aTime);
        this.dayOfWeek = aDayOfWeek;
        this.timeZone = aTimeZone;
    }

    public EPPRegistryBatchSchedule(String aTime, Integer aDayOfMonth, String aTimeZone) {
        this(Frequency.monthly, aTime);
        this.dayOfMonth = aDayOfMonth;
        this.timeZone = aTimeZone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.frequency == null) {
            throw new EPPEncodeException("Invalid state on EPPRegistryBatchSchedule.encode: frequency is not set");
        }
        if (this.time == null) {
            throw new EPPEncodeException("Invalid state on EPPRegistryBatchSchedule.encode: time is not set");
        }
        if (this.frequency == Frequency.daily && (this.hasDayOfWeek() || this.hasDayOfMonth())) {
            throw new EPPEncodeException("Invalid state on EPPRegistryBatchSchedule.encode: dayOfWeek or dayOfMonth set with daily frequency");
        }
        if (this.frequency == Frequency.weekly && !this.hasDayOfWeek()) {
            throw new EPPEncodeException("Invalid state on EPPRegistryBatchSchedule.encode: dayOfWeek not set with weekly frequency");
        }
        if (this.frequency == Frequency.monthly && !this.hasDayOfMonth()) {
            throw new EPPEncodeException("Invalid state on EPPRegistryBatchSchedule.encode: dayOfMonth not set with monthly frequency");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        root.setAttribute(ATTR_FREQUENCY, this.frequency.toString());
        Text timeVal = aDocument.createTextNode(this.time);
        root.appendChild(timeVal);
        if (this.hasTimeZone()) {
            root.setAttribute(ATTR_TZ, this.timeZone);
        }
        if (this.frequency == Frequency.weekly && this.hasDayOfWeek()) {
            root.setAttribute(ATTR_DAY_OF_WEEK, this.dayOfWeek.toString());
        }
        if (this.frequency == Frequency.monthly && this.hasDayOfMonth()) {
            root.setAttribute(ATTR_DAY_OF_MONTH, this.dayOfMonth.toString());
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theFrequencyStr = EPPUtil.decodeStringAttr(aElement, ATTR_FREQUENCY);
        this.frequency = theFrequencyStr != null ? Frequency.valueOf(theFrequencyStr) : null;
        this.time = EPPUtil.decodeStringValue(aElement);
        this.timeZone = EPPUtil.decodeStringAttr(aElement, ATTR_TZ);
        String theDayOfWeekStr = EPPUtil.decodeStringAttr(aElement, ATTR_DAY_OF_WEEK);
        this.dayOfWeek = theDayOfWeekStr != null ? DayOfWeek.getDayOfWeek(theDayOfWeekStr) : null;
        String DayOfMonthStr = EPPUtil.decodeStringAttr(aElement, ATTR_DAY_OF_MONTH);
        this.dayOfMonth = DayOfMonthStr != null ? Integer.valueOf(Integer.parseInt(DayOfMonthStr)) : null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryBatchSchedule)) {
            return false;
        }
        EPPRegistryBatchSchedule theComp = (EPPRegistryBatchSchedule)aObject;
        if (!EqualityUtil.equals((Object)this.frequency, (Object)theComp.frequency)) {
            cat.error("EPPRegistryBatchSchedule.equals(): policy not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.time, theComp.time)) {
            cat.error("EPPRegistryBatchSchedule.equals(): time not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.timeZone, theComp.timeZone)) {
            cat.error("EPPRegistryBatchSchedule.equals(): timeZone not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.dayOfWeek, (Object)theComp.dayOfWeek)) {
            cat.error("EPPRegistryBatchSchedule.equals(): dayOfWeek not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.dayOfMonth, theComp.dayOfMonth)) {
            cat.error("EPPRegistryBatchSchedule.equals(): dayOfMonth not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Frequency aFrequency) {
        this.frequency = aFrequency;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String aTime) {
        this.time = aTime;
    }

    public boolean hasTimeZone() {
        return this.timeZone != null;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String aTimeZone) {
        this.timeZone = aTimeZone;
    }

    public boolean hasDayOfWeek() {
        return this.dayOfWeek != null;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(DayOfWeek aDayOfWeek) {
        this.dayOfWeek = aDayOfWeek;
    }

    public boolean hasDayOfMonth() {
        return this.dayOfMonth != null;
    }

    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(Integer aDayOfMonth) {
        this.dayOfMonth = aDayOfMonth;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    public static enum DayOfWeek {
        SUNDAY("0"),
        MONDAY("1"),
        TUESDAY("2"),
        WEDNESDAY("3"),
        THURSDAY("4"),
        FRIDAY("5"),
        SATURDAY("6");

        private final String dayOfWeekStr;

        private DayOfWeek(String aDayOfWeekStr) {
            this.dayOfWeekStr = aDayOfWeekStr;
        }

        public static DayOfWeek getDayOfWeek(String aDayOfWeekStr) {
            if (aDayOfWeekStr == null) {
                throw new InvalidParameterException("null DayOfWeek enum value is not valid.");
            }
            if (aDayOfWeekStr.equals(DayOfWeek.SUNDAY.dayOfWeekStr)) {
                return SUNDAY;
            }
            if (aDayOfWeekStr.equals(DayOfWeek.MONDAY.dayOfWeekStr)) {
                return MONDAY;
            }
            if (aDayOfWeekStr.equals(DayOfWeek.TUESDAY.dayOfWeekStr)) {
                return TUESDAY;
            }
            if (aDayOfWeekStr.equals(DayOfWeek.WEDNESDAY.dayOfWeekStr)) {
                return WEDNESDAY;
            }
            if (aDayOfWeekStr.equals(DayOfWeek.THURSDAY.dayOfWeekStr)) {
                return THURSDAY;
            }
            if (aDayOfWeekStr.equals(DayOfWeek.FRIDAY.dayOfWeekStr)) {
                return FRIDAY;
            }
            if (aDayOfWeekStr.equals(DayOfWeek.SATURDAY.dayOfWeekStr)) {
                return SATURDAY;
            }
            throw new InvalidParameterException("DayOfWeek enum value of " + aDayOfWeekStr + " is not valid.");
        }

        public String toString() {
            return this.dayOfWeekStr;
        }
    }

    public static enum Frequency {
        daily,
        weekly,
        monthly;

    }
}

