/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryPendingDeletePeriodType;
import com.verisign.epp.codec.registry.EPPRegistryPendingRestorePeriodType;
import com.verisign.epp.codec.registry.EPPRegistryRedemptionPeriodType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryRGP
implements EPPCodecComponent {
    private static final long serialVersionUID = -5930890654584746393L;
    public static final String ELM_NAME = "registry:rgp";
    private EPPRegistryRedemptionPeriodType redemptionPeriod = null;
    private EPPRegistryPendingRestorePeriodType pendingRestorePeriod = null;
    private EPPRegistryPendingDeletePeriodType pendingDeletePeriod = null;

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryRGP.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.redemptionPeriod);
        EPPUtil.encodeComp(aDocument, root, this.pendingRestorePeriod);
        EPPUtil.encodeComp(aDocument, root, this.pendingDeletePeriod);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.redemptionPeriod = (EPPRegistryRedemptionPeriodType)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:redemptionPeriod", EPPRegistryRedemptionPeriodType.class);
        this.pendingRestorePeriod = (EPPRegistryPendingRestorePeriodType)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:pendingRestore", EPPRegistryPendingRestorePeriodType.class);
        this.pendingDeletePeriod = (EPPRegistryPendingDeletePeriodType)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:pendingDelete", EPPRegistryPendingDeletePeriodType.class);
    }

    void validateState() throws EPPCodecException {
        if (this.redemptionPeriod == null) {
            throw new EPPCodecException("redemptionPeriod element is not set");
        }
        if (this.pendingRestorePeriod == null) {
            throw new EPPCodecException("pendingRestorePeriod element is not set");
        }
        if (this.pendingDeletePeriod == null) {
            throw new EPPCodecException("pendingDeletePeriod element is not set");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryRGP clone = (EPPRegistryRGP)super.clone();
        if (this.redemptionPeriod != null) {
            clone.redemptionPeriod = (EPPRegistryRedemptionPeriodType)this.redemptionPeriod.clone();
        }
        if (this.pendingRestorePeriod != null) {
            clone.pendingRestorePeriod = (EPPRegistryPendingRestorePeriodType)this.pendingRestorePeriod.clone();
        }
        if (this.pendingDeletePeriod != null) {
            clone.pendingDeletePeriod = (EPPRegistryPendingDeletePeriodType)this.pendingDeletePeriod.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryRGP)) {
            return false;
        }
        EPPRegistryRGP theComp = (EPPRegistryRGP)aObject;
        if (!(this.redemptionPeriod != null ? this.redemptionPeriod.equals(theComp.redemptionPeriod) : theComp.redemptionPeriod == null)) {
            return false;
        }
        if (!(this.pendingRestorePeriod != null ? this.pendingRestorePeriod.equals(theComp.pendingRestorePeriod) : theComp.pendingRestorePeriod == null)) {
            return false;
        }
        return this.pendingDeletePeriod != null ? this.pendingDeletePeriod.equals(theComp.pendingDeletePeriod) : theComp.pendingDeletePeriod == null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryRedemptionPeriodType getRedemptionPeriod() {
        return this.redemptionPeriod;
    }

    public void setRedemptionPeriod(EPPRegistryRedemptionPeriodType redemptionPeriod) {
        this.redemptionPeriod = redemptionPeriod;
    }

    public EPPRegistryPendingDeletePeriodType getPendingDeletePeriod() {
        return this.pendingDeletePeriod;
    }

    public void setPendingDeletePeriod(EPPRegistryPendingDeletePeriodType pendingDeletePeriod) {
        this.pendingDeletePeriod = pendingDeletePeriod;
    }

    public EPPRegistryPendingRestorePeriodType getPendingRestorePeriod() {
        return this.pendingRestorePeriod;
    }

    public void setPendingRestorePeriod(EPPRegistryPendingRestorePeriodType pendingRestorePeriod) {
        this.pendingRestorePeriod = pendingRestorePeriod;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }
}

