/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCreateCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nv.EPPDomainNameVerification;
import com.verisign.epp.codec.nv.EPPRealNameVerification;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPNameVerificationCreateCmd
extends EPPCreateCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPNameVerificationCreateCmd.class);
    public static final String ELM_LOCALNAME = "create";
    public static final String ELM_NAME = "nv:create";
    private EPPDomainNameVerification dnv;
    private EPPRealNameVerification rnv;
    private EPPAuthInfo authInfo;

    public EPPNameVerificationCreateCmd() {
    }

    public EPPNameVerificationCreateCmd(String aTransId) {
        super(aTransId);
    }

    public EPPNameVerificationCreateCmd(String aTransId, EPPDomainNameVerification aDnv, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.dnv = aDnv;
        this.setAuthInfo(aAuthInfo);
    }

    public EPPNameVerificationCreateCmd(String aTransId, EPPRealNameVerification aRnv, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.rnv = aRnv;
        this.setAuthInfo(aAuthInfo);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    public boolean hasDnv() {
        return this.dnv != null;
    }

    public EPPDomainNameVerification getDnv() {
        return this.dnv;
    }

    public void setDnv(EPPDomainNameVerification aDnv) {
        this.dnv = aDnv;
    }

    public boolean hasRnv() {
        return this.rnv != null;
    }

    public EPPRealNameVerification getRnv() {
        return this.rnv;
    }

    public void setRnv(EPPRealNameVerification aRnv) {
        this.rnv = aRnv;
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPAuthInfo aAuthInfo) {
        if (aAuthInfo != null) {
            this.authInfo = aAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:nv-1.0", "nv:authInfo");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.dnv != null && this.rnv != null) {
            throw new EPPEncodeException("Both DNV and RNV cannot be set in EPPNameVerificationCreateCmd");
        }
        if (this.dnv == null && this.rnv == null) {
            throw new EPPEncodeException("Either DNV and RNV must be set in EPPNameVerificationCreateCmd");
        }
        if (this.authInfo == null) {
            throw new EPPEncodeException("Undefined authInfo in EPPNameVerificationCreateCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        if (this.hasDnv()) {
            EPPUtil.encodeComp(aDocument, root, this.dnv);
        }
        if (this.hasRnv()) {
            EPPUtil.encodeComp(aDocument, root, this.rnv);
        }
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.dnv = (EPPDomainNameVerification)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:nv-1.0", "nv:dnv", EPPDomainNameVerification.class);
        this.rnv = (EPPRealNameVerification)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:nv-1.0", "nv:rnv", EPPRealNameVerification.class);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:nv-1.0", "nv:authInfo", EPPAuthInfo.class);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameVerificationCreateCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPNameVerificationCreateCmd other = (EPPNameVerificationCreateCmd)aObject;
        if (!EqualityUtil.equals(this.dnv, other.dnv)) {
            cat.error("EPPNameVerificationCreateCmd.equals(): dnv not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.rnv, other.rnv)) {
            cat.error("EPPNameVerificationCreateCmd.equals(): rnv not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.authInfo, other.authInfo)) {
            cat.error("EPPNameVerificationCreateCmd.equals(): authInfo not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameVerificationCreateCmd clone = (EPPNameVerificationCreateCmd)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

