/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.mark;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.mark.EPPMarkContact;
import com.verisign.epp.util.EqualityUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.dom.DocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPTrademark
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPTrademark.class);
    public static final String ELM_LOCALNAME = "trademark";
    public static final String ELM_NAME = "mark:trademark";
    private static final String ELM_ID = "id";
    private static final String ELM_MARK_NAME = "markName";
    private static final String ELM_JURISDICTION = "jurisdiction";
    private static final String ELM_CLASS = "class";
    private static final String ELM_LABEL = "label";
    private static final String ELM_GOODS_AND_SERVICES = "goodsAndServices";
    private static final String ELM_AP_ID = "apId";
    private static final String ELM_AP_DATE = "apDate";
    private static final String ELM_REG_NUM = "regNum";
    private static final String ELM_REG_DATE = "regDate";
    private static final String ELM_EX_DATE = "exDate";
    private String id;
    private String name;
    private List<EPPMarkContact> holders = new ArrayList<EPPMarkContact>();
    private List<EPPMarkContact> contacts = new ArrayList<EPPMarkContact>();
    private String jurisdiction;
    private List<String> classes = new ArrayList<String>();
    private List<String> labels = new ArrayList<String>();
    private String goodsAndServices;
    private String apId;
    private Date apDate;
    private String regNum;
    private Date regDate;
    private Date exDate;

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPTrademark clone = (EPPTrademark)super.clone();
        return clone;
    }

    public byte[] encode() throws EPPEncodeException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            DocumentImpl doc = new DocumentImpl();
            Element root = this.encode((Document)doc);
            doc.appendChild(root);
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            trans.transform(new DOMSource(root), new StreamResult(os));
        }
        catch (EPPEncodeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            cat.error("Error encoding trademark to byte[]: " + ex);
            throw new EPPEncodeException("Error encoding trademark to byte[]");
        }
        return os.toByteArray();
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPTrademark.encode(Document)");
        }
        if (this.id == null) {
            throw new EPPEncodeException("id is required for trademark");
        }
        if (this.name == null) {
            throw new EPPEncodeException("name is required for trademark");
        }
        if (this.holders == null || this.holders.isEmpty()) {
            throw new EPPEncodeException("one holder is required for trademark");
        }
        if (this.jurisdiction == null) {
            throw new EPPEncodeException("jurisdiction is required for trademark");
        }
        if (this.goodsAndServices == null) {
            throw new EPPEncodeException("goodsAndServices is required for trademark");
        }
        if (this.regNum == null) {
            throw new EPPEncodeException("regNum is required for trademark");
        }
        if (this.regDate == null) {
            throw new EPPEncodeException("regDate is required for trademark");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:mark-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:mark-1.0", "mark:id");
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:mark-1.0", "mark:markName");
        EPPUtil.encodeCompList(aDocument, root, this.holders);
        EPPUtil.encodeCompList(aDocument, root, this.contacts);
        EPPUtil.encodeString(aDocument, root, this.jurisdiction, "urn:ietf:params:xml:ns:mark-1.0", "mark:jurisdiction");
        EPPUtil.encodeList(aDocument, root, this.classes, "urn:ietf:params:xml:ns:mark-1.0", "mark:class");
        EPPUtil.encodeList(aDocument, root, this.labels, "urn:ietf:params:xml:ns:mark-1.0", "mark:label");
        EPPUtil.encodeString(aDocument, root, this.goodsAndServices, "urn:ietf:params:xml:ns:mark-1.0", "mark:goodsAndServices");
        EPPUtil.encodeString(aDocument, root, this.apId, "urn:ietf:params:xml:ns:mark-1.0", "mark:apId");
        EPPUtil.encodeTimeInstant(aDocument, root, this.apDate, "urn:ietf:params:xml:ns:mark-1.0", "mark:apDate");
        EPPUtil.encodeString(aDocument, root, this.regNum, "urn:ietf:params:xml:ns:mark-1.0", "mark:regNum");
        EPPUtil.encodeTimeInstant(aDocument, root, this.regDate, "urn:ietf:params:xml:ns:mark-1.0", "mark:regDate");
        EPPUtil.encodeTimeInstant(aDocument, root, this.exDate, "urn:ietf:params:xml:ns:mark-1.0", "mark:exDate");
        return root;
    }

    public void decode(byte[] aMarkArray) throws EPPDecodeException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(aMarkArray);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(is);
            this.decode(doc.getDocumentElement());
        }
        catch (Exception ex) {
            throw new EPPDecodeException("Error decoding trademark array: " + ex);
        }
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_ID);
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_MARK_NAME);
        this.holders = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:mark-1.0", "holder", EPPMarkContact.class);
        this.contacts = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:mark-1.0", "contact", EPPMarkContact.class);
        this.jurisdiction = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_JURISDICTION);
        this.classes = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_CLASS);
        this.labels = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_LABEL);
        this.goodsAndServices = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_GOODS_AND_SERVICES);
        this.apId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_AP_ID);
        this.apDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_AP_DATE);
        this.regNum = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_REG_NUM);
        this.regDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_REG_DATE);
        this.exDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_EX_DATE);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPTrademark)) {
            cat.error("EPPTrademark.equals(): aObject is not an EPPTrademark");
            return false;
        }
        EPPTrademark other = (EPPTrademark)aObject;
        if (!EqualityUtil.equals(this.id, other.id)) {
            cat.error("EPPTrademark.equals(): id not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error("EPPTrademark.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.holders, other.holders)) {
            cat.error("EPPTrademark.equals(): holders not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.contacts, other.contacts)) {
            cat.error("EPPTrademark.equals(): contacts not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.jurisdiction, other.jurisdiction)) {
            cat.error("EPPTrademark.equals(): jurisdiction not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.classes, other.classes)) {
            cat.error("EPPTrademark.equals(): classes not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.labels, other.labels)) {
            cat.error("EPPTrademark.equals(): labels not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.goodsAndServices, other.goodsAndServices)) {
            cat.error("EPPTrademark.equals(): goodsAndServices not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.apId, other.apId)) {
            cat.error("EPPTrademark.equals(): apId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.apDate, other.apDate)) {
            cat.error("EPPTrademark.equals(): apDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.regNum, other.regNum)) {
            cat.error("EPPTrademark.equals(): regNum not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.regDate, other.regDate)) {
            cat.error("EPPTrademark.equals(): regDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.exDate, other.exDate)) {
            cat.error("EPPTrademark.equals(): exDate not equal");
            return false;
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public List<EPPMarkContact> getHolders() {
        return this.holders;
    }

    public void setHolders(List<EPPMarkContact> aHolders) {
        this.holders = aHolders;
        if (this.holders == null) {
            this.holders = new ArrayList<EPPMarkContact>();
        }
        for (EPPMarkContact holder : this.holders) {
            holder.setLocalName("holder");
        }
    }

    public void addHolder(EPPMarkContact aHolder) {
        if (aHolder == null) {
            return;
        }
        aHolder.setLocalName("holder");
        if (this.holders == null) {
            this.holders = new ArrayList<EPPMarkContact>();
        }
        this.holders.add(aHolder);
    }

    public List<EPPMarkContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<EPPMarkContact> aContacts) {
        this.contacts = aContacts;
        if (this.contacts == null) {
            this.contacts = new ArrayList<EPPMarkContact>();
        }
        for (EPPMarkContact contact : this.contacts) {
            contact.setLocalName("contact");
        }
    }

    public void addContact(EPPMarkContact aContact) {
        if (aContact == null) {
            return;
        }
        aContact.setLocalName("contact");
        if (this.contacts == null) {
            this.contacts = new ArrayList<EPPMarkContact>();
        }
        this.contacts.add(aContact);
    }

    public String getJurisdiction() {
        return this.jurisdiction;
    }

    public void setJurisdiction(String aJurisdiction) {
        this.jurisdiction = aJurisdiction;
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public void setClasses(List<String> aClasses) {
        this.classes = aClasses;
        if (this.classes == null) {
            this.classes = new ArrayList<String>();
        }
    }

    public void addClass(String aClass) {
        if (this.classes == null) {
            this.classes = new ArrayList<String>();
        }
        this.classes.add(aClass);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> aLabels) {
        this.labels = aLabels;
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
    }

    public void addLabel(String aLabel) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(aLabel);
    }

    public String getGoodsAndServices() {
        return this.goodsAndServices;
    }

    public void setGoodsAndServices(String aGoodsAndServices) {
        this.goodsAndServices = aGoodsAndServices;
    }

    public String getApId() {
        return this.apId;
    }

    public void setApId(String aApId) {
        this.apId = aApId;
    }

    public Date getApDate() {
        return this.apDate;
    }

    public void setApDate(Date aApDate) {
        this.apDate = aApDate;
    }

    public String getRegNum() {
        return this.regNum;
    }

    public void setRegNum(String aRegNum) {
        this.regNum = aRegNum;
    }

    public Date getRegDate() {
        return this.regDate;
    }

    public void setRegDate(Date aRegDate) {
        this.regDate = aRegDate;
    }

    public Date getExDate() {
        return this.exDate;
    }

    public void setExDate(Date aExDate) {
        this.exDate = aExDate;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:mark-1.0";
    }
}

