/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.maintenance.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceId;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPMaintenanceListItem
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPMaintenanceListItem.class);
    public static final String ELM_LOCALNAME = "listItem";
    public static final String ELM_NAME = "maint:listItem";
    private static final String ELM_START_DATE = "start";
    private static final String ELM_END_DATE = "end";
    private static final String ELM_CREATED_DATE = "crDate";
    private static final String ELM_LAST_UPDATED_DATE = "upDate";
    private EPPMaintenanceId maintenanceId;
    private Date startDate;
    private Date endDate;
    private Date createdDate;
    private Date lastUpdatedDate;

    public EPPMaintenanceListItem() {
    }

    public EPPMaintenanceListItem(EPPMaintenanceId aMaintenanceId, Date aStartDate, Date aEndDate, Date aCreatedDate) {
        this.maintenanceId = aMaintenanceId;
        this.startDate = aStartDate;
        this.endDate = aEndDate;
        this.createdDate = aCreatedDate;
    }

    public EPPMaintenanceListItem(EPPMaintenanceId aMaintenanceId, Date aStartDate, Date aEndDate, Date aCreatedDate, Date aLastUpdatedDate) {
        this.maintenanceId = aMaintenanceId;
        this.createdDate = aCreatedDate;
        this.startDate = aStartDate;
        this.endDate = aEndDate;
        this.lastUpdatedDate = aLastUpdatedDate;
    }

    public EPPMaintenanceId getMaintenanceId() {
        return this.maintenanceId;
    }

    public void setMaintenanceId(EPPMaintenanceId aMaintenanceId) {
        this.maintenanceId = aMaintenanceId;
    }

    public boolean hasStartdDate() {
        return this.startDate != null;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date aStartDate) {
        this.startDate = aStartDate;
    }

    public boolean hasEndDate() {
        return this.endDate != null;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date aEndDate) {
        this.endDate = aEndDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date aCreatedDate) {
        this.createdDate = aCreatedDate;
    }

    public boolean hasLastUpdatedDate() {
        return this.lastUpdatedDate != null;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Date aLastUpdatedDate) {
        this.lastUpdatedDate = aLastUpdatedDate;
    }

    void validateState() throws EPPCodecException {
        if (this.maintenanceId == null) {
            throw new EPPCodecException("maintenanceId required attribute is not set");
        }
        if (this.startDate == null) {
            throw new EPPCodecException("startDate required attribute is not set");
        }
        if (this.endDate == null) {
            throw new EPPCodecException("endDate required attribute is not set");
        }
        if (this.createdDate == null) {
            throw new EPPCodecException("createdDate required attribute is not set");
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPMaintenanceItem.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.maintenanceId);
        EPPUtil.encodeTimeInstant(aDocument, root, this.startDate, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:start");
        EPPUtil.encodeTimeInstant(aDocument, root, this.endDate, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:end");
        EPPUtil.encodeTimeInstant(aDocument, root, this.createdDate, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:crDate");
        EPPUtil.encodeTimeInstant(aDocument, root, this.lastUpdatedDate, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:upDate");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.maintenanceId = (EPPMaintenanceId)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "id", EPPMaintenanceId.class);
        this.startDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_START_DATE);
        this.endDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_END_DATE);
        this.createdDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_CREATED_DATE);
        this.lastUpdatedDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_LAST_UPDATED_DATE);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPMaintenanceListItem)) {
            return false;
        }
        EPPMaintenanceListItem other = (EPPMaintenanceListItem)aObject;
        if (!EqualityUtil.equals(this.maintenanceId, other.maintenanceId)) {
            cat.error("EPPMaintenanceItem.equals(): maintenanceId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.startDate, other.startDate)) {
            cat.error("EPPMaintenanceItem.equals(): startDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.endDate, other.endDate)) {
            cat.error("EPPMaintenanceItem.equals(): endDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createdDate, other.createdDate)) {
            cat.error("EPPMaintenanceItem.equals(): createdDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lastUpdatedDate, other.lastUpdatedDate)) {
            cat.error("EPPMaintenanceItem.equals(): lastUpdatedDate not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPMaintenanceListItem clone = null;
        clone = (EPPMaintenanceListItem)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:maintenance-1.0";
    }
}

