/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.maintenance.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceDescription;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceId;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceIntervention;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceSystem;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceType;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPMaintenanceItem
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPMaintenanceItem.class);
    public static final String ELM_LOCALNAME = "item";
    public static final String ELM_NAME = "maint:item";
    private static final String ELM_TYPE = "type";
    private static final String ELM_POLL_TYPE = "pollType";
    private static final String ELM_SYSTEMS = "systems";
    private static final String ELM_ENVIRONMENT = "environment";
    private static final String ELM_START_DATE = "start";
    private static final String ELM_END_DATE = "end";
    private static final String ELM_REASON = "reason";
    private static final String ELM_DETAIL = "detail";
    private static final String ELM_DESCRIPTION = "description";
    private static final String ELM_TLDS = "tlds";
    private static final String ELM_TLD = "tld";
    private static final String ELM_CREATED_DATE = "crDate";
    private static final String ELM_LAST_UPDATED_DATE = "upDate";
    private static final String ATTR_ENVIRONMENT_TYPE = "type";
    private static final String ATTR_ENVIRONMENT_CUSTOM = "name";
    private EPPMaintenanceId maintenanceId;
    private List<EPPMaintenanceType> types = null;
    private PollType pollType;
    private List<EPPMaintenanceSystem> systems = new ArrayList<EPPMaintenanceSystem>();
    private Environment environment = null;
    private String customEnvironment = null;
    private Date startDate;
    private Date endDate;
    private Reason reason = Reason.planned;
    private String detail = null;
    private List<EPPMaintenanceDescription> descriptions = null;
    private List<String> tlds = null;
    private EPPMaintenanceIntervention intervention = null;
    private Date createdDate;
    private Date lastUpdatedDate;

    public EPPMaintenanceItem() {
    }

    public EPPMaintenanceItem(EPPMaintenanceId aMaintenanceId, List<EPPMaintenanceSystem> aSystems, Environment aEnvironment, Date aStartDate, Date aEndDate, Reason aReason, Date aCreatedDate) {
        this.maintenanceId = aMaintenanceId;
        this.systems = aSystems;
        this.environment = aEnvironment;
        this.startDate = aStartDate;
        this.endDate = aEndDate;
        this.reason = aReason;
        this.createdDate = aCreatedDate;
    }

    public EPPMaintenanceId getMaintenanceId() {
        return this.maintenanceId;
    }

    public void setMaintenanceId(EPPMaintenanceId aMaintenanceId) {
        this.maintenanceId = aMaintenanceId;
    }

    public boolean hasTypes() {
        return this.types != null;
    }

    public List<EPPMaintenanceType> getTypes() {
        return this.types;
    }

    public void addType(EPPMaintenanceType aType) {
        if (aType != null) {
            if (this.types == null) {
                this.types = new ArrayList<EPPMaintenanceType>();
            }
            this.types.add(aType);
        }
    }

    public void setTypes(List<EPPMaintenanceType> aTypes) {
        this.types = aTypes;
    }

    public boolean hasPollType() {
        return this.pollType != null;
    }

    public PollType getPollType() {
        return this.pollType;
    }

    public void setPollType(PollType aPollType) {
        this.pollType = aPollType;
    }

    public List<EPPMaintenanceSystem> getSystems() {
        return this.systems;
    }

    public void addSystem(EPPMaintenanceSystem aSystem) {
        if (aSystem != null) {
            this.systems.add(aSystem);
        }
    }

    public void setSystems(List<EPPMaintenanceSystem> aSystems) {
        this.systems = aSystems;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment aEnvironment) {
        this.environment = aEnvironment;
    }

    public boolean hasCustomEnvironment() {
        return this.customEnvironment != null;
    }

    public String getCustomEnvironment() {
        return this.customEnvironment;
    }

    public void setCustomEnvironment(String aCustomEnvironment) {
        this.customEnvironment = aCustomEnvironment;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date aStartDate) {
        this.startDate = aStartDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date aEndDate) {
        this.endDate = aEndDate;
    }

    public Reason getReason() {
        return this.reason;
    }

    public void setReason(Reason aReason) {
        this.reason = aReason;
    }

    public boolean hasDetail() {
        return this.detail != null;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String aDetail) {
        this.detail = aDetail;
    }

    public boolean hasDescriptions() {
        return this.descriptions != null;
    }

    public List<EPPMaintenanceDescription> getDescriptions() {
        return this.descriptions;
    }

    public void addDescription(EPPMaintenanceDescription aDescription) {
        if (aDescription != null) {
            if (this.descriptions == null) {
                this.descriptions = new ArrayList<EPPMaintenanceDescription>();
            }
            this.descriptions.add(aDescription);
        }
    }

    public void setDescriptions(List<EPPMaintenanceDescription> aDescriptions) {
        this.descriptions = aDescriptions;
    }

    public List<String> getTlds() {
        return this.tlds;
    }

    public void addTld(String aTld) {
        if (aTld != null) {
            if (this.tlds == null) {
                this.tlds = new ArrayList<String>();
            }
            this.tlds.add(aTld);
        }
    }

    public void setTlds(List<String> aTlds) {
        this.tlds = aTlds;
    }

    public EPPMaintenanceIntervention getIntervention() {
        return this.intervention;
    }

    public void setIntervention(EPPMaintenanceIntervention aIntervention) {
        this.intervention = aIntervention;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date aCreatedDate) {
        this.createdDate = aCreatedDate;
    }

    public boolean hasLastUpdatedDate() {
        return this.lastUpdatedDate != null;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Date aLastUpdatedDate) {
        this.lastUpdatedDate = aLastUpdatedDate;
    }

    void validateState() throws EPPCodecException {
        if (this.maintenanceId == null) {
            throw new EPPCodecException("maintenanceId required attribute is not set");
        }
        if (this.systems == null) {
            throw new EPPCodecException("systems required attribute is not set");
        }
        if (this.environment == null) {
            throw new EPPCodecException("environment required attribute is not set");
        }
        if (this.environment == Environment.custom && this.customEnvironment == null) {
            throw new EPPCodecException("customEnvironment required attribute is not set when environment is \"custom\"");
        }
        if (this.startDate == null) {
            throw new EPPCodecException("startDate required attribute is not set");
        }
        if (this.endDate == null) {
            throw new EPPCodecException("endDate required attribute is not set");
        }
        if (this.environment == null) {
            throw new EPPCodecException("environment required attribute is not set");
        }
        if (this.reason == null) {
            throw new EPPCodecException("reason required attribute is not set");
        }
        if (this.createdDate == null) {
            throw new EPPCodecException("createdDate required attribute is not set");
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPMaintenance.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.maintenanceId);
        EPPUtil.encodeCompList(aDocument, root, this.types);
        if (this.hasPollType()) {
            EPPUtil.encodeString(aDocument, root, this.pollType.toString(), "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:pollType");
        }
        Element systemsElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:systems");
        root.appendChild(systemsElm);
        EPPUtil.encodeCompList(aDocument, systemsElm, this.systems);
        Element environmentElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:environment");
        root.appendChild(environmentElm);
        environmentElm.setAttribute("type", this.environment.toString());
        if (this.environment == Environment.custom) {
            environmentElm.setAttribute(ATTR_ENVIRONMENT_CUSTOM, this.customEnvironment);
        }
        EPPUtil.encodeTimeInstant(aDocument, root, this.startDate, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:start");
        EPPUtil.encodeTimeInstant(aDocument, root, this.endDate, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:end");
        EPPUtil.encodeString(aDocument, root, this.reason.toString(), "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:reason");
        EPPUtil.encodeString(aDocument, root, this.detail, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:detail");
        EPPUtil.encodeCompList(aDocument, root, this.descriptions);
        if (this.tlds != null) {
            Element tldsElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:tlds");
            root.appendChild(tldsElm);
            EPPUtil.encodeStringList(aDocument, tldsElm, this.tlds, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:tld");
        }
        EPPUtil.encodeComp(aDocument, root, this.intervention);
        EPPUtil.encodeTimeInstant(aDocument, root, this.createdDate, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:crDate");
        EPPUtil.encodeTimeInstant(aDocument, root, this.lastUpdatedDate, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:upDate");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element tldsElm;
        Element pollTypeElm;
        this.maintenanceId = (EPPMaintenanceId)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "id", EPPMaintenanceId.class);
        this.types = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "type", EPPMaintenanceType.class);
        if (this.types.size() == 0) {
            this.types = null;
        }
        this.pollType = (pollTypeElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_POLL_TYPE)) != null ? PollType.valueOf(EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_POLL_TYPE)) : null;
        Element systemsElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_SYSTEMS);
        this.systems = EPPUtil.decodeCompList(systemsElm, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "system", EPPMaintenanceSystem.class);
        Element environmentElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_ENVIRONMENT);
        String environmentStr = environmentElm.getAttribute("type");
        this.environment = Environment.valueOf(environmentStr);
        if (this.environment == Environment.custom) {
            this.customEnvironment = environmentElm.getAttribute(ATTR_ENVIRONMENT_CUSTOM);
        }
        this.startDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_START_DATE);
        this.endDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_END_DATE);
        this.reason = Reason.valueOf(EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_REASON));
        this.detail = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_DETAIL);
        this.descriptions = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_DESCRIPTION, EPPMaintenanceDescription.class);
        if (this.descriptions.size() == 0) {
            this.descriptions = null;
        }
        this.tlds = (tldsElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_TLDS)) != null ? EPPUtil.decodeList(tldsElm, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_TLD) : null;
        this.intervention = (EPPMaintenanceIntervention)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "intervention", EPPMaintenanceIntervention.class);
        this.createdDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_CREATED_DATE);
        this.lastUpdatedDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_LAST_UPDATED_DATE);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPMaintenanceItem)) {
            return false;
        }
        EPPMaintenanceItem other = (EPPMaintenanceItem)aObject;
        if (!EqualityUtil.equals(this.maintenanceId, other.maintenanceId)) {
            cat.error("EPPMaintenance.equals(): maintenanceId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.types, other.types)) {
            cat.error("EPPMaintenance.equals(): types not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.pollType, (Object)other.pollType)) {
            cat.error("EPPMaintenance.equals(): pollType not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.systems, other.systems)) {
            cat.error("EPPMaintenance.equals(): systems not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.environment, (Object)other.environment)) {
            cat.error("EPPMaintenance.equals(): environment not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.customEnvironment, other.customEnvironment)) {
            cat.error("EPPMaintenance.equals(): customEnvironment not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.startDate, other.startDate)) {
            cat.error("EPPMaintenance.equals(): startDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.endDate, other.endDate)) {
            cat.error("EPPMaintenance.equals(): endDate not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.reason, (Object)other.reason)) {
            cat.error("EPPMaintenance.equals(): reason not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.detail, other.detail)) {
            cat.error("EPPMaintenance.equals(): detail not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.descriptions, other.descriptions)) {
            cat.error("EPPMaintenance.equals(): descriptions not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.tlds, other.tlds)) {
            cat.error("EPPMaintenance.equals(): tlds not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.intervention, other.intervention)) {
            cat.error("EPPMaintenance.equals(): intervention not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createdDate, other.createdDate)) {
            cat.error("EPPMaintenance.equals(): createdDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lastUpdatedDate, other.lastUpdatedDate)) {
            cat.error("EPPMaintenance.equals(): lastUpdatedDate not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPMaintenanceItem clone = null;
        clone = (EPPMaintenanceItem)super.clone();
        if (this.types != null) {
            clone.types = new ArrayList<EPPMaintenanceType>();
            clone.types.addAll(this.types);
        } else {
            clone.descriptions = null;
        }
        clone.systems = new ArrayList<EPPMaintenanceSystem>();
        clone.systems.addAll(this.systems);
        if (this.descriptions != null) {
            clone.descriptions = new ArrayList<EPPMaintenanceDescription>();
            clone.descriptions.addAll(this.descriptions);
        } else {
            clone.descriptions = null;
        }
        if (this.tlds != null) {
            clone.tlds = new ArrayList<String>();
            clone.tlds.addAll(this.tlds);
        } else {
            clone.tlds = null;
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:maintenance-1.0";
    }

    public static enum Reason {
        planned,
        emergency;

    }

    public static enum Environment {
        production,
        ote,
        staging,
        dev,
        custom;

    }

    public static enum PollType {
        create,
        update,
        delete,
        courtesy,
        end;

    }
}

