/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.maintenance.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPMaintenanceIntervention
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPMaintenanceIntervention.class);
    public static final String ELM_LOCALNAME = "intervention";
    public static final String ELM_NAME = "maint:intervention";
    private static final String ELM_CONNECTION = "connection";
    private static final String ELM_IMPLEMENTATION = "implementation";
    private boolean connection = true;
    private boolean implementation = true;

    public EPPMaintenanceIntervention() {
    }

    public EPPMaintenanceIntervention(boolean aConnection, boolean aImplementation) {
        this.connection = aConnection;
        this.implementation = aImplementation;
    }

    public boolean isConnection() {
        return this.connection;
    }

    public void setConnection(boolean aConnection) {
        this.connection = aConnection;
    }

    public boolean isImplementation() {
        return this.implementation;
    }

    public void setImplementation(boolean aImplementation) {
        this.implementation = aImplementation;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_NAME);
        EPPUtil.encodeBoolean(aDocument, root, this.connection, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:connection");
        EPPUtil.encodeBoolean(aDocument, root, this.implementation, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:implementation");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Boolean theVal = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_CONNECTION);
        if (theVal == null) {
            throw new EPPDecodeException("Required element connection does not exist");
        }
        this.connection = theVal;
        theVal = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_IMPLEMENTATION);
        if (theVal == null) {
            throw new EPPDecodeException("Required element implementation does not exist");
        }
        this.implementation = theVal;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPMaintenanceIntervention)) {
            return false;
        }
        EPPMaintenanceIntervention other = (EPPMaintenanceIntervention)aObject;
        if (!EqualityUtil.equals(this.connection, other.connection)) {
            cat.error("EPPMaintenanceIntervention.equals(): connection not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.implementation, other.implementation)) {
            cat.error("EPPMaintenanceIntervention.equals(): implementation not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPMaintenanceIntervention clone = null;
        clone = (EPPMaintenanceIntervention)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:maintenance-1.0";
    }
}

