/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launch.EPPLaunchPhase;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPLaunchInfo
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPLaunchInfo.class);
    public static final String ELM_LOCALNAME = "info";
    public static final String ELM_NAME = "launch:info";
    private static final String ELM_APPLICATION_ID = "applicationID";
    private static final String ATTR_INCLUDE_MARK = "includeMark";
    EPPLaunchPhase phase;
    String applicationId;
    boolean includeMark = false;

    public EPPLaunchInfo() {
    }

    public EPPLaunchInfo(EPPLaunchPhase aPhase) {
        this.phase = aPhase;
    }

    public EPPLaunchInfo(EPPLaunchPhase aPhase, String aApplicationId) {
        this.phase = aPhase;
        this.applicationId = aApplicationId;
    }

    public EPPLaunchPhase getPhase() {
        return this.phase;
    }

    public void setPhase(EPPLaunchPhase aPhase) {
        this.phase = aPhase;
    }

    public void setPhase(String aPhaseString) {
        this.phase = new EPPLaunchPhase(aPhaseString);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String aApplicationId) {
        this.applicationId = aApplicationId;
    }

    public boolean isIncludeMark() {
        return this.includeMark;
    }

    public void setIncludeMark(boolean aIncludeMark) {
        this.includeMark = aIncludeMark;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchInfo clone = (EPPLaunchInfo)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchInfo.encode(Document)");
        }
        if (this.phase == null) {
            throw new EPPEncodeException("EPPLaunchInfo phase attribute must be set.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        if (this.includeMark) {
            root.setAttribute(ATTR_INCLUDE_MARK, "1");
        } else {
            root.setAttribute(ATTR_INCLUDE_MARK, "0");
        }
        EPPUtil.encodeComp(aDocument, root, this.phase);
        EPPUtil.encodeString(aDocument, root, this.applicationId, "urn:ietf:params:xml:ns:launch-1.0", "launch:applicationID");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.includeMark = false;
        String includeMarkVal = aElement.getAttribute(ATTR_INCLUDE_MARK);
        if (includeMarkVal != null && (includeMarkVal.equals("1") || includeMarkVal.equalsIgnoreCase("true"))) {
            this.includeMark = true;
        }
        this.phase = (EPPLaunchPhase)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:launch-1.0", "launch:phase", EPPLaunchPhase.class);
        if (this.phase == null) {
            throw new EPPDecodeException("EPPLaunchInfo phase element not found.");
        }
        this.applicationId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_APPLICATION_ID);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchInfo)) {
            cat.error("EPPLaunchInfo.equals(): " + aObject.getClass().getName() + " not EPPLaunchInfo instance");
            return false;
        }
        EPPLaunchInfo other = (EPPLaunchInfo)aObject;
        if (!EqualityUtil.equals(this.includeMark, other.includeMark)) {
            cat.error("EPPLaunchInfo.equals(): includeMark not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.phase, other.phase)) {
            cat.error("EPPLaunchInfo.equals(): phase not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.applicationId, other.applicationId)) {
            cat.error("EPPLaunchInfo.equals(): applicationId not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:launch-1.0";
    }
}

