/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idnmap;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPIdnMap
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPIdnMap.class);
    public static final String ELM_LOCALNAME = "data";
    public static final String ELM_NAME = "idn:data";
    private static final String ELM_TABLE = "table";
    private static final String ELM_UNAME = "uname";
    private String table;
    private String uname;

    public EPPIdnMap() {
    }

    public EPPIdnMap(String aTable) {
        this.setTable(aTable);
    }

    public EPPIdnMap(String aTable, String aUname) {
        this.setTable(aTable);
        this.setUname(aUname);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String aTable) {
        this.table = aTable;
    }

    public boolean hasUname() {
        return this.uname != null;
    }

    public String getUname() {
        return this.uname;
    }

    public void setUname(String aUname) {
        this.uname = aUname;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:idn-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.table, "urn:ietf:params:xml:ns:idn-1.0", "idn:table");
        EPPUtil.encodeString(aDocument, root, this.uname, "urn:ietf:params:xml:ns:idn-1.0", "idn:uname");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.table = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:idn-1.0", ELM_TABLE);
        this.uname = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:idn-1.0", ELM_UNAME);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIdnMap clone = (EPPIdnMap)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIdnMap)) {
            return false;
        }
        EPPIdnMap other = (EPPIdnMap)aObject;
        if (!EqualityUtil.equals(this.table, other.table)) {
            cat.error("EPPIdnMap.equals(): table not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.uname, other.uname)) {
            cat.error("EPPIdnMap.equals(): uname not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:idn-1.0";
    }
}

