/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idnext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPIdnLangTag
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPIdnLangTag.class);
    public static final String ELM_NAME = "idnLang:tag";
    private String lang;

    public EPPIdnLangTag() {
    }

    public EPPIdnLangTag(String aLang) {
        this.lang = aLang;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIdnLangTag clone = null;
        clone = (EPPIdnLangTag)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPIdnLangTag.encode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPIdnLangTag invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPIdnLangTag.encode(Document)");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/idnLang-1.0", ELM_NAME);
        root.setAttribute("xmlns:idnLang", "http://www.verisign.com/epp/idnLang-1.0");
        Text langText = aDocument.createTextNode(this.lang);
        root.appendChild(langText);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Text langText = (Text)aElement.getFirstChild();
        this.lang = langText.getData();
    }

    void validateState() throws EPPCodecException {
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIdnLangTag)) {
            return false;
        }
        EPPIdnLangTag theComp = (EPPIdnLangTag)aObject;
        return this.lang.equalsIgnoreCase(theComp.getLang());
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String aLang) {
        this.lang = aLang;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/idnLang-1.0";
    }
}

