/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.host;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCreateCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.host.EPPHostAddress;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPHostCreateCmd
extends EPPCreateCmd {
    static final String ELM_NAME = "host:create";
    private static final String ELM_HOST_NAME = "host:name";
    private String name = null;
    private Vector addresses = null;

    public EPPHostCreateCmd() {
        this.name = null;
        this.addresses = null;
    }

    public EPPHostCreateCmd(String aTransId, String aName) {
        super(aTransId);
        this.name = aName;
        this.addresses = null;
    }

    public EPPHostCreateCmd(String aTransId, String aName, Vector someAddresses) {
        super(aTransId);
        this.name = aName;
        this.addresses = someAddresses;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:host-1.0";
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("required attribute name is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("EPPHostCreateCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_NAME);
        root.setAttribute("xmlns:host", "urn:ietf:params:xml:ns:host-1.0");
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:host-1.0", ELM_HOST_NAME);
        EPPUtil.encodeCompVector(aDocument, root, this.addresses);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_HOST_NAME);
        this.addresses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:host-1.0", "host:addr", EPPHostAddress.class);
        if (this.addresses.size() == 0) {
            this.addresses = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public Vector getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Vector aAddresses) {
        this.addresses = aAddresses;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPHostCreateCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPHostCreateCmd theComp = (EPPHostCreateCmd)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        return EPPUtil.equalVectors(this.addresses, theComp.addresses);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPHostCreateCmd clone = (EPPHostCreateCmd)super.clone();
        if (this.addresses != null) {
            clone.addresses = (Vector)this.addresses.clone();
            for (int i = 0; i < this.addresses.size(); ++i) {
                clone.addresses.setElementAt(((EPPHostAddress)this.addresses.elementAt(i)).clone(), i);
            }
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

