/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPTransId
implements EPPCodecComponent {
    public static final int MIN_TRANSID_LEN = 3;
    public static final int MAX_TRANSID_LEN = 64;
    static final String ELM_NAME = "trID";
    private static final String ELM_CLIENT_TRANSID = "clTRID";
    private static final String ELM_SERVER_TRANSID = "svTRID";
    private static Logger cat = LoggerFactory.getLogger(EPPTransId.class);
    private String clientTransId;
    private String serverTransId;
    private String rootName = "trID";
    private String rootNS = "urn:ietf:params:xml:ns:epp-1.0";
    private String rootPrefix = "";

    public EPPTransId() {
        this.clientTransId = null;
        this.serverTransId = null;
    }

    public EPPTransId(String aServerTransId) {
        this.clientTransId = null;
        this.serverTransId = aServerTransId;
    }

    public EPPTransId(String aClientTransId, String aServerTransId) {
        this.clientTransId = aClientTransId;
        this.serverTransId = aServerTransId;
    }

    public EPPTransId(String aRootNS, String aRootName, String aClientTransId, String aServerTransId) {
        this.setRootName(aRootNS, aRootName);
        this.clientTransId = aClientTransId;
        this.serverTransId = aServerTransId;
    }

    public String getRootNS() {
        return this.rootNS;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String aRootNS, String aRootName) {
        this.rootNS = aRootNS;
        this.rootName = aRootName;
        this.rootPrefix = EPPUtil.getPrefix(aRootName);
        if (this.rootPrefix.length() != 0) {
            this.rootPrefix = this.rootPrefix + ":";
        }
    }

    public String getClientTransId() {
        return this.clientTransId;
    }

    public void setClientTransId(String aClientTransId) {
        this.clientTransId = aClientTransId;
    }

    public String getServerTransId() {
        return this.serverTransId;
    }

    public void setServerTransId(String aServerTransId) {
        this.serverTransId = aServerTransId;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.serverTransId == null) {
            throw new EPPEncodeException("EPPTransId required attribute \"server tranaction id\" is null.");
        }
        if (this.serverTransId.length() < 3 || this.serverTransId.length() > 64) {
            throw new EPPEncodeException("EPPTransId server transaction id length of " + this.serverTransId.length() + "is out of range, must be between " + 3 + " and " + 64);
        }
        if (this.clientTransId != null && (this.clientTransId.length() < 3 || this.clientTransId.length() > 64)) {
            throw new EPPEncodeException("EPPTransId client transaction id length of " + this.clientTransId.length() + "is out of range, must be between " + 3 + " and " + 64);
        }
        Element root = aDocument.createElementNS(this.rootNS, this.rootName);
        EPPUtil.encodeString(aDocument, root, this.clientTransId, "urn:ietf:params:xml:ns:epp-1.0", ELM_CLIENT_TRANSID);
        EPPUtil.encodeString(aDocument, root, this.serverTransId, "urn:ietf:params:xml:ns:epp-1.0", ELM_SERVER_TRANSID);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.setRootName(aElement.getNamespaceURI(), aElement.getTagName());
        this.clientTransId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_CLIENT_TRANSID);
        this.serverTransId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_SERVER_TRANSID);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPTransId)) {
            cat.error("EPPTransId.equals(): " + aObject.getClass().getName() + " not EPPTransId instance");
            return false;
        }
        EPPTransId theTransId = (EPPTransId)aObject;
        if (!this.rootNS.equals(theTransId.rootNS)) {
            cat.error("EPPTransId.equals(): rootNS not equal");
            return false;
        }
        if (!EPPUtil.getLocalName(this.rootName).equals(EPPUtil.getLocalName(theTransId.rootName))) {
            cat.error("EPPTransId.equals(): rootName not equal");
            return false;
        }
        if (!(this.clientTransId != null ? this.clientTransId.equals(theTransId.clientTransId) : theTransId.clientTransId == null)) {
            cat.error("EPPTransId.equals(): clientTransId not equal");
            return false;
        }
        if (!(this.serverTransId != null ? this.serverTransId.equals(theTransId.serverTransId) : theTransId.serverTransId == null)) {
            cat.error("EPPTransId.equals(): serverTransId not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPTransId clone = null;
        clone = (EPPTransId)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp-1.0";
    }
}

