/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPComponentNotFoundException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPDuplicateExtensionException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EPPCommand
implements EPPMessage {
    public static final String TYPE_LOGIN = "login";
    public static final String TYPE_LOGOUT = "logout";
    public static final String TYPE_INFO = "info";
    public static final String TYPE_CHECK = "check";
    public static final String TYPE_TRANSFER = "transfer";
    public static final String TYPE_CREATE = "create";
    public static final String TYPE_DELETE = "delete";
    public static final String TYPE_RENEW = "renew";
    public static final String TYPE_UPDATE = "update";
    public static final String TYPE_POLL = "poll";
    public static final String OP_APPROVE = "approve";
    public static final String OP_CANCEL = "cancel";
    public static final String OP_QUERY = "query";
    public static final String OP_REJECT = "reject";
    public static final String OP_REQUEST = "request";
    static final String ELM_NAME = "command";
    private static final String ELM_TRANS_ID = "clTRID";
    private static final String ELM_EXTENSION = "extension";
    static final String ATT_OP = "op";
    private static Logger cat = LoggerFactory.getLogger(EPPCommand.class);
    protected String transId = null;
    protected Vector extensions = null;

    public EPPCommand() {
        this.transId = null;
        this.extensions = null;
    }

    public EPPCommand(String aTransId) {
        this.transId = aTransId;
        this.extensions = null;
    }

    public boolean hasTransId() {
        return this.transId != null;
    }

    public String getTransId() {
        return this.transId;
    }

    public void setTransId(String aTransId) {
        this.transId = aTransId;
    }

    @Override
    public abstract String getNamespace();

    public abstract String getType();

    public String getOp() {
        return null;
    }

    public boolean hasExtension(Class aExtensionClass) {
        return this.getExtension(aExtensionClass) != null;
    }

    public EPPCodecComponent getExtension(Class aExtensionClass) {
        if (this.extensions == null) {
            return null;
        }
        for (EPPCodecComponent theExtension : this.extensions) {
            if (!aExtensionClass.isInstance(theExtension)) continue;
            return theExtension;
        }
        return null;
    }

    public EPPCodecComponent getExtension(Class aExtensionClass, boolean aFailOnDuplicate) throws EPPDuplicateExtensionException {
        EPPCodecComponent theExtension = null;
        if (this.extensions == null) {
            return null;
        }
        for (EPPCodecComponent currExtension : this.extensions) {
            if (!aExtensionClass.isInstance(currExtension)) continue;
            if (theExtension != null && aFailOnDuplicate) {
                throw new EPPDuplicateExtensionException(currExtension);
            }
            theExtension = currExtension;
            if (aFailOnDuplicate) continue;
            return theExtension;
        }
        return theExtension;
    }

    @Deprecated
    public void setExtension(EPPCodecComponent aExtension) {
        this.addExtension(aExtension);
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Set<String> findDuplicateExtNamespaces() {
        return EPPUtil.findDuplicateExtNamespaces(this.extensions);
    }

    public Set<String> findUnsupportedExtNamespaces(List<String> aSupportedExtNamespaces) {
        return EPPUtil.findUnsupportedExtNamespaces(aSupportedExtNamespaces, this.extensions);
    }

    public Set<String> findUnsupportedExtNamespaceSuffixes(List<String> aSupportedExtNamespaceSuffixes) {
        return EPPUtil.findUnsupportedExtNamespaceSuffixes(aSupportedExtNamespaceSuffixes, this.extensions);
    }

    public Set<String> findExtNamespaces(List<String> aFilterExtNamespaces) {
        return EPPUtil.findExtNamespaces(this.extensions, aFilterExtNamespaces);
    }

    public Set<String> findExtNamespaceSuffixes(List<String> aFilterExtNamespaceSuffixes) {
        return EPPUtil.findExtNamespaceSuffixes(this.extensions, aFilterExtNamespaceSuffixes);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.transId != null && (this.transId.length() < 3 || this.transId.length() > 64)) {
            throw new EPPEncodeException("EPPCommand transaction id length of " + this.transId.length() + "is out of range, must be between " + 3 + " and " + 64);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        Element mapping = this.doGenEncode(aDocument);
        if (mapping != null) {
            root.appendChild(mapping);
        }
        if (this.hasExtensions()) {
            Element extensionElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_EXTENSION);
            root.appendChild(extensionElm);
            EPPUtil.encodeCompVector(aDocument, extensionElm, this.extensions);
        }
        EPPUtil.encodeString(aDocument, root, this.transId, "urn:ietf:params:xml:ns:epp-1.0", ELM_TRANS_ID);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException, EPPComponentNotFoundException {
        Element theCurrElement = null;
        theCurrElement = EPPUtil.getFirstElementChild(aElement);
        if (theCurrElement == null) {
            throw new EPPDecodeException("No child Element found");
        }
        this.doGenDecode(theCurrElement);
        Element extensionElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_EXTENSION);
        if (extensionElm != null) {
            Element currExtension = EPPUtil.getFirstElementChild(extensionElm);
            while (currExtension != null) {
                EPPCodecComponent theExtension = null;
                try {
                    theExtension = EPPFactory.getInstance().createExtension(currExtension);
                }
                catch (EPPCodecException e) {
                    throw new EPPComponentNotFoundException(3, "EPPCommand.decode unable to create extension object: " + e);
                }
                theExtension.decode(currExtension);
                this.addExtension(theExtension);
                currExtension = EPPUtil.getNextElementSibling(currExtension);
            }
        }
        this.transId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_TRANS_ID);
    }

    public boolean equals(Object aObject) {
        EPPCommand theCommand = (EPPCommand)aObject;
        if (!(this.transId != null ? this.transId.equals(theCommand.transId) : theCommand.transId == null)) {
            return false;
        }
        return EPPUtil.equalVectors(this.extensions, theCommand.extensions);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPCommand clone = null;
        clone = (EPPCommand)super.clone();
        if (this.extensions != null) {
            clone.extensions = (Vector)this.extensions.clone();
            for (int i = 0; i < this.extensions.size(); ++i) {
                clone.extensions.setElementAt(((EPPCodecComponent)this.extensions.elementAt(i)).clone(), i);
            }
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    protected abstract Element doGenEncode(Document var1) throws EPPEncodeException;

    protected abstract void doGenDecode(Element var1) throws EPPDecodeException;
}

