/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPFeeCredit
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPFeeCredit.class);
    public static final String ELM_LOCALNAME = "credit";
    public static final String ELM_NAME = "fee:credit";
    public static final String DEFAULT_LANG = "en";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_LANG = "lang";
    private String description;
    private String language = "en";
    private BigDecimal credit;

    public EPPFeeCredit() {
    }

    public EPPFeeCredit(BigDecimal aCredit) {
        this.setCredit(aCredit);
    }

    public EPPFeeCredit(BigDecimal aCredit, String aDescription) {
        this.setCredit(aCredit);
        this.setDescription(aDescription);
    }

    public EPPFeeCredit(BigDecimal aCredit, String aDescription, String aLanguage) {
        this(aCredit, aDescription);
        this.setLanguage(aLanguage);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
        cat.debug("setDescription: description = " + this.description);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String aLanguage) {
        this.language = aLanguage == null ? DEFAULT_LANG : aLanguage;
    }

    public BigDecimal getCredit() {
        return this.credit;
    }

    public void setCredit(BigDecimal aCredit) {
        if (aCredit != null) {
            this.credit = aCredit;
            this.credit.setScale(2, RoundingMode.HALF_UP);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeCredit clone = null;
        clone = (EPPFeeCredit)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theDescription = aElement.getAttribute(ATTR_DESCRIPTION);
        this.description = theDescription != null && !theDescription.isEmpty() ? theDescription : null;
        this.setLanguage(aElement.getAttribute(ATTR_LANG));
        this.credit = EPPUtil.decodeBigDecimal(aElement);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeCredit.encode(Document)");
        }
        if (this.credit == null) {
            throw new EPPEncodeException("fee is null on in EPPFeeCredit.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:fee-1.0", ELM_NAME);
        if (this.description != null) {
            root.setAttribute(ATTR_DESCRIPTION, this.description);
            if (!this.language.equals(DEFAULT_LANG)) {
                root.setAttribute(ATTR_LANG, this.language);
            }
        }
        EPPUtil.encodeBigDecimal(aDocument, root, this.credit, null);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeCredit)) {
            return false;
        }
        EPPFeeCredit other = (EPPFeeCredit)aObject;
        if (!EqualityUtil.equals(this.description, other.description)) {
            cat.error("EPPFeeCredit.equals(): description not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.language, other.language)) {
            cat.error("EPPFeeCredit.equals(): language not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.credit, other.credit)) {
            cat.error("EPPFeeCredit.equals(): credit not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:fee-1.0";
    }
}

