/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/

package com.verisign.epp.codec.namestoreext;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;

/**
 * Namestore &lt;namestoreExt&gt; extension, which allows for a client to provide
 * a target sub-product identifier to specify the locus of operation for the
 * accompanying command. <br>
 * <br>
 */
public class EPPNamestoreExtNamestoreExt implements EPPCodecComponent {

	/**
	 * XML local name for {@code EPPNamestoreExtNamestoreExt}.
	 */
	public static final String ELM_LOCALNAME = "namestoreExt";

	/** XML root tag for {@code EPPNamestoreExtNamestoreExt}. */
	public static final String ELM_NAME = EPPNamestoreExtExtFactory.NS_PREFIX
			+ ":" + ELM_LOCALNAME;

	/** XML tag name for the {@code _subProductID} attribute. */
	private static final String ELM_SUB_PRODUCT_ID = "subProduct";

	/** Sub-Product Identifier. */
	private String _subProductID;

	/**
	 * Default constructor for {@code EPPNamestoreExtNamestoreExt}.
	 */
	public EPPNamestoreExtNamestoreExt() {
		_subProductID = null;
	}


	/**
	 * Constructor for {@code EPPNamestoreExtNamestoreExt} that takes the
	 * sub-product identifier.
	 * 
	 * @param aSubProductID
	 *            Sub-product identifier
	 */
	public EPPNamestoreExtNamestoreExt(String aSubProductID) {
		_subProductID = aSubProductID;
	}


	/**
	 * Gets the Namestore Destination Registry Identifier.
	 * 
	 * @return Registry identifier if defined; {@code null} otherwise.
	 */
	public String getSubProductID() {
		return _subProductID;
	}


	/**
	 * Sets the Namestore Destination Registry Identifier.
	 * 
	 * @param aSubProductID
	 *            Registry Identifier
	 */
	public void setSubProductID(String aSubProductID) {
		_subProductID = aSubProductID;
	}


	/**
	 * encode instance into a DOM element tree. A DOM Document is passed as an
	 * argument and functions as a factory for DOM objects. The root element
	 * associated with the instance is created and each instance attribute is
	 * appended as a child node.
	 * 
	 * @param aDocument
	 *            DOM Document, which acts is an Element factory
	 * 
	 * @return Element Root element associated with the object
	 * 
	 * @exception EPPEncodeException
	 *                Error encoding {@code EPPNamestoreExtNamestoreExt}
	 */
	public Element encode(Document aDocument) throws EPPEncodeException {
		// Validate state
		if (_subProductID == null) {
			throw new EPPEncodeException(
					"subProductID required attribute is not set");
		}

		Element root = aDocument.createElementNS(EPPNamestoreExtExtFactory.NS,
				ELM_NAME);
		root.setAttribute("xmlns:namestoreExt", EPPNamestoreExtExtFactory.NS);

		EPPUtil.encodeString(aDocument, root, _subProductID,
				EPPNamestoreExtExtFactory.NS,
				EPPNamestoreExtExtFactory.NS_PREFIX + ":" + ELM_SUB_PRODUCT_ID);

		return root;
	}


	/**
	 * decode a DOM element tree to initialize the instance attributes. The
	 * {@code aElement} argument represents the root DOM element and is
	 * used to traverse the DOM nodes for instance attribute values.
	 * 
	 * @param aElement
	 *            {@code Element} to decode
	 * 
	 * @exception EPPDecodeException
	 *                Error decoding {@code Element}
	 */
	public void decode(Element aElement) throws EPPDecodeException {
		_subProductID = EPPUtil.decodeString(aElement,
				EPPNamestoreExtExtFactory.NS, ELM_SUB_PRODUCT_ID);
	}


	/**
	 * clone an {@code EPPCodecComponent}.
	 * 
	 * @return clone of concrete {@code EPPNamestoreExtNamestoreExt}
	 * 
	 * @exception CloneNotSupportedException
	 *                standard Object.clone exception
	 */
	public Object clone() throws CloneNotSupportedException {
		EPPNamestoreExtNamestoreExt clone = (EPPNamestoreExtNamestoreExt) super
				.clone();

		return clone;
	}


	/**
	 * Implementation of {@code Object.toString}, which will result in an
	 * indented XML {@code String} representation of the concrete
	 * {@code EPPCodecComponent}.
	 * 
	 * @return Indented XML {@code String} if successful;
	 *         {@code ERROR} otherwise.
	 */
	public String toString() {
		return EPPUtil.toString(this);
	}

	// End EPPNamestorExtNamestoreExt.toString()

	/**
	 * Compare an instance of {@code EPPNamestoreExtNamestoreExt} with this
	 * instance.
	 * 
	 * @param aObject
	 *            Object to compare with.
	 * 
	 * @return {@code true} if equal; {@code false} otherwise.
	 */
	public boolean equals(Object aObject) {
		if (!(aObject instanceof EPPNamestoreExtNamestoreExt)) {
			return false;
		}

		EPPNamestoreExtNamestoreExt theComp = (EPPNamestoreExtNamestoreExt) aObject;

		if (!((_subProductID == null) ? (theComp._subProductID == null)
				: _subProductID.equals(theComp._subProductID))) {
			return false;
		}

		return true;
	}

 	/**
 	 * Returns the XML namespace associated with the {@code EPPCodecComponent}.
 	 * 
 	 * @return XML namespace for the {@code EPPCodecComponent}. 
 	 */
 	@Override
 	public String getNamespace() {
 		return EPPNamestoreExtExtFactory.NS;
 	}
}

