/***********************************************************
Copyright (C) 2019 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.util;

import java.io.IOException;

import org.apache.log4j.Logger;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Entity resolver that throws an exception for all methods to ensure that any
 * attempt to resolve an entity fails.
 */
public class EPPDisabledEntityResolver implements XMLEntityResolver, EntityResolver {

	private static Logger cat = Logger.getLogger(EPPDisabledEntityResolver.class.getName(),
	      EPPCatFactory.getInstance().getFactory());

	/**
	 * Creates a new EPPSchemaParsingEntityResolver object.
	 */
	public EPPDisabledEntityResolver() {
		cat.debug("EPPDisabledEntityResolver()");
	}

	/**
	 * Resolves the entity passed in when parsing the instance document. Will
	 * throw an {@code IOException}.
	 *
	 * @param aXMLResourceIdentifier
	 *           XML schema to load
	 *
	 * @return Nothing will be returned, since it will throw an
	 *         {@code IOException}.
	 *
	 * @throws org.apache.xerces.xni.XNIException Never thrown
	 * @throws java.io.IOException
	 *            Thrown with the message &quot;resolving entity disallowed&quot;.
	 */
	public XMLInputSource resolveEntity(XMLResourceIdentifier aXMLResourceIdentifier)
	      throws org.apache.xerces.xni.XNIException, java.io.IOException {
		cat.debug("EPPDisabledEntityResolver.resolveEntity(XMLResourceIdentifier): Resolving entity"
		      + aXMLResourceIdentifier + " disallowed");

		throw new IOException("resolving entity disallowed");
	}

	/**
	 * Resolves the entity passed in when parsing the instance document. Will
	 * throw an {@code SAXException}.
	 *
	 * @param aPublicId
	 *           Public identifier of entity
	 * @param aSystemId
	 *           System identifier of entity
	 *
	 * @return Nothing will be returned, since it will throw an
	 *         {@code SAXException}.
	 *
	 * @throws SAXException
	 *            Thrown with the message &quot;resolving entity disallowed&quot;.
	 * @throws IOException
	 *            Not thrown
	 * @throws XNIException
	 *            Not thrown
	 */
	public InputSource resolveEntity(String aPublicId, String aSystemId) throws SAXException, IOException {
		cat.debug("EPPDisabledEntityResolver.resolveEntity(String, String): Resolving entity publicId: " + aPublicId
		      + ", systemId: " + aSystemId + " disallowed");
		throw new SAXException("resolving entity disallowed");
	}

}
