/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.exception;


/**
 * Represents the base class for all EPP package exceptions.  
 */
public class EPPException extends Exception {
	/**
	 * Constructor for {@code EPPException} that requires a info
	 * {@code String} description.
	 *
	 * @param info text description
	 */
	public EPPException(String info) {
		super(info);
	}
	
	/**
	 * Constructor for {@code EPPException} that requires a info
	 * {@code String} description and a cause {@code Throwable}.
	 *
	 * @param info text description
	 * @param cause Cause of the {@code EPPException}
	 */
	public EPPException(String info, Throwable cause) {
		super(info, cause);
	}
	
}


