/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.registry.policy.EPPRegistryZoneInterface;
import com.verisign.epp.framework.EPPRegistryPolicyAdapter;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class RegistryPolicyCompositeAdapter {
    private static Logger cat = Logger.getLogger((String)RegistryPolicyCompositeAdapter.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static List<EPPRegistryPolicyAdapter> adapters = new ArrayList<EPPRegistryPolicyAdapter>();

    public List<EPPRegistryZoneInterface> eppExtToZoneExt(List<EPPCodecComponent> aEppExtensions) {
        cat.debug((Object)"eppExtToZoneExt: enter");
        ArrayList<EPPRegistryZoneInterface> theZoneExts = new ArrayList<EPPRegistryZoneInterface>();
        for (EPPRegistryPolicyAdapter theAdapter : adapters) {
            EPPRegistryZoneInterface theZoneExt = theAdapter.eppExtToZoneExt(aEppExtensions);
            if (theZoneExt == null) continue;
            cat.debug((Object)("eppExtToZoneExt: adding zone extension " + theZoneExt.getClass().getName()));
            theZoneExts.add(theZoneExt);
        }
        cat.debug((Object)"eppExtToZoneExt: exit");
        return theZoneExts;
    }

    public List<EPPCodecComponent> zoneExtToEppExt(List<EPPRegistryZoneInterface> aZoneExtensions) {
        cat.debug((Object)"zoneExtToEppExt: enter");
        ArrayList<EPPCodecComponent> TheEppExts = new ArrayList<EPPCodecComponent>();
        for (EPPRegistryPolicyAdapter theAdapter : adapters) {
            EPPCodecComponent theEppExt = theAdapter.zoneExtToEppExt(aZoneExtensions);
            if (theEppExt == null) continue;
            cat.debug((Object)("zoneExtToEppExt: adding EPP extension " + theEppExt.getClass().getName()));
            TheEppExts.add(theEppExt);
        }
        cat.debug((Object)"zoneExtToEppExt: exit");
        return TheEppExts;
    }

    public List<EPPCodecComponent> getSystemExts() {
        cat.debug((Object)"getSystemExts: enter");
        ArrayList<EPPCodecComponent> TheEppExts = new ArrayList<EPPCodecComponent>();
        for (EPPRegistryPolicyAdapter theAdapter : adapters) {
            EPPCodecComponent theEppExt = theAdapter.getSystemExt();
            if (theEppExt == null) continue;
            cat.debug((Object)("getSystemExts: adding EPP extension " + theEppExt.getClass().getName()));
            TheEppExts.add(theEppExt);
        }
        cat.debug((Object)"getSystemExts: exit");
        return TheEppExts;
    }

    static {
        List<String> theAdapters = EPPEnv.getRegistryPolicyAdapters();
        if (theAdapters != null) {
            for (String theAdapter : theAdapters) {
                try {
                    adapters.add((EPPRegistryPolicyAdapter)Class.forName(theAdapter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception ex) {
                    cat.error((Object)("Exception loading EPPRegistryPolicyAdapter class \"" + theAdapter + "\": " + ex));
                }
            }
        }
    }
}

