/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.pool;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.pool.EPPSessionPool;
import com.verisign.epp.pool.EPPSessionPoolException;
import com.verisign.epp.pool.EPPSessionPoolTst;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.TestThread;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPSystemSessionPoolTst
extends EPPSessionPoolTst {
    private static final Logger cat = Logger.getLogger((String)EPPSystemSessionPoolTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPSystemSessionPoolTst(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoSystemPools() {
        EPPSystemSessionPoolTst.printStart("testTwoSystemPools");
        EPPSession theSession1 = null;
        EPPSession theSession2 = null;
        try {
            theSession1 = this.borrowSession("default");
            theSession1.hello();
            theSession2 = this.borrowSession("test");
            theSession2.hello();
            if (theSession1 != null) {
                this.returnSession("default", theSession1);
            }
            if (theSession2 != null) {
                this.returnSession("test", theSession2);
            }
        }
        catch (EPPCommandException ex) {
            try {
                try {
                    sessionPool.invalidateObject("default", theSession1);
                    sessionPool.invalidateObject("test", theSession2);
                    theSession1 = null;
                }
                catch (EPPSessionPoolException ePPSessionPoolException) {
                    // empty catch block
                }
                if (theSession1 != null) {
                    this.returnSession("default", theSession1);
                }
                if (theSession2 != null) {
                    this.returnSession("test", theSession2);
                }
            }
            catch (Throwable throwable) {
                if (theSession1 != null) {
                    this.returnSession("default", theSession1);
                }
                if (theSession2 != null) {
                    this.returnSession("test", theSession2);
                }
                throw throwable;
            }
        }
        EPPSystemSessionPoolTst.printEnd("testTwoSystemPools");
    }

    @Override
    protected void setUp() {
    }

    @Override
    protected void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPSystemSessionPoolTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        try {
            sessionPool = EPPSessionPool.getInstance();
            sessionPool.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Error initializing the session pool: " + ex));
        }
        return suite;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionPoolTst Thread " + i, EPPSessionPoolTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPSessionPoolTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public void handleException(EPPCommandException aException, EPPSession aSession) {
        EPPResponse response = aSession.getResponse();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            aException.printStackTrace();
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    public static void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    protected EPPSession borrowSession(String aSystem) {
        EPPSession theSession = null;
        try {
            theSession = sessionPool.borrowObject(aSystem);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("borrowSession(" + aSystem + "): Exception borrowing session: " + ex));
        }
        return theSession;
    }

    protected void returnSession(String aSystem, EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.returnObject(aSystem, aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("returnSession(): Exception returning session: " + ex));
        }
    }

    protected void invalidateSession(String aSystem, EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.invalidateObject(aSystem, aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("returnSession(): Exception invalidating session: " + ex));
        }
    }
}

