/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.namestore.interfaces;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.host.EPPHostAddress;
import com.verisign.epp.codec.host.EPPHostCheckResp;
import com.verisign.epp.codec.host.EPPHostCheckResult;
import com.verisign.epp.codec.host.EPPHostInfoResp;
import com.verisign.epp.codec.orgext.EPPOrgExtId;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.namestore.interfaces.NSHost;
import com.verisign.epp.pool.EPPSessionPool;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.InvalidateSessionException;
import com.verisign.epp.util.TestThread;
import com.verisign.epp.util.TestUtil;
import java.util.Random;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class NSHostTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)NSHostTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static EPPSessionPool sessionPool = null;
    private Random rd = new Random(System.currentTimeMillis());

    public NSHostTst(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHostCreate() {
        NSHostTst.printStart("testHostCreate");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            String theHostName;
            theSession = this.borrowSession();
            NSHost theHost = new NSHost(theSession);
            try {
                System.out.println("\n----------------------------------------------------------------");
                theHostName = this.makeInternalHost();
                System.out.println("hostCreate: Create internal " + theHostName);
                theHost.setTransId("ABC-12345-XYZ");
                theHost.addHostName(theHostName);
                theHost.setSubProductID("COM");
                theHost.addIPV4Address(this.makeIP());
                theHost.addIPV6Address("1080:0:0:0:8:800:200C:417A");
                theHost.addIPV6Address("::FFFF:129.144.52.38");
                theResponse = theHost.sendCreate();
                System.out.println("hostCreate: Response = [" + theResponse + "]\n\n");
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                theHost.setTransId("ABC-12345-XYZ");
                theHostName = this.makeExternalHost();
                System.out.println("hostCreate: Create " + theHostName + " with all optional attributes");
                theHost.addHostName(theHostName);
                theHost.setSubProductID("COM");
                theResponse = theHost.sendCreate();
                System.out.println("hostCreate: Response = [" + theResponse + "]\n\n");
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSHostTst.printEnd("testHostCreate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHostCheck() {
        NSHostTst.printStart("testHostCheck");
        EPPSession theSession = null;
        EPPHostCheckResp theResponse = null;
        try {
            theSession = this.borrowSession();
            NSHost theHost = new NSHost(theSession);
            try {
                System.out.println("\n----------------------------------------------------------------");
                String theHostName = this.makeInternalHost();
                System.out.println("hostCheck: Check single host name (" + theHostName + ")");
                theHost.setTransId("ABC-12345-XYZ");
                theHost.addHostName(theHostName);
                theHost.setSubProductID("COM");
                theResponse = theHost.sendCheck();
                System.out.println("Response Type = " + theResponse.getType());
                System.out.println("Response.TransId.ServerTransId = " + theResponse.getTransId().getServerTransId());
                System.out.println("Response.TransId.ServerTransId = " + theResponse.getTransId().getClientTransId());
                System.out.println("\nhostCheck: Response = [" + theResponse + "]");
                for (int i = 0; i < theResponse.getCheckResults().size(); ++i) {
                    EPPHostCheckResult currResult = (EPPHostCheckResult)theResponse.getCheckResults().elementAt(i);
                    if (currResult.isAvailable()) {
                        System.out.println("hostCheck: Host " + currResult.getName() + " is available");
                        continue;
                    }
                    System.out.println("hostCheck: Host " + currResult.getName() + " is not available");
                }
                this.handleResponse(theResponse);
            }
            catch (Exception e) {
                TestUtil.handleException(theSession, e);
            }
            try {
                int i;
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("hostCheck: Check multiple host names (ns1.example.com, ns2.example.com, ns3.example.com)");
                theHost.setTransId("ABC-12345-XYZ");
                theHost.addHostName("ns1.example.com");
                theHost.addHostName("ns2.example.com");
                theHost.addHostName("ns3.example.com");
                theHost.setSubProductID("COM");
                for (i = 0; i <= 10; ++i) {
                    theHost.addHostName(this.makeInternalHost());
                }
                theResponse = theHost.sendCheck();
                System.out.println("\nhostCheck: Response = [" + theResponse + "]");
                System.out.println("Client Transaction Id = " + theResponse.getTransId().getClientTransId());
                System.out.println("Server Transaction Id = " + theResponse.getTransId().getServerTransId());
                for (i = 0; i < theResponse.getCheckResults().size(); ++i) {
                    EPPHostCheckResult currResult = (EPPHostCheckResult)theResponse.getCheckResults().elementAt(i);
                    if (currResult.isAvailable()) {
                        System.out.println("hostCheck: Host " + currResult.getName() + " is available");
                        continue;
                    }
                    System.out.println("hostCheck: Host " + currResult.getName() + " is not available");
                }
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException e) {
                TestUtil.handleException(theSession, e);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSHostTst.printEnd("testHostCheck");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHostInfo() {
        NSHostTst.printStart("testHostInfo");
        EPPSession theSession = null;
        EPPHostInfoResp theResponse = null;
        try {
            theSession = this.borrowSession();
            NSHost theHost = new NSHost(theSession);
            try {
                System.out.println("\nhostInfo: Host info");
                theHost.setTransId("ABC-12345-XYZ");
                theHost.addHostName(this.makeInternalHost());
                theHost.setSubProductID("COM");
                theResponse = theHost.sendInfo();
                System.out.println("hostInfo: Response = [" + theResponse + "]\n\n");
                System.out.println("hostInfo: name = " + theResponse.getName());
                System.out.println("hostInfo: client id = " + theResponse.getClientId());
                System.out.println("hostInfo: created by = " + theResponse.getCreatedBy());
                System.out.println("hostInfo: create date = " + theResponse.getCreatedDate());
                if (theResponse.getAddresses() != null) {
                    for (int i = 0; i < theResponse.getAddresses().size(); ++i) {
                        EPPHostAddress currAddress = (EPPHostAddress)theResponse.getAddresses().elementAt(i);
                        System.out.print("hostInfo: address " + (i + 1));
                        System.out.print(" name = " + currAddress.getName());
                        if (currAddress.getType() == 0) {
                            System.out.println(", type = IPV4");
                            continue;
                        }
                        if (currAddress.getType() != 0) continue;
                        System.out.println(", type = IPV6");
                    }
                }
                if (theResponse.getLastUpdatedBy() != null) {
                    System.out.println("hostInfo: last updated by = " + theResponse.getLastUpdatedBy());
                }
                if (theResponse.getLastUpdatedDate() != null) {
                    System.out.println("hostInfo: last updated date = " + theResponse.getLastUpdatedDate());
                }
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSHostTst.printEnd("testHostInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHostDelete() {
        NSHostTst.printStart("testHostDelete");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            theSession = this.borrowSession();
            NSHost theHost = new NSHost(theSession);
            try {
                System.out.println("\nhostDelete: Host delete");
                theHost.setTransId("ABC-12345-XYZ");
                theHost.addHostName(this.makeInternalHost());
                theHost.setSubProductID("COM");
                theResponse = theHost.sendDelete();
                System.out.println("hostDelete: Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSHostTst.printEnd("testHostDelete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHostUpdate() {
        NSHostTst.printStart("testHostUpdate");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            theSession = this.borrowSession();
            NSHost theHost = new NSHost(theSession);
            try {
                theHost.setTransId("ABC-12345-XYZ");
                String theHostName = this.makeInternalHost();
                System.out.println("\nhostUpdate: Host " + theHostName + " update");
                theHost.addHostName(theHostName);
                theHost.setSubProductID("COM");
                theHost.addIPV4Address(this.makeIP());
                theHost.removeIPV6Address("1080:0:0:0:8:800:200C:417A");
                theHost.addStatus("ok", "Hello_World", "en");
                theHost.removeStatus("ok", "Hello World with spaces", "en");
                theResponse = theHost.sendUpdate();
                System.out.println("hostUpdate: Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSHostTst.printEnd("testHostUpdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResellerId() {
        NSHostTst.printStart("testResellerId");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            theSession = this.borrowSession();
            NSHost theHost = new NSHost(theSession);
            try {
                System.out.println("\ntestResellerId: Host create with reseller identifier");
                theHost.setTransId("ABC-12345");
                theHost.addHostName("ns1.reseller.example");
                theHost.setSubProductID("example");
                theHost.addIPV4Address(this.makeIP());
                theHost.addIPV6Address("1080:0:0:0:8:800:200C:417A");
                theHost.addIPV6Address("::FFFF:129.144.52.38");
                theHost.addOrgId(new EPPOrgExtId("reseller", "myreseller"));
                theResponse = theHost.sendCreate();
                System.out.println("testResellerId: Create Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\ntestResellerId: Host update with reseller identifier - ADD");
                theHost.setTransId("ABC-12345-XYZ");
                theHost.addHostName("example1.tld");
                theHost.setSubProductID("tld");
                theHost.addUpdateOrgId(1, new EPPOrgExtId("reseller", "myreseller"));
                theResponse = theHost.sendUpdate();
                System.out.println("testResellerId: ADD Update Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\ntestResellerId: Host update with reseller identifier - CHG");
                theHost.setTransId("ABC-12345-XYZ");
                theHost.addHostName("example1.tld");
                theHost.setSubProductID("tld");
                theHost.addUpdateOrgId(3, new EPPOrgExtId("reseller", "myreseller2"));
                theResponse = theHost.sendUpdate();
                System.out.println("testResellerId: CHG Update Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\ntestResellerId: Host update with reseller identifier - REM");
                theHost.setTransId("ABC-12345-XYZ");
                theHost.addHostName("example1.tld");
                theHost.setSubProductID("tld");
                theHost.addUpdateOrgId(2, new EPPOrgExtId("reseller", "myreseller2"));
                theResponse = theHost.sendUpdate();
                System.out.println("testResellerId: REM Update Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSHostTst.printEnd("testResellerId");
    }

    public void testEndSession() {
        NSHostTst.printStart("testEndSession");
        EPPSession theSession = null;
        try {
            theSession = this.borrowSession();
            sessionPool.invalidateObject(theSession);
            theSession = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("testEndSession(): Exception invalidating session: " + ex));
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSHostTst.printEnd("testEndSession");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        return new NSHostTstSetup((Test)new TestSuite(NSHostTst.class));
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("NSHostTst Thread " + i, NSHostTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)NSHostTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public static void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    public static void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private EPPSession borrowSession() {
        EPPSession theSession = null;
        try {
            theSession = sessionPool.borrowObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("borrowSession(): Exception borrowing session: " + ex));
        }
        return theSession;
    }

    private void returnSession(EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.returnObject(aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("returnSession(): Exception returning session: " + ex));
        }
    }

    private void invalidateSession(EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.invalidateObject(aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("invalidateSession(): Exception invalidating session: " + ex));
        }
    }

    private void handleResponse(EPPResponse aResponse) {
        for (int i = 0; i < aResponse.getResults().size(); ++i) {
            EPPResult theResult = (EPPResult)aResponse.getResults().elementAt(i);
            System.out.println("Result Code    : " + theResult.getCode());
            System.out.println("Result Message : " + theResult.getMessage());
            System.out.println("Result Lang    : " + theResult.getLang());
            if (theResult.isSuccess()) {
                System.out.println("Command Passed ");
            } else {
                System.out.println("Command Failed ");
            }
            if (theResult.getAllValues() == null) continue;
            for (int k = 0; k < theResult.getAllValues().size(); ++k) {
                System.out.println("Result Values  : " + theResult.getAllValues().elementAt(k));
            }
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".com");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeInternalHost(String newDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + newDomainName);
    }

    public String makeInternalHost() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + this.makeDomainName());
    }

    public String makeExternalHost() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + ".sample.biz");
    }

    private static class NSHostTstSetup
    extends TestSetup {
        public NSHostTstSetup(Test aTest) {
            super(aTest);
        }

        protected void setUp() throws Exception {
            super.setUp();
            String theConfigFileName = System.getProperty("EPP.ConfigFile");
            if (theConfigFileName != null) {
                configFileName = theConfigFileName;
            }
            try {
                app.initialize(configFileName);
            }
            catch (EPPCommandException e) {
                e.printStackTrace();
                Assert.fail((String)("Error initializing the EPP Application: " + e));
            }
            try {
                sessionPool = EPPSessionPool.getInstance();
                sessionPool.init();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail((String)("Error initializing the session pool: " + ex));
            }
        }

        protected void tearDown() throws Exception {
            super.tearDown();
            EPPSessionPool.getInstance().close();
        }
    }
}

