/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.validate.v02;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.validate.v02.EPPValidateAddress;
import com.verisign.epp.codec.validate.v02.EPPValidateAuthInfo;
import com.verisign.epp.codec.validate.v02.EPPValidateCheckResp;
import com.verisign.epp.codec.validate.v02.EPPValidateContact;
import com.verisign.epp.codec.validate.v02.EPPValidateKeyValue;
import com.verisign.epp.codec.validate.v02.EPPValidatePostalDefinition;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.interfaces.validate.v02.EPPValidate;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPValidateTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPValidateTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPValidate validate = null;
    private EPPSession session = null;
    private EPPClientCon connection = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPValidateTst(String name) {
        super(name);
    }

    public void testValidate() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.validateCheck();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    private void validateCheck() {
        this.printStart("validateCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("validateCheck: Check contacts (registrant, tech, admin, and billing) for the COM TLD");
            this.validate.setTransId("ABC-12345");
            EPPValidateContact theContact = new EPPValidateContact("sh8013", "registrant", "COM");
            EPPValidateAddress theAddress = new EPPValidateAddress();
            theAddress.setStreets("123 Example Dr.", "Suite 100");
            theAddress.setCity("Dulles");
            theAddress.setStateProvince("VA");
            theAddress.setPostalCode("20166-6503");
            theAddress.setCountry("US");
            EPPValidatePostalDefinition thePostalDef = new EPPValidatePostalDefinition(EPPValidatePostalDefinition.Type.INT, "John Doe", theAddress);
            thePostalDef.setOrg("Example Inc.");
            theContact.addPostalInfo(thePostalDef);
            theContact.setVoice("+1.7035555555");
            theContact.setFax("+1.7035555556");
            theContact.setEmail("jdoe@example.com");
            theContact.setAuthInfo(new EPPValidateAuthInfo("2fooBAR"));
            theContact.addKeyValue(new EPPValidateKeyValue("VAT", "1234567890"));
            this.validate.addContact(theContact);
            this.validate.addContact(new EPPValidateContact("sh8012", "tech", "COM"));
            theContact = new EPPValidateContact("sh8014", "admin", "COM");
            theAddress = new EPPValidateAddress();
            theAddress.setStreets("123 Example Dr.", "Suite 100");
            theAddress.setCity("Dulles");
            theAddress.setStateProvince("VA");
            theAddress.setPostalCode("20166-6503");
            theAddress.setCountry("US");
            thePostalDef = new EPPValidatePostalDefinition(EPPValidatePostalDefinition.Type.INT, "John Doe", theAddress);
            thePostalDef.setOrg("Example Inc.");
            theContact.addPostalInfo(thePostalDef);
            theContact.setVoice("+1.7035555555");
            theContact.setFax("+1.7035555556");
            theContact.setEmail("jdoe@example.com");
            theContact.setAuthInfo(new EPPValidateAuthInfo("2fooBAR"));
            this.validate.addContact(theContact);
            try {
                theContact = (EPPValidateContact)theContact.clone();
                theContact.setContactType("billing");
                this.validate.addContact(theContact);
            }
            catch (CloneNotSupportedException e) {
                Assert.fail((String)("CloneNotSupportedException cloning sh8014 for billing contact: " + e));
            }
            EPPValidateCheckResp response = this.validate.sendCheck();
            System.out.println("Response Type = " + response.getType());
            System.out.println("Response.TransId.ServerTransId = " + response.getTransId().getServerTransId());
            System.out.println("Response.TransId.ServerTransId = " + response.getTransId().getClientTransId());
            System.out.println("\nvalidateCheck: Response = [" + response + "]");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("validateCheck");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
        this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.validate = new EPPValidate(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPValidateTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPValidateTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPValidateTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.out.println(aMsg);
            cat.info((Object)aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.err.println(aMsg);
            cat.error((Object)aMsg);
        }
    }
}

