/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.v1_0;

import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.fee.v1_0.Command;
import com.verisign.epp.codec.fee.v1_0.EPPFeeCheck;
import com.verisign.epp.codec.fee.v1_0.EPPFeeChkData;
import com.verisign.epp.codec.fee.v1_0.EPPFeeCommand;
import com.verisign.epp.codec.fee.v1_0.EPPFeeCreData;
import com.verisign.epp.codec.fee.v1_0.EPPFeeCreate;
import com.verisign.epp.codec.fee.v1_0.EPPFeeDelData;
import com.verisign.epp.codec.fee.v1_0.EPPFeeRenData;
import com.verisign.epp.codec.fee.v1_0.EPPFeeRenew;
import com.verisign.epp.codec.fee.v1_0.EPPFeeTransfer;
import com.verisign.epp.codec.fee.v1_0.EPPFeeTrnData;
import com.verisign.epp.codec.fee.v1_0.EPPFeeUpdData;
import com.verisign.epp.codec.fee.v1_0.EPPFeeUpdate;
import com.verisign.epp.codec.fee.v1_0.EPPFeeValue;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPFeeDomainTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPFeeDomainTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPDomain domain = null;
    private EPPSession session = null;
    private EPPClientCon connection = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPFeeDomainTst(String name) {
        super(name);
    }

    public void testDomain() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.domainCheck();
            this.domainCreate();
            this.domainRenew();
            this.domainDelete();
            this.domainUpdate();
            this.domainTransfer();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    private void domainCheck() {
        this.printStart("domainCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainCheck: Check domain with fee check extension");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.com");
            this.domain.addDomainName("example.net");
            this.domain.addDomainName("example.xyz");
            this.domain.addDomainName("example.zyx");
            this.domain.addDomainName("premium.example");
            EPPFeeCheck theCheckExt = new EPPFeeCheck(new EPPFeeCommand(Command.CREATE));
            theCheckExt.addCommand(new EPPFeeCommand(Command.RENEW));
            theCheckExt.addCommand(new EPPFeeCommand(Command.TRANSFER));
            this.domain.addExtension(theCheckExt);
            EPPDomainCheckResp response = this.domain.sendCheck();
            System.out.println("Response Type = " + response.getType());
            System.out.println("Response.TransId.ServerTransId = " + response.getTransId().getServerTransId());
            System.out.println("Response.TransId.ServerTransId = " + response.getTransId().getClientTransId());
            System.out.println("\ndomainCheck: Response = [" + response + "]");
            if (response.hasExtension(EPPFeeChkData.class)) {
                EPPFeeChkData theExt = (EPPFeeChkData)response.getExtension(EPPFeeChkData.class);
                System.out.println("domainCheck: Response fee data = " + theExt);
            } else {
                Assert.fail((String)"domainCheck: Response did not contain fee extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainCheck");
    }

    public void domainCreate() {
        this.printStart("domainCreate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainCreate: Create domain with fee");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName("example.com");
            this.domain.setAuthString("ABC-12345");
            this.domain.addExtension(new EPPFeeCreate(new EPPFeeValue(new BigDecimal("5.00"))));
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("domainCreate: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPFeeCreData.class)) {
                EPPFeeCreData theExt = (EPPFeeCreData)response.getExtension(EPPFeeCreData.class);
                System.out.println("domainCreate: Response fee data = " + theExt);
            } else {
                Assert.fail((String)"domainCreate: Response did not contain fee extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainCreate");
    }

    public void domainDelete() {
        this.printStart("domainDelete");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainDelete: Delete domain \"delete-credit.com\" and expect response with fee extension");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("delete-credit.com");
            EPPResponse response = this.domain.sendDelete();
            System.out.println("domainDelete: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPFeeDelData.class)) {
                EPPFeeDelData theExt = (EPPFeeDelData)response.getExtension(EPPFeeDelData.class);
                System.out.println("domainDelete: Response fee data = " + theExt);
            } else {
                Assert.fail((String)"domainDelete: Expected response with the fee extension.");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainDelete");
    }

    public void domainRenew() {
        this.printStart("domainRenew");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainRenew: Renew domain with fee");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName("example.com");
            this.domain.setExpirationDate(new GregorianCalendar(2000, 4, 3).getTime());
            this.domain.addExtension(new EPPFeeRenew(new EPPFeeValue(new BigDecimal("5.00"), "USD")));
            EPPDomainRenewResp response = this.domain.sendRenew();
            System.out.println("domainRenew: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPFeeRenData.class)) {
                EPPFeeRenData theExt = (EPPFeeRenData)response.getExtension(EPPFeeRenData.class);
                System.out.println("domainRenew: Response fee data = " + theExt);
            } else {
                Assert.fail((String)"domainRenew: Renew Response did not contain fee extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainRenew");
    }

    public void domainUpdate() {
        this.printStart("domainUpdate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainUpdate: Update domain with fee");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName("example.com");
            this.domain.setRegistrant("sh8013");
            this.domain.addExtension(new EPPFeeUpdate(new EPPFeeValue(new BigDecimal("5.00"))));
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("domainUpdate: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPFeeUpdData.class)) {
                EPPFeeUpdData theExt = (EPPFeeUpdData)response.getExtension(EPPFeeUpdData.class);
                System.out.println("domainUpdate: Response fee data = " + theExt);
            } else {
                Assert.fail((String)"domainUpdate: Update Response did not contain fee extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainUpdate");
    }

    public void domainTransfer() {
        this.printStart("domainTransfer");
        try {
            EPPFeeTrnData theExt;
            System.out.println("\ndomainTransfer: Domain transfer request of example.com with fee");
            this.domain.setTransferOpCode("request");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("2fooBAR");
            this.domain.addDomainName("example.com");
            this.domain.setPeriodLength(1);
            this.domain.setPeriodUnit("y");
            this.domain.addExtension(new EPPFeeTransfer(new EPPFeeValue(new BigDecimal("5.00"))));
            EPPDomainTransferResp response = this.domain.sendTransfer();
            System.out.println("domainTransfer: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPFeeTrnData.class)) {
                theExt = (EPPFeeTrnData)response.getExtension(EPPFeeTrnData.class);
                System.out.println("domainTransfer: Response fee data = " + theExt);
            } else {
                Assert.fail((String)"domainTransfer: Transfer Reqeust Response did not contain fee extension");
            }
            System.out.println("\ndomainTransfer: Domain transfer query of fee-transfer-query.com");
            this.domain.setTransferOpCode("query");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("fee-transfer-query.com");
            response = this.domain.sendTransfer();
            System.out.println("domainTransfer: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPFeeTrnData.class)) {
                theExt = (EPPFeeTrnData)response.getExtension(EPPFeeTrnData.class);
                System.out.println("domainTransfer: Response fee data = " + theExt);
            } else {
                Assert.fail((String)"domainTransfer: Transfer Query Response did not contain fee extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainTransfer");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
        this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPFeeDomainTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPFeeDomainTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPFeeDomainTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".com");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String newDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + newDomainName);
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.out.println(aMsg);
            cat.info((Object)aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.err.println(aMsg);
            cat.error((Object)aMsg);
        }
    }
}

