/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.loginsec.v04.EPPLoginSecUserAgent;
import com.verisign.epp.codec.loginsec.v1_0.EPPLoginSec;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPLoginAdapter;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPLoginSecLoginAdapter
implements EPPLoginAdapter {
    private static final Logger cat = Logger.getLogger((String)EPPLoginSecLoginAdapter.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private boolean useUserAgent = EPPEnv.isUseUserAgent();
    private String userAgentStr;
    private String userAgentClient;
    private String userAgentLang;
    private String userAgentOs;

    public EPPLoginSecLoginAdapter() {
        cat.info((Object)("useUserAgent = " + this.useUserAgent));
        if (this.useUserAgent) {
            this.setUserAgent();
        }
    }

    private void setUserAgent() {
        this.userAgentClient = "Verisign EPP SDK ";
        this.userAgentClient = EPPEnv.getSDKVersion() != null ? this.userAgentClient + EPPEnv.getSDKVersion() : this.userAgentClient + "undefined";
        this.userAgentStr = this.userAgentStr + " (";
        this.userAgentLang = System.getProperty("java.vm.vendor");
        this.userAgentLang = this.userAgentLang + " " + System.getProperty("java.vm.name");
        this.userAgentLang = this.userAgentLang + " " + System.getProperty("java.version");
        this.userAgentStr = this.userAgentStr + "; ";
        this.userAgentOs = System.getProperty("os.arch");
        this.userAgentOs = this.userAgentOs + " " + System.getProperty("os.name");
        this.userAgentOs = this.userAgentOs + " " + System.getProperty("os.version");
        this.userAgentStr = this.userAgentClient + " (" + this.userAgentLang + "; " + this.userAgentOs + ")";
        cat.info((Object)("userAgent = \"" + this.userAgentStr + "\""));
    }

    @Override
    public void adaptLogin(EPPLoginCmd aLoginCmd, EPPGreeting aGreeting) throws EPPCommandException {
        cat.debug((Object)"enter");
        boolean longPw = false;
        if (aLoginCmd.getPassword() != null && aLoginCmd.getPassword().length() > 16) {
            longPw = true;
        }
        boolean longNewPw = false;
        if (aLoginCmd.hasNewPassword() && aLoginCmd.getNewPassword().length() > 16) {
            longNewPw = true;
        }
        if (this.useUserAgent || longPw || longNewPw) {
            if (aGreeting.hasExtensionService("urn:ietf:params:xml:ns:epp:loginSec-1.0")) {
                EPPLoginSec loginSecExt = new EPPLoginSec();
                if (this.useUserAgent) {
                    cat.debug((Object)"Setting user agent");
                    loginSecExt.setUserAgent(new com.verisign.epp.codec.loginsec.v1_0.EPPLoginSecUserAgent(this.userAgentClient, this.userAgentLang, this.userAgentOs));
                }
                if (longPw) {
                    cat.debug((Object)"Placing password in v1_0 extension");
                    loginSecExt.setPassword(aLoginCmd.getPassword());
                    aLoginCmd.setPassword("[LOGIN-SECURITY]");
                }
                if (longNewPw) {
                    cat.debug((Object)"Placing new password in v1_0 extension");
                    loginSecExt.setNewPassword(aLoginCmd.getNewPassword());
                    aLoginCmd.setNewPassword("[LOGIN-SECURITY]");
                }
                aLoginCmd.addExtension(loginSecExt);
            } else if (aGreeting.hasExtensionService("urn:ietf:params:xml:ns:epp:loginSec-0.4")) {
                com.verisign.epp.codec.loginsec.v04.EPPLoginSec loginSecExt = new com.verisign.epp.codec.loginsec.v04.EPPLoginSec();
                if (this.useUserAgent) {
                    cat.debug((Object)"Setting user agent");
                    loginSecExt.setUserAgent(new EPPLoginSecUserAgent(this.userAgentClient, this.userAgentLang, this.userAgentOs));
                }
                if (longPw) {
                    cat.debug((Object)"Placing password in v04 extension");
                    loginSecExt.setPassword(aLoginCmd.getPassword());
                    aLoginCmd.setPassword("[LOGIN-SECURITY]");
                }
                if (longNewPw) {
                    cat.debug((Object)"Placing new password in v04 extension");
                    loginSecExt.setNewPassword(aLoginCmd.getNewPassword());
                    aLoginCmd.setNewPassword("[LOGIN-SECURITY]");
                }
                aLoginCmd.addExtension(loginSecExt);
            } else {
                if (longPw) {
                    throw new EPPCommandException("Long password of length " + aLoginCmd.getPassword().length() + " requires the server to support one of the client supported login security extensions.");
                }
                if (longNewPw) {
                    throw new EPPCommandException("Long new password of length " + aLoginCmd.getNewPassword().length() + " requires the server to support one of the client supported login security extensions.");
                }
            }
        }
        cat.debug((Object)"exit");
    }
}

