/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.emailFwd.EPPEmailFwdAddRemove;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCheckCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCheckResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdContact;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdDeleteCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdPeriod;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdRenewCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdRenewResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdStatus;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.Date;
import java.util.Vector;

public class EPPEmailFwd {
    public static final int CONTACT = 1;
    public static final int STATUS = 2;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int CHANGE = 3;
    public static final String STATUS_OK = "ok";
    public static final String STATUS_SERVER_HOLD = "serverHold";
    public static final String STATUS_SERVER_RENEW_PROHIBITED = "serverRenewProhibited";
    public static final String STATUS_SERVER_TRANSFER_PROHIBITED = "serverTransferProhibited";
    public static final String STATUS_SERVER_UPDATE_PROHIBITED = "serverUpdateProhibited";
    public static final String STATUS_SERVER_DELETE_PROHIBITED = "serverDeleteProhibited";
    public static final String STATUS_PENDING_CREATE = "pendingCreate";
    public static final String STATUS_PENDING_DELETE = "pendingDelete";
    public static final String STATUS_PENDING_RENEW = "pendingRenew";
    public static final String STATUS_PENDING_TRANSFER = "pendingTransfer";
    public static final String STATUS_PENDING_UPDATE = "pendingUpdate";
    public static final String STATUS_CLIENT_HOLD = "clientHold";
    public static final String STATUS_CLIENT_RENEW_PROHIBITED = "clientRenewProhibited";
    public static final String STATUS_CLIENT_TRANSFER_PROHIBITED = "clientTransferProhibited";
    public static final String STATUS_CLIENT_UPDATE_PROHIBITED = "clientUpdateProhibited";
    public static final String STATUS_CLIENT_DELETE_PROHIBITED = "clientDeleteProhibited";
    public static final String TRANSFER_APPROVE = "approve";
    public static final String TRANSFER_CANCEL = "cancel";
    public static final String TRANSFER_QUERY = "query";
    public static final String TRANSFER_REJECT = "reject";
    public static final String TRANSFER_REQUEST = "request";
    public static final String CONTACT_ADMINISTRATIVE = "admin";
    public static final String CONTACT_BILLING = "billing";
    public static final String CONTACT_TECHNICAL = "tech";
    public static final String PERIOD_MONTH = "m";
    public static final String PERIOD_YEAR = "y";
    private Vector emailFwdList = new Vector();
    private String forwardTo = null;
    private Vector contactList = new Vector();
    private Vector updateAttribs = new Vector();
    private EPPSession mySession = null;
    private String transId = null;
    private Date expirationDate;
    private String transferOpCode;
    private int periodLength = 1;
    private String periodUnit;
    private String authString;
    private String authRoid;
    private Vector extensions = null;
    private String registrant = null;

    public EPPEmailFwd(EPPSession newSession) {
        this.mySession = newSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    @Deprecated
    public void setExtension(EPPCodecComponent aExtension) {
        this.addExtension(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void addEmailFwdName(String newEmailFwd) {
        this.emailFwdList.addElement(newEmailFwd);
    }

    public void addContact(String newName, String newType) {
        this.contactList.addElement(new EPPEmailFwdContact(newName, newType));
    }

    public void setExpirationDate(Date newExpirationDate) {
        this.expirationDate = newExpirationDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setTransferOpCode(String newTransferOpCode) {
        this.transferOpCode = newTransferOpCode;
    }

    public void setTransId(String newTransId) {
        this.transId = newTransId;
    }

    public void setAuthString(String newAuthString) {
        this.authString = newAuthString;
    }

    public String getAuthString() {
        return this.authString;
    }

    public String getAuthRoid() {
        return this.authRoid;
    }

    public void setAuthRoid(String aAuthRoid) {
        this.authRoid = aAuthRoid;
    }

    public void setForwardTo(String newForwardTo) {
        this.forwardTo = newForwardTo;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public void setRegistrant(String aRegistrant) {
        this.registrant = aRegistrant;
    }

    public EPPEmailFwdCreateResp sendCreate() throws EPPCommandException {
        if (this.emailFwdList.size() != 1) {
            throw new EPPCommandException("One Email Forward Name is required for sendCreate()");
        }
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            if (this.contactList.size() == 0) {
                this.contactList = null;
            }
        } else {
            this.contactList = null;
        }
        EPPEmailFwdPeriod thePeriod = null;
        if (this.periodLength >= 0) {
            thePeriod = this.periodUnit != null ? new EPPEmailFwdPeriod(this.periodUnit, this.periodLength) : new EPPEmailFwdPeriod(this.periodLength);
        }
        EPPEmailFwdCreateCmd theCommand = new EPPEmailFwdCreateCmd(this.transId, (String)this.emailFwdList.firstElement(), this.forwardTo, this.contactList, thePeriod, new EPPAuthInfo(this.authString));
        if (this.registrant != null) {
            theCommand.setRegistrant(this.registrant);
        }
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return (EPPEmailFwdCreateResp)this.mySession.processDocument(theCommand, EPPEmailFwdCreateResp.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        if (this.emailFwdList.size() != 1) {
            throw new EPPCommandException("One Email Forward Name is required for sendUpdate()");
        }
        Vector contactUpdate = null;
        Vector statusUpdate = null;
        contactUpdate = this.getUpdateAttribCnt(1, 1) == 0 ? null : this.getUpdateAttribVector(1, 1);
        statusUpdate = this.getUpdateAttribCnt(2, 1) == 0 ? null : this.getUpdateAttribVector(2, 1);
        EPPEmailFwdAddRemove addItems = null;
        if (contactUpdate != null || statusUpdate != null) {
            addItems = new EPPEmailFwdAddRemove(contactUpdate, statusUpdate);
        }
        contactUpdate = this.getUpdateAttribCnt(1, 2) == 0 ? null : this.getUpdateAttribVector(1, 2);
        statusUpdate = this.getUpdateAttribCnt(2, 2) == 0 ? null : this.getUpdateAttribVector(2, 2);
        EPPEmailFwdAddRemove removeItems = null;
        if (contactUpdate != null || statusUpdate != null) {
            removeItems = new EPPEmailFwdAddRemove(contactUpdate, statusUpdate);
        }
        EPPEmailFwdAddRemove changeItems = null;
        if (this.registrant != null || this.forwardTo != null || this.authString != null) {
            changeItems = new EPPEmailFwdAddRemove();
            if (this.registrant != null) {
                changeItems.setRegistrant(this.registrant);
            }
            if (this.forwardTo != null) {
                changeItems.setForwardTo(this.forwardTo);
            }
            if (this.authString != null) {
                changeItems.setAuthInfo(new EPPAuthInfo(this.authString));
            }
        }
        EPPEmailFwdUpdateCmd theCommand = new EPPEmailFwdUpdateCmd(this.transId, (String)this.emailFwdList.firstElement(), addItems, removeItems, changeItems);
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return this.mySession.processDocument(theCommand, EPPResponse.class);
    }

    public EPPEmailFwdTransferResp sendTransfer() throws EPPCommandException {
        if (this.emailFwdList.size() != 1) {
            throw new EPPCommandException("One Email Forward Name is required for sendTransfer()");
        }
        if (this.transferOpCode == null) {
            throw new EPPCommandException("Transfer Operation Code is required.");
        }
        EPPEmailFwdTransferCmd theCommand = new EPPEmailFwdTransferCmd(this.transId, this.transferOpCode, (String)this.emailFwdList.firstElement());
        if (this.authString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.authString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
            theCommand.setAuthInfo(theAuthInfo);
        }
        if (this.transferOpCode.equals(TRANSFER_REQUEST)) {
            if (this.authString == null) {
                throw new EPPCommandException("Auth Info must be set on a Transfer Request");
            }
            EPPEmailFwdPeriod thePeriod = null;
            thePeriod = this.periodLength < 0 ? null : (this.periodUnit == null ? new EPPEmailFwdPeriod(this.periodLength) : new EPPEmailFwdPeriod(this.periodUnit, this.periodLength));
            theCommand.setPeriod(thePeriod);
        }
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return (EPPEmailFwdTransferResp)this.mySession.processDocument(theCommand, EPPEmailFwdTransferResp.class);
    }

    public EPPEmailFwdRenewResp sendRenew() throws EPPCommandException {
        if (this.emailFwdList.size() != 1) {
            throw new EPPCommandException("One Email Forward Name is required for sendCreate()");
        }
        EPPEmailFwdPeriod thePeriod = null;
        if (this.periodLength >= 0) {
            thePeriod = this.periodUnit != null ? new EPPEmailFwdPeriod(this.periodUnit, this.periodLength) : new EPPEmailFwdPeriod(this.periodLength);
        }
        EPPEmailFwdRenewCmd theCommand = new EPPEmailFwdRenewCmd(this.transId, (String)this.emailFwdList.firstElement(), this.expirationDate, thePeriod);
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return (EPPEmailFwdRenewResp)this.mySession.processDocument(theCommand, EPPEmailFwdRenewResp.class);
    }

    public EPPEmailFwdInfoResp sendInfo() throws EPPCommandException {
        if (this.emailFwdList.size() != 1) {
            throw new EPPCommandException("One Email Forward Name is required for sendInfo()");
        }
        EPPEmailFwdInfoCmd theCommand = new EPPEmailFwdInfoCmd(this.transId, (String)this.emailFwdList.firstElement());
        if (this.authString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.authString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
            theCommand.setAuthInfo(theAuthInfo);
        }
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return (EPPEmailFwdInfoResp)this.mySession.processDocument(theCommand, EPPEmailFwdInfoResp.class);
    }

    public EPPEmailFwdCheckResp sendCheck() throws EPPCommandException {
        EPPEmailFwdCheckCmd theCommand = new EPPEmailFwdCheckCmd(this.transId, this.emailFwdList);
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return (EPPEmailFwdCheckResp)this.mySession.processDocument(theCommand, EPPEmailFwdCheckResp.class);
    }

    public EPPResponse sendDelete() throws EPPCommandException {
        if (this.emailFwdList.size() != 1) {
            throw new EPPCommandException("One Email Forward Name is required for sendDelete()");
        }
        EPPEmailFwdDeleteCmd theCommand = new EPPEmailFwdDeleteCmd(this.transId, (String)this.emailFwdList.firstElement());
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return this.mySession.processDocument(theCommand, EPPResponse.class);
    }

    private void resetEmailFwd() {
        this.emailFwdList = new Vector();
        this.contactList = new Vector();
        this.updateAttribs = new Vector();
        this.forwardTo = null;
        this.transId = null;
        this.expirationDate = null;
        this.transferOpCode = null;
        this.periodLength = 1;
        this.periodUnit = null;
        this.authString = null;
        this.authRoid = null;
        this.extensions = null;
        this.registrant = null;
    }

    public void setUpdateAttrib(int newType, EPPEmailFwdStatus newName, int newOp) throws EPPCommandException {
        if (newType != 2) {
            throw new EPPCommandException("setUpdateAttrib(int, EPPEmailFwdStatus, int): " + newType + " is an invalid type");
        }
        if (newOp == 3) {
            throw new EPPCommandException("setUpdateAttrib(int, EPPEmailFwdStatus, int): CHANGE is an invalid operation");
        }
        this.updateAttribs.addElement(new UpdateAttrib(newType, newName, newOp));
    }

    public void setUpdateAttrib(int newType, String newVal, String newValType, int newOp) throws EPPCommandException {
        if (newType != 1) {
            throw new EPPCommandException("setUpdateAttrib(int, String, String, int): " + newType + " is an invalid type");
        }
        if (newOp == 3) {
            throw new EPPCommandException("setUpdateAttrib(int, String, String, int): CHANGE is an invalid operation");
        }
        this.updateAttribs.addElement(new UpdateAttrib(newType, new EPPEmailFwdContact(newVal, newValType), newOp));
    }

    public EPPResponse getResponse() {
        return this.mySession.getResponse();
    }

    public int getPeriodLength() {
        return this.periodLength;
    }

    public void setPeriodLength(int newPeriodLength) {
        this.periodLength = newPeriodLength;
    }

    public String getPeriodUnit() {
        return this.periodUnit;
    }

    public void setPeriodUnit(String newPeriodUnit) {
        this.periodUnit = newPeriodUnit;
    }

    private int getUpdateAttribCnt(int newType, int newOp) {
        int cnt = 0;
        for (int i = 0; i < this.updateAttribs.size(); ++i) {
            UpdateAttrib currAttrib = (UpdateAttrib)this.updateAttribs.elementAt(i);
            if (!currAttrib.getType(newType, newOp)) continue;
            ++cnt;
        }
        return cnt;
    }

    private Vector getUpdateAttribVector(int newType, int newOp) {
        int cnt = this.getUpdateAttribCnt(newType, newOp);
        if (cnt == 0) {
            return null;
        }
        Vector<Object> theAttribs = new Vector<Object>(cnt);
        for (int i = 0; i < this.updateAttribs.size(); ++i) {
            UpdateAttrib currAttr = (UpdateAttrib)this.updateAttribs.elementAt(i);
            if (!currAttr.getType(newType, newOp)) continue;
            theAttribs.addElement(currAttr.getVal());
        }
        return theAttribs;
    }

    private static class UpdateAttrib {
        private int myType = 0;
        private Object myVal = null;
        private int myOp = 0;

        public UpdateAttrib(int newType, Object newVal, int newOp) throws EPPCommandException {
            if (newType != 1 && newType != 2) {
                throw new EPPCommandException("UpdateAttrib.UpdateAttrib() : Invalid Type of " + newType);
            }
            if (newOp != 1 && newOp != 2 && newOp != 3) {
                throw new EPPCommandException("UpdateAttrib.UpdateAttrib() : Invalid Operation of " + newOp);
            }
            if (newVal == null) {
                throw new EPPCommandException("UpdateAttrib.UpdateAttrib() : Invalid Value (null)");
            }
            this.myType = newType;
            this.myVal = newVal;
            this.myOp = newOp;
        }

        public boolean getType(int newType, int newOp) {
            return newType == this.myType && newOp == this.myOp;
        }

        public Object getVal() {
            return this.myVal;
        }
    }
}

