/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.signedMark;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.signedMark.EPPSignedMark;
import com.verisign.epp.codec.signedMark.RevokedSMD;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class SMDRevocationList {
    private static Logger cat = Logger.getLogger((String)SMDRevocationList.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final int DEFAULT_VERSION = 1;
    private static final String HEADER_LINE = "smd-id,insertion-datetime";
    private int version = 1;
    private Date createdDate;
    private List<RevokedSMD> revokedSMDs = new ArrayList<RevokedSMD>();

    public SMDRevocationList() {
    }

    public SMDRevocationList(Date aCreatedDate) {
        this.createdDate = aCreatedDate;
    }

    public SMDRevocationList(Date aCreatedDate, List<RevokedSMD> aRevokedSMDs) {
        this.createdDate = aCreatedDate;
        this.setRevokedSMDs(this.revokedSMDs);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int aVersion) {
        this.version = aVersion;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date aCreatedDate) {
        this.createdDate = aCreatedDate;
    }

    public List<RevokedSMD> getRevokedSMDs() {
        return this.revokedSMDs;
    }

    public void setRevokedSMDs(List<RevokedSMD> aRevokedSMDs) {
        this.revokedSMDs = aRevokedSMDs == null ? new ArrayList<RevokedSMD>() : aRevokedSMDs;
    }

    public void addRevokedSMD(RevokedSMD aRevokedSMD) {
        this.revokedSMDs.add(aRevokedSMD);
    }

    public boolean isRevoked(EPPSignedMark aSignedMark) {
        cat.debug((Object)"isRevoked(EPPSignedMark): enter");
        String signedMarkId = aSignedMark.getId();
        for (RevokedSMD currSMD : this.revokedSMDs) {
            if (!currSMD.getId().equals(signedMarkId)) continue;
            cat.debug((Object)("isRevoked(EPPSignedMark): Signed Mark Id = " + signedMarkId + " is revoked"));
            cat.debug((Object)"isRevoked(EPPSignedMark): exit");
            return true;
        }
        cat.debug((Object)("isRevoked(EPPSignedMark): Signed Mark Id = " + signedMarkId + " is not revoked"));
        cat.debug((Object)"isRevoked(EPPSignedMark): exit");
        return false;
    }

    public String encode() throws EPPEncodeException {
        cat.debug((Object)"encode(): enter");
        if (this.createdDate == null) {
            throw new EPPEncodeException("encode(): create date required attribute is null.");
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(Integer.toString(this.version));
        strBuffer.append(',');
        strBuffer.append(EPPUtil.encodeTimeInstant(this.createdDate));
        strBuffer.append('\n');
        strBuffer.append(HEADER_LINE);
        strBuffer.append('\n');
        for (RevokedSMD currRevokedSMD : this.revokedSMDs) {
            strBuffer.append(currRevokedSMD.encode());
            strBuffer.append('\n');
        }
        cat.debug((Object)"encode(): exit");
        return strBuffer.toString();
    }

    public void decode(String aSMDRevocationListStr) throws EPPDecodeException {
        this.decode(new ByteArrayInputStream(aSMDRevocationListStr.getBytes()));
    }

    public void decode(InputStream aSMDRevocationListStream) throws EPPDecodeException {
        cat.debug((Object)"decode(InputStream): enter");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(aSMDRevocationListStream));
        try {
            String currLine = bufferedReader.readLine();
            if (currLine == null) {
                throw new EPPDecodeException("decode(InputStream): Empty SMD revocation list.");
            }
            int sepIndex = currLine.indexOf(44);
            if (sepIndex == -1) {
                throw new EPPDecodeException("decode(InputStream): , seperator first line of SMD revocation list");
            }
            String versionStr = currLine.substring(0, sepIndex);
            this.version = Integer.parseInt(versionStr);
            String createdDateStr = currLine.substring(sepIndex + 1);
            this.createdDate = EPPUtil.decodeTimeInstant(createdDateStr);
            currLine = bufferedReader.readLine();
            if (currLine == null) {
                throw new EPPDecodeException("decode(InputStream): Missing SMD revocation list header line.");
            }
            if (!currLine.equals(HEADER_LINE)) {
                throw new EPPDecodeException("decode(InputStream): Invalid or missing SMD revocation list header line: " + currLine);
            }
            while ((currLine = bufferedReader.readLine()) != null) {
                RevokedSMD revokedSMD = new RevokedSMD();
                revokedSMD.decode(currLine);
                this.addRevokedSMD(revokedSMD);
            }
        }
        catch (IOException e) {
            throw new EPPDecodeException("Error reading SMD: " + e);
        }
        cat.debug((Object)"decode(String): exit");
    }

    public Object clone() throws CloneNotSupportedException {
        SMDRevocationList clone = (SMDRevocationList)super.clone();
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof SMDRevocationList)) {
            cat.error((Object)"SMDRevocationList.equals(): aObject is not an SMDRevocationList");
            return false;
        }
        SMDRevocationList other = (SMDRevocationList)aObject;
        if (!EqualityUtil.equals(this.version, other.version)) {
            cat.error((Object)"SMDRevocationList.equals(): version not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createdDate, other.createdDate)) {
            cat.error((Object)"SMDRevocationList.equals(): createdDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.revokedSMDs, other.revokedSMDs)) {
            cat.error((Object)"EPPMark.equals(): revokedSMDs not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        try {
            return this.encode();
        }
        catch (EPPEncodeException e) {
            throw new RuntimeException(e);
        }
    }
}

