/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.secdnsext.v10;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtDsData;
import com.verisign.epp.util.EPPCatFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSecDNSExtInfData
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPSecDNSExtInfData.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_NAME = "secDNS:infData";
    private List dsData;

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:secDNS-1.0";
    }

    public EPPSecDNSExtInfData() {
    }

    public EPPSecDNSExtInfData(List dsData) {
        this.dsData = dsData;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPSecDNSExtInfData.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPSecDNSExtInfData invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPSecDNSExtInfData.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:secDNS-1.0", ELM_NAME);
        root.setAttribute("xmlns:secDNS", "urn:ietf:params:xml:ns:secDNS-1.0");
        EPPUtil.encodeCompList(aDocument, root, this.dsData);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.dsData = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", "secDNS:dsData", EPPSecDNSExtDsData.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPSecDNSExtInfData)) {
            return false;
        }
        EPPSecDNSExtInfData theComp = (EPPSecDNSExtInfData)aObject;
        if (!EPPUtil.equalLists(this.dsData, theComp.dsData)) {
            cat.error((Object)"EPPSecDNSExtInfData.equals(): dsData not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.dsData == null || this.dsData.size() == 0) {
            throw new EPPCodecException("EPPSecDNSExtInfData required attribute dsData is not set");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPSecDNSExtInfData clone = null;
        clone = (EPPSecDNSExtInfData)super.clone();
        if (this.dsData != null) {
            clone.dsData = new ArrayList(this.dsData);
        }
        return clone;
    }

    public List getDsData() {
        return this.dsData;
    }

    public void setDsData(List dsData) {
        this.dsData = dsData;
    }

    public void appendDsData(EPPSecDNSExtDsData dsData) {
        if (this.dsData == null) {
            this.dsData = new ArrayList();
        }
        this.dsData.add(dsData);
    }
}

