/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryServicesExt;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPRegistryServices
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryServices.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "services";
    public static final String ELM_NAME = "registry:services";
    private List<EPPRegistryObjURI> objURIs = new ArrayList<EPPRegistryObjURI>();
    private EPPRegistryServicesExt extension;

    public EPPRegistryServices() {
    }

    public EPPRegistryServices(List<EPPRegistryObjURI> aObjURIs) {
        this.setObjURIs(aObjURIs);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.objURIs == null || this.objURIs.size() == 0) {
            throw new EPPEncodeException("Invalid state on EPPRegistryServices.encode: objURIs is required.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.objURIs);
        EPPUtil.encodeComp(aDocument, root, this.extension);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.objURIs = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:objURI", EPPRegistryObjURI.class);
        this.extension = (EPPRegistryServicesExt)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:svcExtension", EPPRegistryServicesExt.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryServices)) {
            return false;
        }
        EPPRegistryServices theComp = (EPPRegistryServices)aObject;
        if (!EPPUtil.equalLists(this.objURIs, theComp.objURIs)) {
            cat.error((Object)"EPPRegistryServices.equals(): objURIs not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.extension, theComp.extension)) {
            cat.error((Object)"EPPRegistryServices.equals(): extension not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryServices clone = (EPPRegistryServices)super.clone();
        if (this.objURIs != null) {
            clone.objURIs = (List)((ArrayList)this.objURIs).clone();
        }
        if (this.extension != null) {
            clone.extension = (EPPRegistryServicesExt)this.extension.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public List<EPPRegistryObjURI> getObjURIs() {
        return this.objURIs;
    }

    public void setObjURIs(List<EPPRegistryObjURI> aObjURIs) {
        this.objURIs = aObjURIs == null ? new ArrayList<EPPRegistryObjURI>() : aObjURIs;
    }

    public void addObjURI(EPPRegistryObjURI aURI) {
        this.objURIs.add(aURI);
    }

    public EPPRegistryServicesExt getExtension() {
        return this.extension;
    }

    public void setExtension(EPPRegistryServicesExt aExtension) {
        this.extension = aExtension;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    public static class EPPRegistryObjURI
    extends EPPRegistryURI {
        public EPPRegistryObjURI() {
        }

        public EPPRegistryObjURI(String aUri, Boolean aRequired) {
            super(aUri, aRequired);
        }

        @Override
        public String getRootName() {
            return "registry:objURI";
        }

        @Override
        public boolean equals(Object aObject) {
            return super.equals(aObject);
        }

        @Override
        public String getNamespace() {
            return "urn:ietf:params:xml:ns:epp:registry-0.2";
        }
    }

    public static abstract class EPPRegistryURI
    implements EPPCodecComponent {
        public static final String ELM_OBJ_URI_LOCALNAME = "objURI";
        public static final String ELM_OBJ_URI = "registry:objURI";
        public static final String ELM_EXT_URI_LOCALNAME = "extURI";
        public static final String ELM_EXT_URI = "registry:extURI";
        public static final String ATTR_REQUIRED = "required";
        private Boolean required = null;
        private String uri = null;

        public EPPRegistryURI() {
        }

        public EPPRegistryURI(String aUri, Boolean aRequired) {
            this.uri = aUri;
            this.required = aRequired;
        }

        public abstract String getRootName();

        @Override
        public Element encode(Document aDocument) throws EPPEncodeException {
            try {
                this.validateState();
            }
            catch (EPPCodecException e) {
                throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: " + e);
            }
            Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", this.getRootName());
            Text currVal = aDocument.createTextNode(this.uri);
            root.appendChild(currVal);
            root.setAttribute(ATTR_REQUIRED, this.required.toString());
            return root;
        }

        @Override
        public void decode(Element aElement) throws EPPDecodeException {
            this.uri = aElement.getFirstChild().getNodeValue();
            this.required = EPPUtil.decodeBooleanAttr(aElement, ATTR_REQUIRED);
        }

        private void validateState() throws EPPCodecException {
            if (this.uri == null || this.uri.trim().length() == 0) {
                throw new EPPCodecException("uri attribute is not set");
            }
            if (this.required == null) {
                throw new EPPCodecException("required attribute is not set");
            }
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public boolean equals(Object aObject) {
            if (!(aObject instanceof EPPRegistryURI)) {
                return false;
            }
            EPPRegistryURI theComp = (EPPRegistryURI)aObject;
            if (!EqualityUtil.equals(this.uri, theComp.uri)) {
                cat.error((Object)(this.getClass().getName() + ".equals(): uri not equal"));
                return false;
            }
            if (!EqualityUtil.equals(this.required, theComp.required)) {
                cat.error((Object)(this.getClass().getName() + ".equals(): required not equal"));
                return false;
            }
            return true;
        }

        public String toString() {
            return EPPUtil.toString(this);
        }

        public Boolean getRequired() {
            return this.required;
        }

        public void setRequired(Boolean aRequired) {
            this.required = aRequired;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String aUri) {
            this.uri = aUri;
        }
    }
}

