/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class EPPRegistryPeriodType
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryPeriodType.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "period";
    public static final String ATTR_UNIT = "unit";
    protected Integer number = null;
    protected Unit unit = null;

    public EPPRegistryPeriodType() {
    }

    public EPPRegistryPeriodType(Integer aNumber, Unit aUnit) {
        this.number = aNumber;
        this.unit = aUnit;
    }

    public EPPRegistryPeriodType(int aNumber, Unit aUnit) {
        this.number = aNumber;
        this.unit = aUnit;
    }

    protected String getRootName() {
        return ELM_LOCALNAME;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", "registry:" + this.getRootName());
        Text currVal = aDocument.createTextNode(String.valueOf(this.number));
        root.setAttribute(ATTR_UNIT, this.unit.toString());
        root.appendChild(currVal);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theNumStr = EPPUtil.decodeStringValue(aElement);
        try {
            this.number = Integer.valueOf(theNumStr);
        }
        catch (NumberFormatException e) {
            throw new EPPDecodeException("Can't convert value to Integer: " + theNumStr + e);
        }
        String theUnitStr = aElement.getAttribute(ATTR_UNIT);
        if (theUnitStr == null) {
            throw new EPPDecodeException("Could not find the unit attribute");
        }
        this.unit = Unit.valueOf(theUnitStr);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryPeriodType)) {
            return false;
        }
        EPPRegistryPeriodType theComp = (EPPRegistryPeriodType)aObject;
        if (!EqualityUtil.equals(this.number, theComp.number)) {
            cat.error((Object)"EPPRegistryPeriodType.equals(): number not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.unit, (Object)theComp.unit)) {
            cat.error((Object)"EPPRegistryPeriodType.equals(): unit not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.number == null) {
            throw new EPPCodecException(this.getRootName() + ": number must not be null");
        }
        if (this.unit == null) {
            throw new EPPCodecException(this.getRootName() + ": unit must not be null");
        }
        this.extraValidate();
    }

    abstract void extraValidate() throws EPPCodecException;

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer aNumber) {
        this.number = aNumber;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit aUnit) {
        this.unit = aUnit;
    }

    public static enum Unit {
        m,
        d,
        y,
        h;

    }
}

