/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v01.EPPRegistryDNSSEC;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainContact;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainHostLimit;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainNSLimit;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainName;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainPeriod;
import com.verisign.epp.codec.registry.v01.EPPRegistryGracePeriod;
import com.verisign.epp.codec.registry.v01.EPPRegistryIDN;
import com.verisign.epp.codec.registry.v01.EPPRegistryRGP;
import com.verisign.epp.codec.registry.v01.EPPRegistryRegex;
import com.verisign.epp.codec.registry.v01.EPPRegistrySupportedStatus;
import com.verisign.epp.codec.registry.v01.EPPRegistryTransferHoldPeriodType;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDomain
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryDomain.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "domain";
    public static final String ELM_NAME = "registry:domain";
    public static final String ELM_PREMIUM_SUPPORT = "premiumSupport";
    public static final String ELM_REGISTRANT = "contactsSupported";
    public static final String ELM_MAX_CHECK_DOMAIN = "maxCheckDomain";
    public static final String ELM_AUTH_INFO_REGEX = "authInfoRegex";
    private List<EPPRegistryDomainName> domainNames = new ArrayList<EPPRegistryDomainName>();
    private EPPRegistryIDN idn = null;
    private Boolean premiumSupport = Boolean.FALSE;
    private Boolean contactsSupported = Boolean.TRUE;
    private List<EPPRegistryDomainContact> contacts = new ArrayList<EPPRegistryDomainContact>();
    private EPPRegistryDomainNSLimit nameServerLimit = null;
    private EPPRegistryDomainHostLimit childHostLimit = null;
    private List<EPPRegistryDomainPeriod> periods = new ArrayList<EPPRegistryDomainPeriod>();
    private EPPRegistryTransferHoldPeriodType transferHoldPeriod = null;
    private List<EPPRegistryGracePeriod> gracePeriods = new ArrayList<EPPRegistryGracePeriod>();
    private EPPRegistryRGP rgp = null;
    private EPPRegistryDNSSEC dnssec = null;
    private Integer maxCheckDomain = null;
    private EPPRegistrySupportedStatus supportedStatus = null;
    private EPPRegistryRegex authInfoRegex = null;

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryDomain.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.domainNames);
        EPPUtil.encodeComp(aDocument, root, this.idn);
        if (this.premiumSupport == null) {
            this.premiumSupport = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.premiumSupport.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:premiumSupport");
        if (this.contactsSupported == null) {
            this.contactsSupported = Boolean.TRUE;
        }
        EPPUtil.encodeString(aDocument, root, this.contactsSupported.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:contactsSupported");
        EPPUtil.encodeCompList(aDocument, root, this.contacts);
        EPPUtil.encodeComp(aDocument, root, this.nameServerLimit);
        EPPUtil.encodeComp(aDocument, root, this.childHostLimit);
        EPPUtil.encodeCompList(aDocument, root, this.periods);
        EPPUtil.encodeComp(aDocument, root, this.transferHoldPeriod);
        EPPUtil.encodeCompList(aDocument, root, this.gracePeriods);
        if (this.rgp != null) {
            EPPUtil.encodeComp(aDocument, root, this.rgp);
        }
        if (this.dnssec != null) {
            EPPUtil.encodeComp(aDocument, root, this.dnssec);
        }
        EPPUtil.encodeString(aDocument, root, this.maxCheckDomain.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:maxCheckDomain");
        if (this.supportedStatus != null) {
            EPPUtil.encodeComp(aDocument, root, this.supportedStatus);
        }
        if (this.authInfoRegex != null) {
            EPPUtil.encodeComp(aDocument, root, this.authInfoRegex);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.domainNames = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:domainName", EPPRegistryDomainName.class);
        this.idn = (EPPRegistryIDN)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:idn", EPPRegistryIDN.class);
        this.premiumSupport = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_PREMIUM_SUPPORT);
        if (this.premiumSupport == null) {
            this.premiumSupport = Boolean.FALSE;
        }
        this.contactsSupported = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_REGISTRANT);
        if (this.contactsSupported == null) {
            this.contactsSupported = Boolean.TRUE;
        }
        this.contacts = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:contact", EPPRegistryDomainContact.class);
        this.nameServerLimit = (EPPRegistryDomainNSLimit)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:ns", EPPRegistryDomainNSLimit.class);
        this.childHostLimit = (EPPRegistryDomainHostLimit)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:childHost", EPPRegistryDomainHostLimit.class);
        this.periods = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:period", EPPRegistryDomainPeriod.class);
        this.transferHoldPeriod = (EPPRegistryTransferHoldPeriodType)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "transferHoldPeriod", EPPRegistryTransferHoldPeriodType.class);
        this.gracePeriods = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "gracePeriod", EPPRegistryGracePeriod.class);
        this.rgp = (EPPRegistryRGP)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:rgp", EPPRegistryRGP.class);
        this.dnssec = (EPPRegistryDNSSEC)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:dnssec", EPPRegistryDNSSEC.class);
        this.supportedStatus = (EPPRegistrySupportedStatus)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:supportedStatus", EPPRegistrySupportedStatus.class);
        this.maxCheckDomain = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_MAX_CHECK_DOMAIN);
        this.setAuthInfoRegex((EPPRegistryRegex)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_AUTH_INFO_REGEX, EPPRegistryRegex.class));
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryDomain)) {
            return false;
        }
        EPPRegistryDomain theComp = (EPPRegistryDomain)aObject;
        if (!EqualityUtil.equals(this.domainNames, theComp.domainNames)) {
            cat.error((Object)"EPPRegistryDomain.equals(): domainNames not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.premiumSupport, theComp.premiumSupport)) {
            cat.error((Object)"EPPRegistryDomain.equals(): premiumSupport not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.idn, theComp.idn)) {
            cat.error((Object)"EPPRegistryDomain.equals(): idn not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.contactsSupported, theComp.contactsSupported)) {
            cat.error((Object)"EPPRegistryDomain.equals(): contactsSupported not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.contacts, theComp.contacts)) {
            cat.error((Object)"EPPRegistryDomain.equals(): contacts not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.nameServerLimit, theComp.nameServerLimit)) {
            cat.error((Object)"EPPRegistryDomain.equals(): nameServerLimit not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.childHostLimit, theComp.childHostLimit)) {
            cat.error((Object)"EPPRegistryDomain.equals(): childHostLimit not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.childHostLimit, theComp.childHostLimit)) {
            cat.error((Object)"EPPRegistryDomain.equals(): childHostLimit not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.periods, theComp.periods)) {
            cat.error((Object)"EPPRegistryDomain.equals(): periods not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.transferHoldPeriod, theComp.transferHoldPeriod)) {
            cat.error((Object)"EPPRegistryDomain.equals(): transferHoldPeriod not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.gracePeriods, theComp.gracePeriods)) {
            cat.error((Object)"EPPRegistryDomain.equals(): gracePeriods not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.rgp, theComp.rgp)) {
            cat.error((Object)"EPPRegistryDomain.equals(): rgp not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.dnssec, theComp.dnssec)) {
            cat.error((Object)"EPPRegistryDomain.equals(): dnssec not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.maxCheckDomain, theComp.maxCheckDomain)) {
            cat.error((Object)"EPPRegistryDomain.equals(): maxCheckDomain not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.supportedStatus, theComp.supportedStatus)) {
            cat.error((Object)"EPPRegistryDomain.equals(): supportedStatus not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.authInfoRegex, theComp.authInfoRegex)) {
            cat.error((Object)"EPPRegistryDomain.equals(): authInfoRegex not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.domainNames == null || this.domainNames.size() == 0) {
            throw new EPPCodecException("domainNames element is not set");
        }
        if (this.contacts != null && this.contacts.size() > 3) {
            throw new EPPCodecException("number of contact element cannot exceed 3");
        }
        if (this.nameServerLimit == null) {
            throw new EPPCodecException("ns element is not set");
        }
        if (this.childHostLimit == null) {
            throw new EPPCodecException("childHost element is not set");
        }
        if (this.transferHoldPeriod == null) {
            throw new EPPCodecException("transferHoldPeriod element is not set");
        }
        if (this.maxCheckDomain == null || this.maxCheckDomain <= 0) {
            throw new EPPCodecException("maxCheckDomain is required and should be greater than 0");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryDomain clone = (EPPRegistryDomain)super.clone();
        if (this.domainNames != null) {
            clone.domainNames = (List)((ArrayList)this.domainNames).clone();
        }
        if (this.idn != null) {
            clone.idn = (EPPRegistryIDN)this.idn.clone();
        }
        if (this.contacts != null) {
            clone.contacts = (List)((ArrayList)this.contacts).clone();
        }
        if (this.nameServerLimit != null) {
            clone.nameServerLimit = (EPPRegistryDomainNSLimit)this.nameServerLimit.clone();
        }
        if (this.childHostLimit != null) {
            clone.childHostLimit = (EPPRegistryDomainHostLimit)this.childHostLimit.clone();
        }
        if (this.periods != null) {
            clone.periods = (List)((ArrayList)this.periods).clone();
        }
        if (this.transferHoldPeriod != null) {
            clone.transferHoldPeriod = (EPPRegistryTransferHoldPeriodType)this.transferHoldPeriod.clone();
        }
        if (this.gracePeriods != null) {
            clone.gracePeriods = (List)((ArrayList)this.gracePeriods).clone();
        }
        if (this.rgp != null) {
            clone.rgp = (EPPRegistryRGP)this.rgp.clone();
        }
        if (this.dnssec != null) {
            clone.dnssec = (EPPRegistryDNSSEC)this.dnssec.clone();
        }
        if (this.supportedStatus != null) {
            clone.supportedStatus = (EPPRegistrySupportedStatus)this.supportedStatus.clone();
        }
        if (this.authInfoRegex != null) {
            clone.authInfoRegex = (EPPRegistryRegex)this.authInfoRegex.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasDomainNames() {
        return this.domainNames != null && !this.domainNames.isEmpty();
    }

    public List<EPPRegistryDomainName> getDomainNames() {
        return this.domainNames;
    }

    public void setDomainNames(List<EPPRegistryDomainName> aDomainNames) {
        this.domainNames = aDomainNames == null ? new ArrayList<EPPRegistryDomainName>() : aDomainNames;
    }

    public void addDomainName(EPPRegistryDomainName aDomainName) {
        if (aDomainName == null) {
            return;
        }
        if (this.domainNames == null) {
            this.domainNames = new ArrayList<EPPRegistryDomainName>();
        }
        this.domainNames.add(aDomainName);
    }

    public EPPRegistryIDN getIdn() {
        return this.idn;
    }

    public void setIdn(EPPRegistryIDN idn) {
        this.idn = idn;
    }

    public Boolean getPremiumSupport() {
        return this.premiumSupport;
    }

    public void setPremiumSupport(Boolean premiumSupport) {
        this.premiumSupport = premiumSupport;
    }

    public Boolean getContactsSupported() {
        return this.contactsSupported;
    }

    public void setContactsSupported(Boolean contactsSupported) {
        this.contactsSupported = contactsSupported;
    }

    public boolean hasContacts() {
        return this.contacts != null && !this.contacts.isEmpty();
    }

    public List<EPPRegistryDomainContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<EPPRegistryDomainContact> aContacts) {
        this.contacts = aContacts == null ? new ArrayList<EPPRegistryDomainContact>() : aContacts;
    }

    public void addContact(EPPRegistryDomainContact aContact) {
        if (aContact == null) {
            return;
        }
        if (this.contacts == null) {
            this.contacts = new ArrayList<EPPRegistryDomainContact>();
        }
        this.contacts.add(aContact);
    }

    public EPPRegistryDomainNSLimit getNameServerLimit() {
        return this.nameServerLimit;
    }

    public void setNameServerLimit(EPPRegistryDomainNSLimit nameServerLimit) {
        this.nameServerLimit = nameServerLimit;
    }

    public EPPRegistryDomainHostLimit getChildHostLimit() {
        return this.childHostLimit;
    }

    public void setChildHostLimit(EPPRegistryDomainHostLimit childHostLimit) {
        this.childHostLimit = childHostLimit;
    }

    public boolean hasPeriods() {
        return this.periods != null && !this.periods.isEmpty();
    }

    public List<EPPRegistryDomainPeriod> getPeriods() {
        return this.periods;
    }

    public void setPeriods(List<EPPRegistryDomainPeriod> aPeriods) {
        this.periods = aPeriods == null ? new ArrayList<EPPRegistryDomainPeriod>() : aPeriods;
    }

    public void addPeriod(EPPRegistryDomainPeriod aPeriod) {
        if (aPeriod == null) {
            return;
        }
        if (this.periods == null) {
            this.periods = new ArrayList<EPPRegistryDomainPeriod>();
        }
        this.periods.add(aPeriod);
    }

    public EPPRegistryTransferHoldPeriodType getTransferHoldPeriod() {
        return this.transferHoldPeriod;
    }

    public void setTransferHoldPeriod(EPPRegistryTransferHoldPeriodType transferHoldPeriod) {
        this.transferHoldPeriod = transferHoldPeriod;
    }

    public boolean hasGracePeriods() {
        return this.gracePeriods != null && !this.gracePeriods.isEmpty();
    }

    public void addGracePeriod(EPPRegistryGracePeriod aGracePeriod) {
        if (aGracePeriod == null) {
            return;
        }
        if (this.gracePeriods == null) {
            this.gracePeriods = new ArrayList<EPPRegistryGracePeriod>();
        }
        this.gracePeriods.add(aGracePeriod);
    }

    public List getGracePeriods() {
        return this.gracePeriods;
    }

    public void setGracePeriods(List<EPPRegistryGracePeriod> aGracePeriods) {
        this.gracePeriods = aGracePeriods == null ? new ArrayList<EPPRegistryGracePeriod>() : aGracePeriods;
    }

    public EPPRegistryRGP getRgp() {
        return this.rgp;
    }

    public void setRgp(EPPRegistryRGP rgp) {
        this.rgp = rgp;
    }

    public EPPRegistryDNSSEC getDnssec() {
        return this.dnssec;
    }

    public void setDnssec(EPPRegistryDNSSEC dnssec) {
        this.dnssec = dnssec;
    }

    public Integer getMaxCheckDomain() {
        return this.maxCheckDomain;
    }

    public void setMaxCheckDomain(Integer maxCheckDomain) {
        this.maxCheckDomain = maxCheckDomain;
    }

    public EPPRegistryRegex getAuthInfoRegex() {
        return this.authInfoRegex;
    }

    public void setAuthInfoRegex(EPPRegistryRegex authInfoRegex) {
        if (authInfoRegex != null) {
            authInfoRegex.setRootName(ELM_AUTH_INFO_REGEX);
        }
        this.authInfoRegex = authInfoRegex;
    }

    public EPPRegistrySupportedStatus getSupportedStatus() {
        return this.supportedStatus;
    }

    public void setSupportedStatus(EPPRegistrySupportedStatus supportedStatus) {
        this.supportedStatus = supportedStatus;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }
}

