/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCheckCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v01.EPPRegistryZoneName;
import com.verisign.epp.util.EPPCatFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryCheckCmd
extends EPPCheckCmd {
    private static Logger cat = Logger.getLogger((String)EPPRegistryCheckCmd.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "check";
    public static final String ELM_NAME = "registry:check";
    private List<EPPRegistryZoneName> names = new ArrayList<EPPRegistryZoneName>();

    public EPPRegistryCheckCmd() {
    }

    public EPPRegistryCheckCmd(String aTransId, String aName) {
        super(aTransId);
        this.addName(aName);
    }

    public EPPRegistryCheckCmd(String aTransId, EPPRegistryZoneName aName) {
        super(aTransId);
        this.addName(aName);
    }

    public EPPRegistryCheckCmd(String aTransId, List<EPPRegistryZoneName> aNames) {
        super(aTransId);
        this.setNames(aNames);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryCheckCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPRegistryCheckCmd theMap = (EPPRegistryCheckCmd)aObject;
        if (!EPPUtil.equalLists(this.names, theMap.names)) {
            cat.error((Object)"EPPRegistryCheckCmd.equals(): names not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryCheckCmd clone = (EPPRegistryCheckCmd)super.clone();
        clone.names = (List)((ArrayList)this.names).clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.names == null || this.names.size() == 0) {
            throw new EPPEncodeException("No zone names specified in EPPRegistryCheckCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.names);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.names = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "name", EPPRegistryZoneName.class);
        if (this.names == null) {
            this.names = new ArrayList<EPPRegistryZoneName>();
        }
    }

    public List<EPPRegistryZoneName> getNames() {
        return this.names;
    }

    public void setNames(List<EPPRegistryZoneName> aNames) {
        this.names = aNames == null ? new ArrayList<EPPRegistryZoneName>() : aNames;
    }

    public void setName(String aName) {
        this.names = new ArrayList<EPPRegistryZoneName>();
        this.addName(aName);
    }

    public void setName(EPPRegistryZoneName aName) {
        this.names = new ArrayList<EPPRegistryZoneName>();
        this.addName(aName);
    }

    public void addName(String aName) {
        this.names.add(new EPPRegistryZoneName(aName, EPPRegistryZoneName.Form.aLabel));
    }

    public void addName(EPPRegistryZoneName aName) {
        this.names.add(aName);
    }
}

