/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPRegistryZoneMember
implements EPPCodecComponent {
    private static final long serialVersionUID = 3094793192262086070L;
    private static Logger cat = Logger.getLogger(EPPRegistryZoneMember.class);
    public static final String ELM_LOCALNAME = "zoneMember";
    public static final String ELM_NAME = "registry:zoneMember";
    public static final String TYPE_PRIMARY = "primary";
    public static final String TYPE_ALTERNATE = "alternate";
    public static final String TYPE_PRIMARY_BASED_ON_CR_DATE = "primaryBasedOnCrDate";
    public static final String TYPE_EQUAL = "equal";
    private static final String ATTR_TYPE = "type";
    private String type = null;
    private String zoneName = null;

    public EPPRegistryZoneMember() {
    }

    public EPPRegistryZoneMember(String aZoneName, String aType) {
        this.zoneName = aZoneName;
        this.type = aType;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryZoneMember.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        Text currVal = aDocument.createTextNode(this.zoneName);
        root.appendChild(currVal);
        root.setAttribute(ATTR_TYPE, this.type);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.zoneName = aElement.getFirstChild().getNodeValue();
        this.type = aElement.getAttribute(ATTR_TYPE);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryZoneMember)) {
            return false;
        }
        EPPRegistryZoneMember theComp = (EPPRegistryZoneMember)aObject;
        if (!(this.zoneName != null ? this.zoneName.equals(theComp.zoneName) : theComp.zoneName == null)) {
            cat.error((Object)"EPPRegistryZoneMemeber.equals(): zoneName not equal");
            return false;
        }
        if (!(this.type != null ? this.type.equals(theComp.type) : theComp.type == null)) {
            cat.error((Object)"EPPRegistryZoneMemeber.equals(): type not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistryZoneMember)super.clone();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    void validateState() throws EPPCodecException {
        if (this.zoneName == null || this.zoneName.length() == 0) {
            throw new EPPCodecException("zoneName attribute is not set");
        }
        if (!(TYPE_PRIMARY.equals(this.type) || TYPE_ALTERNATE.equals(this.type) || TYPE_PRIMARY_BASED_ON_CR_DATE.equals(this.type) || TYPE_EQUAL.equals(this.type))) {
            throw new EPPCodecException("zone member has an invalid type: " + this.type);
        }
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String aZoneName) {
        this.zoneName = aZoneName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }
}

