/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPRegistryKeyValue
implements EPPCodecComponent {
    private static final long serialVersionUID = -6074576944169908426L;
    public static final String ELM_NAME = "registry:value";
    public static final String ATTR_KEY = "key";
    private String key = null;
    private String value = null;
    private String rootName = "registry:value";

    public EPPRegistryKeyValue() {
    }

    public EPPRegistryKeyValue(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryKeyValue.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", this.getRootName());
        Text currVal = aDocument.createTextNode(this.value);
        root.setAttribute(ATTR_KEY, this.key);
        root.appendChild(currVal);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.key = aElement.getAttribute(ATTR_KEY);
        this.value = aElement.getFirstChild().getNodeValue();
    }

    void validateState() throws EPPCodecException {
        if (this.rootName == null || this.rootName.trim().length() == 0) {
            throw new EPPCodecException("rootName is not set");
        }
        if (this.key == null || this.key.trim().length() == 0) {
            throw new EPPCodecException("key is required");
        }
        if (this.value == null || this.value.trim().length() == 0) {
            throw new EPPCodecException("value is required");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistryKeyValue)super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryKeyValue)) {
            return false;
        }
        EPPRegistryKeyValue theComp = (EPPRegistryKeyValue)aObject;
        if (!(this.key != null ? this.key.equals(theComp.key) : theComp.key == null)) {
            return false;
        }
        if (!(this.value != null ? this.value.equals(theComp.value) : theComp.value == null)) {
            return false;
        }
        return this.rootName != null ? this.rootName.equals(theComp.rootName) : theComp.rootName == null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRootName() {
        return this.rootName;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }
}

