/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.org;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.org.EPPOrgAddress;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.io.Serializable;
import java.security.InvalidParameterException;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPOrgPostalDefinition
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPOrgPostalDefinition.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "postalInfo";
    public static final String ELM_NAME = "org:postalInfo";
    private static final String ELM_CONTACT_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private Type type = Type.INT;
    private String name = null;
    private EPPOrgAddress address = null;

    public EPPOrgPostalDefinition() {
    }

    public EPPOrgPostalDefinition(Type aType) {
        this.type = aType;
    }

    public EPPOrgPostalDefinition(Type aType, String aName, EPPOrgAddress aAddress) {
        this.name = aName;
        this.type = aType;
        this.address = aAddress;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type aType) {
        this.type = aType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public EPPOrgAddress getAddress() {
        return this.address;
    }

    public void setAddress(EPPOrgAddress aAddress) {
        this.address = aAddress;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.type == null) {
            throw new EPPEncodeException("required attribute type is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", ELM_NAME);
        root.setAttribute(ATTR_TYPE, this.type.toString());
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:epp:org-1.0", "org:name");
        EPPUtil.encodeComp(aDocument, root, this.address);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.type = Type.getType(aElement.getAttribute(ATTR_TYPE));
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_CONTACT_NAME);
        this.address = (EPPOrgAddress)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", "org:addr", EPPOrgAddress.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgPostalDefinition)) {
            return false;
        }
        EPPOrgPostalDefinition other = (EPPOrgPostalDefinition)aObject;
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error((Object)"EPPOrgPostalDefinition.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error((Object)"EPPOrgPostalDefinition.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.address, other.address)) {
            cat.error((Object)"EPPOrgPostalDefinition.equals(): address not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgPostalDefinition clone = (EPPOrgPostalDefinition)super.clone();
        if (this.address != null) {
            clone.address = (EPPOrgAddress)this.address.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:org-1.0";
    }

    public static enum Type implements Serializable,
    Cloneable
    {
        LOC("loc"),
        INT("int");

        private final String typeStr;

        private Type(String aTypeStr) {
            this.typeStr = aTypeStr;
        }

        public static Type getType(String aType) {
            if (aType.equals(Type.LOC.typeStr)) {
                return LOC;
            }
            if (aType.equals(Type.INT.typeStr)) {
                return INT;
            }
            throw new InvalidParameterException("Type enum value of " + aType + " is not valid.");
        }

        public String toString() {
            return this.typeStr;
        }
    }
}

