/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.loginsecpolicy.v04;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.loginsecpolicy.v04.EPPLoginSecPolicyEvent;
import com.verisign.epp.codec.loginsecpolicy.v04.EPPLoginSecPolicyInfData;
import com.verisign.epp.codec.loginsecpolicy.v04.EPPLoginSecPolicyPassword;
import com.verisign.epp.codec.loginsecpolicy.v04.EPPLoginSecPolicySystem;
import com.verisign.epp.codec.registry.v01.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.v01.EPPRegistrySystemInfo;
import com.verisign.epp.codec.registry.v01.EPPRegistryTst;
import com.verisign.epp.util.TestThread;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPLoginSecPolicyTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPLoginSecPolicyTst(String name) {
        super(name);
    }

    public void testRegistryInfoSystemInfo() {
        EPPCodecTst.printStart("testRegistryInfoSystemInfo");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPRegistrySystemInfo systemInfo = EPPRegistryTst.createSystemInfo();
        EPPRegistryInfoResp theResponse = new EPPRegistryInfoResp(theTransId, systemInfo);
        EPPLoginSecPolicyInfData loginSecPolicyExt = new EPPLoginSecPolicyInfData(EPPLoginSecPolicyTst.buildLoginSecSystem());
        theResponse.addExtension(loginSecPolicyExt);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryInfoSystemInfo");
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPLoginSecPolicyTst Thread " + i, EPPLoginSecPolicyTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPLoginSecPolicyTst.suite());
        }
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPLoginSecPolicyTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.registry.v01.EPPRegistryMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.loginsecpolicy.v04.EPPLoginSecPolicyExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }

    public static EPPLoginSecPolicySystem buildLoginSecSystem() {
        EPPLoginSecPolicySystem theSystem = new EPPLoginSecPolicySystem();
        EPPLoginSecPolicyPassword thePassword = new EPPLoginSecPolicyPassword();
        thePassword.setExpression("(?=.*\\d)(?=.*[a-zA-Z])(?=.*[\\x21-\\x2F\\x3A-\\x40\\x5B-\\x60\\x7B-\\x7E])(?!^\\s+)(?!.*\\s+$)(?!.*\\s{2,})^[\\x20-\\x7e]{16,32}$");
        thePassword.setDescription("16 to 32 printable characters (alphanumeric, space, and special characters) with at least one number, letter, and special character, with no leading or trailing whitespace, and with no consecutive spaces.");
        thePassword.setSpecialRules(Boolean.FALSE);
        thePassword.setRestrictedWords(Boolean.TRUE);
        thePassword.setRestrictedWordsUrl("http://example.com/restrictedwords");
        theSystem.setPassword(thePassword);
        theSystem.setUserAgentSupport(Boolean.TRUE);
        EPPLoginSecPolicyEvent theEvent = new EPPLoginSecPolicyEvent();
        theEvent.setType(EPPLoginSecPolicyEvent.EventType.password);
        theEvent.addLevel(EPPLoginSecPolicyEvent.EventLevel.error);
        theEvent.addLevel(EPPLoginSecPolicyEvent.EventLevel.warning);
        theEvent.setExDate(Boolean.TRUE);
        theEvent.setExPeriod("P90D");
        theEvent.setWarningPeriod("P15D");
        theEvent.setErrorAction(EPPLoginSecPolicyEvent.EventErrorAction.login);
        theSystem.addEvent(theEvent);
        theEvent = new EPPLoginSecPolicyEvent();
        theEvent.setType(EPPLoginSecPolicyEvent.EventType.certificate);
        theEvent.addLevel(EPPLoginSecPolicyEvent.EventLevel.error);
        theEvent.addLevel(EPPLoginSecPolicyEvent.EventLevel.warning);
        theEvent.setExDate(Boolean.TRUE);
        theEvent.setWarningPeriod("P15D");
        theEvent.setErrorAction(EPPLoginSecPolicyEvent.EventErrorAction.connect);
        theSystem.addEvent(theEvent);
        theEvent = new EPPLoginSecPolicyEvent();
        theEvent.setType(EPPLoginSecPolicyEvent.EventType.cipher);
        theEvent.addLevel(EPPLoginSecPolicyEvent.EventLevel.warning);
        theEvent.setExDate(Boolean.FALSE);
        theSystem.addEvent(theEvent);
        theEvent = new EPPLoginSecPolicyEvent();
        theEvent.setType(EPPLoginSecPolicyEvent.EventType.tlsProtocol);
        theEvent.addLevel(EPPLoginSecPolicyEvent.EventLevel.warning);
        theEvent.setExDate(Boolean.FALSE);
        theSystem.addEvent(theEvent);
        theEvent = new EPPLoginSecPolicyEvent();
        theEvent.setType(EPPLoginSecPolicyEvent.EventType.stat);
        theEvent.setName("failedLogins");
        theEvent.addLevel(EPPLoginSecPolicyEvent.EventLevel.warning);
        theEvent.setExDate(Boolean.FALSE);
        theEvent.setThreshold(100);
        theEvent.setPeriod("P1D");
        theSystem.addEvent(theEvent);
        theEvent = new EPPLoginSecPolicyEvent();
        theEvent.setType(EPPLoginSecPolicyEvent.EventType.custom);
        theEvent.setName("myCustomEvent");
        theEvent.addLevel(EPPLoginSecPolicyEvent.EventLevel.warning);
        theEvent.setExDate(Boolean.FALSE);
        theSystem.addEvent(theEvent);
        return theSystem;
    }
}

