/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idntable;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPIdnTableCheckTable
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPIdnTableCheckTable.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "table";
    public static final String ELM_NAME = "idnTable:table";
    private static final String ATTR_EXISTS = "exists";
    private String table;
    private boolean exists = false;

    public EPPIdnTableCheckTable() {
    }

    public EPPIdnTableCheckTable(String aTable, boolean aExists) {
        this.setTable(aTable);
        this.setExists(aExists);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String aTable) {
        this.table = aTable;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean aExists) {
        this.exists = aExists;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.table == null) {
            throw new EPPEncodeException("Undefined table in EPPIdnTableCheckTable");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", ELM_NAME);
        root.appendChild(aDocument.createTextNode(this.table));
        EPPUtil.encodeBooleanAttr(root, ATTR_EXISTS, this.exists);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Node textNode = aElement.getFirstChild();
        this.table = textNode != null ? textNode.getNodeValue() : null;
        this.exists = EPPUtil.decodeBooleanAttr(aElement, ATTR_EXISTS);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIdnTableCheckTable clone = (EPPIdnTableCheckTable)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIdnTableCheckTable)) {
            return false;
        }
        EPPIdnTableCheckTable other = (EPPIdnTableCheckTable)aObject;
        if (!EqualityUtil.equals(this.table, other.table)) {
            cat.error((Object)"EPPIdnTableCheckTable.equals(): table not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.exists, other.exists)) {
            cat.error((Object)"EPPIdnTableCheckTable.equals(): exists not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:idnTable-1.0";
    }
}

