/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDcp;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPDuplicateExtensionException;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPExtValue;
import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPHello;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPLogoutCmd;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.gen.EPPMsgQueue;
import com.verisign.epp.codec.gen.EPPPollCmd;
import com.verisign.epp.codec.gen.EPPPurpose;
import com.verisign.epp.codec.gen.EPPRecipient;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPServiceMenu;
import com.verisign.epp.codec.gen.EPPStatement;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.gen.EPPValue;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.util.EPPSchemaCachingParser;
import com.verisign.epp.util.EPPXMLErrorHandler;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPCodecTst
extends TestCase {
    private static long numIterations = 1L;
    private static boolean initialized = false;
    private static final String NAMESPACE_TRANSFORM_XSL = "<?xml version=\"1.0\"?><xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">  <xsl:output method=\"xml\" encoding=\"utf-8\" indent=\"yes\"/>  <xsl:param name=\"use-this-prefix\"/>  <xsl:template match=\"*[namespace-uri(.)]\">    <xsl:element name=\"{$use-this-prefix}{local-name()}\" namespace=\"{namespace-uri(.)}\">      <xsl:copy-of select=\"@*\"/>      <xsl:apply-templates/>    </xsl:element>  </xsl:template></xsl:stylesheet>";

    public EPPCodecTst(String aName) {
        super(aName);
    }

    public void testGreeting() {
        EPPCodecTst.printStart("testGreeting");
        EPPGreeting theGreeting = new EPPGreeting();
        EPPServiceMenu serviceMenu = theGreeting.getServiceMenu();
        Vector<EPPService> services = new Vector<EPPService>();
        EPPService service = new EPPService("domain", "urn:ietf:params:xml:ns:domain-1.0");
        service.setServiceType(0);
        services.addElement(service);
        Vector<EPPStatement> statements = new Vector<EPPStatement>();
        EPPStatement statement = new EPPStatement();
        EPPRecipient recipient = new EPPRecipient();
        recipient.setOther(true);
        recipient.addOurs("My description");
        recipient.setPublic(true);
        EPPPurpose purpose = new EPPPurpose(true, true, true, true);
        Assert.assertTrue((boolean)purpose.isAdmin());
        Assert.assertTrue((boolean)purpose.isContact());
        Assert.assertTrue((boolean)purpose.isOther());
        Assert.assertTrue((boolean)purpose.isProv());
        purpose.setAdmin(false);
        purpose.setProv(false);
        statement.setRecipient(recipient);
        statement.setPurpose(purpose);
        statement.setRetention((short)0);
        EPPStatement statement1 = new EPPStatement();
        EPPPurpose purpose2 = new EPPPurpose();
        purpose2.setAdmin(true);
        purpose2.setProv(true);
        statement1.setRecipient(recipient);
        statement1.setPurpose(purpose2);
        statement1.setRetention((short)1);
        statements.addElement(statement);
        statements.addElement(statement1);
        serviceMenu.setObjectServices(services);
        EPPDcp dcp = new EPPDcp(0, statements);
        theGreeting.setDcp(dcp);
        theGreeting.setServer("Example Company EPP server epp.example.com");
        theGreeting.setServerDate(new Date());
        theGreeting.getServiceMenu().setVersion("1.0");
        Vector<String> langs = new Vector<String>();
        langs.addElement("en");
        langs.addElement("fr");
        theGreeting.getServiceMenu().setLangs(langs);
        EPPEncodeDecodeStats stats = EPPCodecTst.testEncodeDecode(theGreeting);
        System.out.println(stats);
        EPPCodecTst.printEnd("testGreeting");
    }

    public void testLogin() {
        EPPCodecTst.printStart("testLogin");
        Vector<EPPService> services = new Vector<EPPService>();
        EPPService service = new EPPService("domain", "urn:ietf:params:xml:ns:domain-1.0");
        service.setServiceType(0);
        services.addElement(service);
        Vector<EPPService> extservices = new Vector<EPPService>();
        EPPService extservice = new EPPService("domain-ext", "urn:ietf:params:xml:ns:domainext-1.0");
        extservice.setServiceType(1);
        extservices.addElement(extservice);
        EPPLoginCmd theCommand = new EPPLoginCmd("ABC-12345", "ClientX", "foo-BAR2", "bar-FOO2");
        theCommand.setServices(services);
        theCommand.setExtensionServices(extservices);
        theCommand.setVersion("1.0");
        theCommand.setLang("en");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testLogin");
    }

    public void testLogout() {
        EPPCodecTst.printStart("testLogout");
        EPPLogoutCmd theCommand = new EPPLogoutCmd("ABC-12345");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1500);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testLogout");
    }

    public void testResponse() {
        EPPCodecTst.printStart("testResponse");
        EPPResponse theResponse = new EPPResponse(new EPPTransId("ABC-12345", "54321-XYZ"));
        theResponse.setResult(1000);
        System.out.println("EPPResponse.toString = [" + theResponse + "]");
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theResponse = new EPPResponse(new EPPTransId("ABC-12345", "54321-XYZ"));
        EPPResult theResult = new EPPResult(1000);
        theResult.addValue(new EPPValue("<helloWorld/>"));
        theResult.addExtValue(new EPPExtValue("My Reason"));
        theResponse.setResult(theResult);
        System.out.println("EPPResponse.toString = [" + theResponse + "]");
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theResponse = new EPPResponse(new EPPTransId("ABC-12345", "54321-XYZ"));
        theResult = new EPPResult(2306);
        theResult.addExtValue(new EPPExtValue("error reason"));
        theResponse.setResult(theResult);
        System.out.println("EPPResponse.toString = [" + theResponse + "]");
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testResponse");
    }

    public void testUnhandledNamespaces() {
        EPPCodecTst.printStart("testUnhandledNamespaces");
        EPPResponse theResponse = new EPPResponse(new EPPTransId("ABC-12345", "54321-XYZ"));
        EPPResult theResult = new EPPResult(1301);
        theResult.addExtValue(new EPPExtValue("Message incomplete due to missing \"urn:ietf:params:xml:ns:domain-1.0\" objURI in login services", "<objURI>urn:ietf:params:xml:ns:domain-1.0</objURI>"));
        theResult.addExtValue(new EPPExtValue("Message incomplete due to missing \"urn:ietf:params:xml:ns:changePoll-1.0\" extURI in login services", "<extURI>urn:ietf:params:xml:ns:changePoll-1.0</extURI>"));
        theResponse.setResult(theResult);
        theResponse.setMsgQueue(new EPPMsgQueue((Long)1L, "201", new Date(), "Registry initiated update of domain."));
        System.out.println("EPPResponse.toString = [" + theResponse + "]");
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testUnhandledNamespaces");
    }

    public void testCommandGetExtensionFailOnDuplicate() {
        EPPCodecTst.printStart("testCommandGetExtensionFailOnDuplicate");
        EPPPollCmd theCommand = new EPPPollCmd("ABC-12345", "req");
        Test1Extension theExt1 = new Test1Extension();
        theCommand.addExtension(theExt1);
        Test2Extension theExt2 = new Test2Extension();
        theCommand.addExtension(theExt2);
        try {
            Assert.assertEquals((Object)theExt1, (Object)theCommand.getExtension(Test1Extension.class, true));
            Assert.assertEquals((Object)theExt2, (Object)theCommand.getExtension(Test2Extension.class, true));
        }
        catch (EPPDuplicateExtensionException e) {
            Assert.fail((String)("testCommandGetExtensionFailOnDuplicate: Failed on duplicate: " + e));
        }
        theCommand.addExtension(new Test1Extension());
        theCommand.addExtension(new Test2Extension());
        try {
            Assert.assertEquals((Object)theExt1, (Object)theCommand.getExtension(Test1Extension.class, false));
        }
        catch (EPPDuplicateExtensionException e) {
            Assert.fail((String)("testCommandGetExtensionFailOnDuplicate: Failed on getting duplicate extension with failOnDuplicate parameter as false: " + e));
        }
        try {
            theCommand.getExtension(Test1Extension.class, true);
            Assert.fail((String)"testCommandGetExtensionFailOnDuplicate: Should have failed with EPPDuplicateExtensionException for Test1Extension.class");
        }
        catch (EPPDuplicateExtensionException e) {
            Assert.assertEquals(theExt1.getClass(), e.getExtension().getClass());
        }
        try {
            theCommand.getExtension(Test2Extension.class, true);
            Assert.fail((String)"testCommandGetExtensionFailOnDuplicate: Should have failed with EPPDuplicateExtensionException for Test2Extension.class");
        }
        catch (EPPDuplicateExtensionException e) {
            Assert.assertEquals(theExt2.getClass(), e.getExtension().getClass());
        }
        EPPCodecTst.printEnd("testCommandGetExtensionFailOnDuplicate");
    }

    public void testFindDuplicateExtNamespaces() {
        EPPCodecTst.printStart("testFindDuplicateExtNamespaces");
        EPPPollCmd theCommand = new EPPPollCmd("ABC-12345", "req");
        theCommand.addExtension(new Test1Extension());
        theCommand.addExtension(new Test2Extension());
        Set<String> theDuplicateExtNamespaces = EPPUtil.findDuplicateExtNamespaces(theCommand.getExtensions());
        Assert.assertNull(theDuplicateExtNamespaces);
        theDuplicateExtNamespaces = theCommand.findDuplicateExtNamespaces();
        Assert.assertNull(theDuplicateExtNamespaces);
        theCommand.addExtension(new Test1Extension());
        theCommand.addExtension(new Test2Extension());
        theDuplicateExtNamespaces = EPPUtil.findDuplicateExtNamespaces(theCommand.getExtensions());
        Assert.assertNotNull(theDuplicateExtNamespaces);
        Assert.assertEquals((int)2, (int)theDuplicateExtNamespaces.size());
        Assert.assertTrue((boolean)theDuplicateExtNamespaces.contains("test1"));
        Assert.assertTrue((boolean)theDuplicateExtNamespaces.contains("test2"));
        theDuplicateExtNamespaces = theCommand.findDuplicateExtNamespaces();
        Assert.assertNotNull(theDuplicateExtNamespaces);
        Assert.assertEquals((int)2, (int)theDuplicateExtNamespaces.size());
        Assert.assertTrue((boolean)theDuplicateExtNamespaces.contains("test1"));
        Assert.assertTrue((boolean)theDuplicateExtNamespaces.contains("test2"));
        theCommand.addExtension(new Test1Extension());
        theCommand.addExtension(new Test2Extension());
        theDuplicateExtNamespaces = EPPUtil.findDuplicateExtNamespaces(theCommand.getExtensions());
        Assert.assertNotNull(theDuplicateExtNamespaces);
        Assert.assertEquals((int)2, (int)theDuplicateExtNamespaces.size());
        Assert.assertTrue((boolean)theDuplicateExtNamespaces.contains("test1"));
        Assert.assertTrue((boolean)theDuplicateExtNamespaces.contains("test2"));
        theDuplicateExtNamespaces = theCommand.findDuplicateExtNamespaces();
        Assert.assertNotNull(theDuplicateExtNamespaces);
        Assert.assertEquals((int)2, (int)theDuplicateExtNamespaces.size());
        Assert.assertTrue((boolean)theDuplicateExtNamespaces.contains("test1"));
        Assert.assertTrue((boolean)theDuplicateExtNamespaces.contains("test2"));
        EPPResponse theResponse = new EPPResponse();
        theResponse.addExtension(new Test1Extension());
        theResponse.addExtension(new Test2Extension());
        theResponse.addExtension(new Test1Extension());
        theResponse.addExtension(new Test2Extension());
        theDuplicateExtNamespaces = theResponse.findDuplicateExtNamespaces();
        Assert.assertNotNull(theDuplicateExtNamespaces);
        Assert.assertEquals((int)2, (int)theDuplicateExtNamespaces.size());
        Assert.assertTrue((boolean)theDuplicateExtNamespaces.contains("test1"));
        Assert.assertTrue((boolean)theDuplicateExtNamespaces.contains("test2"));
        EPPCodecTst.printEnd("testFindDuplicateExtNamespaces");
    }

    public void testResponseGetExtensionFailOnDuplicate() {
        EPPCodecTst.printStart("testResponseGetExtensionFailOnDuplicate");
        EPPResponse theResponse = new EPPResponse(new EPPTransId("ABC-12345", "54321-XYZ"));
        theResponse.setResult(1000);
        Test1Extension theExt1 = new Test1Extension();
        theResponse.addExtension(theExt1);
        Test2Extension theExt2 = new Test2Extension();
        theResponse.addExtension(theExt2);
        try {
            Assert.assertEquals((Object)theExt1, (Object)theResponse.getExtension(Test1Extension.class, true));
            Assert.assertEquals((Object)theExt2, (Object)theResponse.getExtension(Test2Extension.class, true));
        }
        catch (EPPDuplicateExtensionException e) {
            Assert.fail((String)("testResponseGetExtensionFailOnDuplicate: Failed on duplicate: " + e));
        }
        theResponse.addExtension(new Test1Extension());
        theResponse.addExtension(new Test2Extension());
        try {
            Assert.assertEquals((Object)theExt1, (Object)theResponse.getExtension(Test1Extension.class, false));
        }
        catch (EPPDuplicateExtensionException e) {
            Assert.fail((String)("testResponseGetExtensionFailOnDuplicate: Failed on getting duplicate extension with failOnDuplicate parameter as false: " + e));
        }
        try {
            theResponse.getExtension(Test1Extension.class, true);
            Assert.fail((String)"testResponseGetExtensionFailOnDuplicate: Should have failed with EPPDuplicateExtensionException for Test1Extension.class");
        }
        catch (EPPDuplicateExtensionException e) {
            Assert.assertEquals(theExt1.getClass(), e.getExtension().getClass());
        }
        try {
            theResponse.getExtension(Test2Extension.class, true);
            Assert.fail((String)"testResponseGetExtensionFailOnDuplicate: Should have failed with EPPDuplicateExtensionException for Test2Extension.class");
        }
        catch (EPPDuplicateExtensionException e) {
            Assert.assertEquals(theExt2.getClass(), e.getExtension().getClass());
        }
        EPPCodecTst.printEnd("testResponseGetExtensionFailOnDuplicate");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static void initEnvironment() {
        if (!initialized) {
            Properties theProps = new Properties();
            theProps.setProperty("EPP.Validating", System.getProperty("validate", "true"));
            theProps.setProperty("EPP.FullSchemaChecking", System.getProperty("fullschemachecking", "true"));
            Environment.setProperties(theProps);
            try {
                Logger root = Logger.getRootLogger();
                root.setLevel(Level.DEBUG);
                root.addAppender((Appender)new FileAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"), System.getProperty("logfile", "epp.log"), true));
            }
            catch (IOException ex) {
                System.err.println("IOException initializing log4j");
                ex.printStackTrace();
                System.exit(1);
            }
            initialized = true;
        }
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPCodecTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPCodecTst Thread " + i, EPPCodecTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPCodecTst.suite());
        }
    }

    public static void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
        }
        System.out.println("Start of " + aTest);
        System.out.println("*************************************************************************************\n");
    }

    public static void printEnd(String aTest) {
        System.out.println("*************************************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    public static void testXMLEncodeDecode(EPPMessage aMessage, EPPEncodeDecodeStats aStats) throws EPPException {
        Document doc = null;
        EPPCodec codec = EPPCodec.getInstance();
        EPPSchemaCachingParser parser = null;
        parser = new EPPSchemaCachingParser();
        ((DocumentBuilder)parser).setErrorHandler(new EPPXMLErrorHandler());
        if (aStats != null) {
            aStats.setXmlValidating(((DocumentBuilder)parser).isValidating());
        }
        try {
            if (aStats != null) {
                aStats.startXmlTimer();
            }
            doc = codec.encode(aMessage);
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            trans.setOutputProperty("standalone", "no");
            trans.transform(new DOMSource(doc.getDocumentElement()), new StreamResult(byteOut));
            byteOut.close();
            System.out.println("\n");
            System.out.write(byteOut.toByteArray());
            System.out.println("\n");
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            Document decodedDoc = ((DocumentBuilder)parser).parse(byteIn);
            EPPMessage decodedMessage = codec.decode(decodedDoc);
            if (aStats != null) {
                aStats.stopXmlTimer();
            }
            EPPCodecTst.assertEquals((Object)aMessage, (Object)decodedMessage);
            if (aStats.getXmlFormat() == null) {
                aStats.setXmlFormat(byteOut.toByteArray());
            }
            aStats.startXmlTimer();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(new StringReader(NAMESPACE_TRANSFORM_XSL)));
            ByteArrayOutputStream byteOutNamespaceTransformed = new ByteArrayOutputStream();
            transformer.transform(new StreamSource(new ByteArrayInputStream(byteOut.toByteArray())), new StreamResult(byteOutNamespaceTransformed));
            byteOutNamespaceTransformed.close();
            byteOut = byteOutNamespaceTransformed;
            System.out.println("\n");
            System.out.write(byteOut.toByteArray());
            System.out.println("\n");
            byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            decodedDoc = ((DocumentBuilder)parser).parse(byteIn);
            decodedMessage = codec.decode(decodedDoc);
            aStats.stopXmlTimer();
            if (!aMessage.equals(decodedMessage)) {
                throw new EPPException("Message [" + aMessage + "] != Decoded Message [" + decodedMessage + "]");
            }
            if (aStats.getXmlFormat() == null) {
                aStats.setXmlFormat(byteOut.toByteArray());
            }
        }
        catch (EPPEncodeException ex) {
            throw ex;
        }
        catch (EPPDecodeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EPPException("EPPCodecTst.testXMLEncodeDecode: Error [" + ex.getMessage() + "]", ex);
        }
    }

    public static EPPEncodeDecodeStats testEncodeDecode(EPPMessage aMessage) {
        Object doc = null;
        EPPCodec codec = EPPCodec.getInstance();
        EPPSchemaCachingParser parser = null;
        EPPEncodeDecodeStats retStats = new EPPEncodeDecodeStats(aMessage);
        parser = new EPPSchemaCachingParser();
        ((DocumentBuilder)parser).setErrorHandler(new EPPXMLErrorHandler());
        retStats.setXmlValidating(((DocumentBuilder)parser).isValidating());
        int i = 1;
        while ((long)i <= numIterations) {
            try {
                EPPCodecTst.testXMLEncodeDecode(aMessage, retStats);
            }
            catch (EPPEncodeException e) {
                e.printStackTrace();
                Assert.fail((String)("EPPEncodeException encoding " + retStats.getName() + ": " + e));
            }
            catch (EPPDecodeException e) {
                e.printStackTrace();
                Assert.fail((String)("EPPDecodeException decoding " + retStats.getName() + ": " + e));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("General Exception encoding/decoding of " + retStats.getName() + ": " + e));
            }
            try {
                retStats.startSerialTimer();
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(byteOut);
                out.writeObject(aMessage);
                out.close();
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
                EPPMessage serializedMessage = (EPPMessage)in.readObject();
                in.close();
                retStats.stopSerialTimer();
                EPPCodecTst.assertEquals((Object)aMessage, (Object)serializedMessage);
                if (retStats.getSerialSize() == 0) {
                    retStats.setSerialSize(byteOut.toByteArray().length);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Java Serialization of " + retStats.getName() + ": " + e));
            }
            try {
                EPPMessage clone = (EPPMessage)aMessage.clone();
                EPPCodecTst.assertEquals((Object)aMessage, (Object)clone);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Java Cloning Exception of " + retStats.getName() + ": " + e));
            }
            ++i;
        }
        return retStats;
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }

    public void testHello() {
        EPPCodecTst.printStart("testLogout");
        EPPHello theCommand = new EPPHello();
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testLogout");
    }

    public void testPoll() throws ParserConfigurationException {
        EPPCodecTst.printStart("testPoll");
        EPPPollCmd theCommand = new EPPPollCmd("ABC-12345", "req");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPPollCmd("ABC-12345", "ack", "12345");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ-1");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1301);
        theResponse.setMsgQueue(new EPPMsgQueue((Long)5L, "12345", new Date(), "Transfer request pending"));
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-MIXED-MSG-1");
        theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1301);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document theDoc = builder.newDocument();
        DocumentFragment theFragment = theDoc.createDocumentFragment();
        Element theElm = theDoc.createElement("code");
        Text theText = theDoc.createTextNode("1");
        theElm.appendChild(theText);
        theFragment.appendChild(theElm);
        theElm = theDoc.createElement("txt");
        theText = theDoc.createTextNode("Pending domain created completed.");
        theElm.appendChild(theText);
        theFragment.appendChild(theElm);
        theElm = theDoc.createElement("objectId");
        theText = theDoc.createTextNode("example.com");
        theElm.appendChild(theText);
        theFragment.appendChild(theElm);
        theResponse.setMsgQueue(new EPPMsgQueue((Long)5L, "54321", new Date(), theFragment.getChildNodes()));
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ-2");
        theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1300);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testPoll");
    }

    public void testTimeInstantFormat() {
        EPPCodecTst.printStart("testTimeInstantFormat");
        String theDateStr = "2014-04-24T19:42:58.588Z";
        Date theDecodedDate = EPPUtil.decodeTimeInstant(theDateStr);
        String theEncodedDateStr = EPPUtil.encodeTimeInstant(theDecodedDate);
        Assert.assertEquals((String)theDateStr, (String)theEncodedDateStr);
        EPPUtil.setTimeInstantFormat("yyyy-MM-dd'T'HH':'mm':'ss'Z'");
        theEncodedDateStr = EPPUtil.encodeTimeInstant(theDecodedDate);
        Assert.assertEquals((String)theEncodedDateStr, (String)"2014-04-24T19:42:58Z");
        EPPUtil.setTimeInstantFormat("yyyy-MM-dd'T'HH':'mm':'ss'.'SSS'Z'");
        EPPCodecTst.printEnd("testTimeInstantFormat");
    }

    private static class Test2Extension
    implements EPPCodecComponent {
        private Test2Extension() {
        }

        @Override
        public Element encode(Document aDocument) throws EPPEncodeException {
            Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", "test2");
            return root;
        }

        @Override
        public void decode(Element aElement) throws EPPDecodeException {
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return null;
        }

        @Override
        public String getNamespace() {
            return "test2";
        }
    }

    private static class Test1Extension
    implements EPPCodecComponent {
        private Test1Extension() {
        }

        @Override
        public Element encode(Document aDocument) throws EPPEncodeException {
            Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", "test1");
            return root;
        }

        @Override
        public void decode(Element aElement) throws EPPDecodeException {
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return null;
        }

        @Override
        public String getNamespace() {
            return "test1";
        }
    }
}

