/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v23;

import com.verisign.epp.codec.fee.v23.Command;
import com.verisign.epp.codec.fee.v23.EPPFeeCommand;
import com.verisign.epp.codec.fee.v23.EPPFeeCredit;
import com.verisign.epp.codec.fee.v23.EPPFeePeriod;
import com.verisign.epp.codec.fee.v23.EPPFeeValue;
import com.verisign.epp.codec.fee.v23.Phase;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPFeeCommandData
extends EPPFeeCommand {
    private static Logger cat = Logger.getLogger((String)EPPFeeCommandData.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final String ELM_CLASSIFICATION = "class";
    private static final String ATTR_LANG = "lang";
    private static final String DEFAULT_LANG = "en";
    private static final String ELM_REASON = "reason";
    private List<EPPFeeValue> fees = new ArrayList<EPPFeeValue>();
    private List<EPPFeeCredit> credits = new ArrayList<EPPFeeCredit>();
    private String classification;
    private String language = "en";
    private String reason;

    public EPPFeeCommandData() {
    }

    public EPPFeeCommandData(EPPFeeCommand aCommand) {
        super(aCommand);
    }

    public EPPFeeCommandData(EPPFeeCommandData aCommand) {
        super(aCommand);
        if (aCommand.fees != null) {
            for (EPPFeeValue fee : aCommand.fees) {
                try {
                    this.addFee((EPPFeeValue)fee.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            }
        }
        if (aCommand.credits != null) {
            for (EPPFeeCredit credit : aCommand.credits) {
                try {
                    this.addCredit((EPPFeeCredit)credit.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            }
        }
        this.classification = aCommand.classification;
        this.reason = aCommand.reason;
        this.language = aCommand.language;
    }

    public EPPFeeCommandData(Command aCommand) {
        super(aCommand);
    }

    public EPPFeeCommandData(Command aCommand, String aCustomName) {
        super(aCommand, aCustomName);
    }

    public EPPFeeCommandData(Command aCommand, Phase aPhase) {
        super(aCommand, aPhase);
    }

    public EPPFeeCommandData(Command aCommand, Phase aPhase, String aSubPhase) {
        super(aCommand, aPhase, aSubPhase);
    }

    public EPPFeeCommandData(Command aCommand, String aCustomName, Phase aPhase, String aSubPhase, EPPFeePeriod aPeriod, List<EPPFeeValue> aFees, List<EPPFeeCredit> aCredits, String aClassification, String aReason, String aLanguage) {
        super(aCommand, aCustomName, aPhase, aSubPhase, aPeriod);
        this.setFees(aFees);
        this.setCredits(aCredits);
        this.classification = aClassification;
        this.reason = aReason;
        this.setLanguage(aLanguage);
    }

    public boolean hasFees() {
        return !this.fees.isEmpty();
    }

    public List<EPPFeeValue> getFees() {
        return this.fees;
    }

    public void addFee(EPPFeeValue aFee) {
        if (aFee == null) {
            return;
        }
        this.fees.add(aFee);
    }

    public void setFees(List<EPPFeeValue> aFees) {
        this.fees = aFees == null ? new ArrayList<EPPFeeValue>() : aFees;
    }

    public boolean hasCredits() {
        return !this.credits.isEmpty();
    }

    public List<EPPFeeCredit> getCredits() {
        return this.credits;
    }

    public void addCredit(EPPFeeCredit aCredit) {
        if (aCredit == null) {
            return;
        }
        this.credits.add(aCredit);
    }

    public void setCredits(List<EPPFeeCredit> aCredits) {
        this.credits = aCredits == null ? new ArrayList<EPPFeeCredit>() : aCredits;
    }

    public boolean hasClassification() {
        return this.classification != null;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String aClassification) {
        this.classification = aClassification;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String aReason) {
        this.reason = aReason;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String aLanguage) {
        this.language = aLanguage == null ? DEFAULT_LANG : aLanguage;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeCommandData clone = null;
        clone = (EPPFeeCommandData)super.clone();
        clone.fees = new ArrayList<EPPFeeValue>();
        for (EPPFeeValue fee : this.fees) {
            clone.fees.add((EPPFeeValue)fee.clone());
        }
        clone.credits = new ArrayList<EPPFeeCredit>();
        for (EPPFeeCredit credit : this.credits) {
            clone.credits.add((EPPFeeCredit)credit.clone());
        }
        clone.classification = this.classification;
        clone.reason = this.reason;
        clone.language = this.language;
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        super.decode(aElement);
        this.fees = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:fee-0.23", "fee", EPPFeeValue.class);
        this.credits = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:fee-0.23", "credit", EPPFeeCredit.class);
        this.classification = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.23", ELM_CLASSIFICATION);
        Element theReasonElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:fee-0.23", ELM_REASON);
        if (theReasonElm != null) {
            this.reason = theReasonElm.getFirstChild().getNodeValue();
            String theLang = theReasonElm.getAttribute(ATTR_LANG);
            if (theLang.length() > 0) {
                this.language = theLang;
            }
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = super.encode(aDocument);
        EPPUtil.encodeCompList(aDocument, root, this.fees);
        EPPUtil.encodeCompList(aDocument, root, this.credits);
        EPPUtil.encodeString(aDocument, root, this.classification, "urn:ietf:params:xml:ns:fee-0.23", "fee:class");
        if (this.hasReason()) {
            Element reasonElm = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.23", "fee:reason");
            root.appendChild(reasonElm);
            if (!this.language.equals(DEFAULT_LANG)) {
                reasonElm.setAttribute(ATTR_LANG, this.language);
            }
            Text aReason = aDocument.createTextNode(this.reason);
            reasonElm.appendChild(aReason);
        }
        return root;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeCommandData)) {
            cat.error((Object)("EPPFeeCommandData.equals(): " + aObject.getClass().getName() + "! instanceof " + EPPFeeCommandData.class.getName()));
            return false;
        }
        if (!super.equals((EPPFeeCommand)aObject)) {
            cat.error((Object)"EPPFeeCommandData.equals(): super EPPFeeCommand not equal");
            return false;
        }
        EPPFeeCommandData other = (EPPFeeCommandData)aObject;
        if (!EqualityUtil.equals(this.fees, other.fees)) {
            cat.error((Object)"EPPFeeCommandData.equals(): fees not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.credits, other.credits)) {
            cat.error((Object)"EPPFeeCommandData.equals(): credits not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.classification, other.classification)) {
            cat.error((Object)"EPPFeeCommandData.equals(): classification not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reason, other.reason)) {
            cat.error((Object)"EPPFeeCommandData.equals(): reason not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.language, other.language)) {
            cat.error((Object)"EPPFeeCommandData.equals(): language not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

