/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainCreateResp
extends EPPResponse {
    public static final String ELM_LOCALNAME = "creData";
    public static final String ELM_NAME = "domain:creData";
    private static final String ELM_DOMAIN_NAME = "name";
    private static final String ELM_CREATION_DATE = "crDate";
    private static final String ELM_EXPIRATION_DATE = "exDate";
    private String name = null;
    private Date expirationDate = null;
    private Date creationDate = null;

    public EPPDomainCreateResp() {
    }

    public EPPDomainCreateResp(EPPTransId aTransId, String aName) {
        super(aTransId);
        this.name = aName;
    }

    public EPPDomainCreateResp(EPPTransId aTransId, String aName, Date aCreationDate) {
        super(aTransId);
        this.name = aName;
        this.creationDate = aCreationDate;
    }

    public EPPDomainCreateResp(EPPTransId aTransId, String aName, Date aCreationDate, Date aExpirationDate) {
        super(aTransId);
        this.name = aName;
        this.creationDate = aCreationDate;
        this.expirationDate = aExpirationDate;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainCreateResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPDomainCreateResp theComp = (EPPDomainCreateResp)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        if (!(this.creationDate != null ? this.creationDate.equals(theComp.creationDate) : theComp.creationDate == null)) {
            return false;
        }
        return this.expirationDate != null ? this.expirationDate.equals(theComp.expirationDate) : theComp.expirationDate == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDomainCreateResp clone = (EPPDomainCreateResp)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date newCrDate) {
        this.creationDate = newCrDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date aExpirationDate) {
        this.expirationDate = aExpirationDate;
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.creationDate == null) {
            throw new EPPCodecException("required attribute creationDate is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPDomainCreateResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:domain-1.0", "domain:name");
        EPPUtil.encodeTimeInstant(aDocument, root, this.creationDate, "urn:ietf:params:xml:ns:domain-1.0", "domain:crDate");
        if (this.expirationDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.expirationDate, "urn:ietf:params:xml:ns:domain-1.0", "domain:exDate");
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        this.creationDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CREATION_DATE);
        this.expirationDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_EXPIRATION_DATE);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPDomainCreateResp.decode: " + e);
        }
    }
}

