/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.contact.EPPContactAddChange;
import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.contact.EPPContactCheckCmd;
import com.verisign.epp.codec.contact.EPPContactCheckResp;
import com.verisign.epp.codec.contact.EPPContactCheckResult;
import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactCreateResp;
import com.verisign.epp.codec.contact.EPPContactDeleteCmd;
import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactInfoCmd;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactPendActionMsg;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.contact.EPPContactStatus;
import com.verisign.epp.codec.contact.EPPContactTransferCmd;
import com.verisign.epp.codec.contact.EPPContactTransferResp;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPContactTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPContactTst(String name) {
        super(name);
    }

    public void testContactInfo() {
        EPPCodecTst.printStart("testContactInfo");
        EPPContactInfoCmd theCommand = new EPPContactInfoCmd("ABC-12345", "sh8013");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John Doe", "Example Inc.", "loc", address);
        Vector<String> i15dStreets = new Vector<String>();
        i15dStreets.addElement("i15d 123 Example Dr.");
        i15dStreets.addElement("i15d Suite 100");
        EPPContactAddress i15dAddress = new EPPContactAddress(i15dStreets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition i15dName = new EPPContactPostalDefinition("i15d John Doe", "i15d Example Inc.", "int", i15dAddress);
        Vector<EPPContactStatus> infoStatuses = new Vector<EPPContactStatus>();
        infoStatuses.addElement(new EPPContactStatus("linked"));
        infoStatuses.addElement(new EPPContactStatus("clientUpdateProhibited"));
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPContactInfoResp theResponse = new EPPContactInfoResp(respTransId, "SH8013-VRSN", "sh8013", infoStatuses, name, "jdoe@example.com", "ClientY", "ClientX", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setVoice("+1.7035555555");
        theResponse.setVoiceExt("123");
        theResponse.setFax("+1.7035555556");
        theResponse.setFaxExt("456");
        theResponse.addPostalInfo(i15dName);
        EPPContactDisclose disclose = new EPPContactDisclose(true, true, false, true, true, true, true, true, true, true);
        theResponse.setDisclose(disclose);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastUpdatedDate(new Date());
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactInfo");
    }

    public void testContactCreate() {
        EPPCodecTst.printStart("testContactCreate");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(null, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John Doe", "Example Inc.", "loc", address);
        EPPContactCreateCmd theCommand = new EPPContactCreateCmd("ABC-12345", "DepDisclose", name, "jdoe@example.com", new EPPAuthInfo("2fooBAR"));
        theCommand.setFax("+1.7035555556");
        theCommand.setFaxExt("123");
        theCommand.setVoice("+1.7035555555");
        theCommand.setVoiceExt("456");
        EPPContactDisclose disclose = new EPPContactDisclose();
        disclose.setFlag(false);
        disclose.setNameInt(true);
        disclose.setNameLoc(true);
        disclose.setOrgInt(true);
        disclose.setOrgLoc(true);
        disclose.setAddrInt(true);
        disclose.setAddrLoc(true);
        disclose.setVoice(false);
        disclose.setFax(false);
        disclose.setEmail(false);
        theCommand.setDisclose(disclose);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand.setId("NewDisclose");
        disclose = new EPPContactDisclose();
        disclose.setFlag(true);
        disclose.setNameLoc(true);
        disclose.setOrgInt(true);
        disclose.setAddrInt(true);
        disclose.setAddrLoc(true);
        disclose.setVoice(true);
        disclose.setFax(true);
        disclose.setEmail(true);
        theCommand.setDisclose(disclose);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand.setId("AllDisclose");
        disclose = new EPPContactDisclose();
        disclose.setFlag(true);
        disclose.setAll();
        theCommand.setDisclose(disclose);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand.setId("AllIntDisclose");
        disclose = new EPPContactDisclose();
        disclose.setFlag(true);
        disclose.setAllInt();
        theCommand.setDisclose(disclose);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand.setId("AllIntOtherDisc");
        disclose = new EPPContactDisclose();
        disclose.setFlag(true);
        disclose.setAllInt();
        disclose.setAllOther();
        theCommand.setDisclose(disclose);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand.setId("AllLocDisclose");
        disclose = new EPPContactDisclose();
        disclose.setFlag(true);
        disclose.setAllLoc();
        theCommand.setDisclose(disclose);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPContactCreateResp theResponse = new EPPContactCreateResp(respTransId, "sh8013", new Date());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactCreate");
    }

    public void testContactDelete() {
        EPPCodecTst.printStart("testContactDelete");
        EPPContactDeleteCmd theCommand = new EPPContactDeleteCmd("ABC-12345", "sh8013");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactDelete");
    }

    public void testContactUpdate() {
        EPPContactUpdateCmd theCommand = null;
        EPPEncodeDecodeStats commandStats = null;
        EPPCodecTst.printStart("testContactUpdate");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John", "loc", address);
        EPPContactAddChange change = new EPPContactAddChange(name, "+1.7034444444", new EPPAuthInfo("2BARfoo"));
        change.setVoiceExt("678");
        change.setFax("+1.7037777777");
        change.setFaxExt("678");
        EPPContactDisclose disclose = new EPPContactDisclose();
        disclose.setFlag(false);
        disclose.setNameInt(true);
        disclose.setNameLoc(true);
        disclose.setOrgInt(true);
        disclose.setOrgLoc(true);
        disclose.setAddrInt(true);
        disclose.setAddrLoc(true);
        disclose.setVoice(false);
        disclose.setFax(false);
        disclose.setEmail(false);
        change.setDisclose(disclose);
        Vector<EPPContactStatus> addStatuses = new Vector<EPPContactStatus>();
        addStatuses.addElement(new EPPContactStatus("clientDeleteProhibited"));
        addStatuses.addElement(new EPPContactStatus("clientDeleteProhibited", "Hello World", "en"));
        EPPContactAddChange add = new EPPContactAddChange(addStatuses);
        theCommand = new EPPContactUpdateCmd("ABC-12345", "sh8013", add, null, change);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactUpdate");
    }

    public void testContactTransfer() {
        EPPCodecTst.printStart("testContactTransfer");
        EPPContactTransferCmd theCommand = new EPPContactTransferCmd("ABC-12345", "request", "sh8013");
        theCommand.setAuthInfo(new EPPAuthInfo("2fooBAR"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPContactTransferResp theResponse = new EPPContactTransferResp(respTransId, "SH0000", "pending");
        theResponse.setResult(1000);
        theResponse.setRequestClient("ClientX");
        theResponse.setActionClient("ClientY");
        theResponse.setRequestDate(new Date());
        theResponse.setActionDate(new Date());
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPContactTransferCmd("ABC-12345", "cancel", "sh8013");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPContactTransferCmd("ABC-12345", "query", "sh8013");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPContactTransferCmd("ABC-12345", "reject", "sh8013");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        theCommand = new EPPContactTransferCmd("ABC-12345", "approve", "sh8013");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testContactTransfer");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPContactTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.contact.EPPContactMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPContactMapFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPContactTst Thread " + i, EPPContactTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPContactTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }

    public void testContactCheck() {
        EPPCodecTst.printStart("testContactCheck");
        EPPContactCheckCmd theCommand = new EPPContactCheckCmd("ABC-12345", "sh8013");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<String> contacts = new Vector<String>();
        contacts.addElement("sh8013");
        contacts.addElement("sah8013");
        contacts.addElement("8013sah");
        theCommand = new EPPContactCheckCmd("ABC-12345", contacts);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPContactCheckResp theResponse = new EPPContactCheckResp(respTransId, new EPPContactCheckResult("sh8013", true));
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        Vector<EPPContactCheckResult> contactResults = new Vector<EPPContactCheckResult>();
        contactResults.addElement(new EPPContactCheckResult("sh8013", true));
        EPPContactCheckResult contactResult = new EPPContactCheckResult("sah8013", false);
        contactResult.setContactReason("In Use");
        contactResults.addElement(contactResult);
        contactResults.addElement(new EPPContactCheckResult("8013sah", true));
        theResponse = new EPPContactCheckResp(respTransId, contactResults);
        theResponse.setResult(1000);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactCheck");
    }

    public void testContactPendActionMsg() {
        EPPCodecTst.printStart("testContactPendActionMsg");
        EPPTransId thePollTransId = new EPPTransId("ABC-12349", "54321-XYZ");
        EPPTransId thePendingTransId = new EPPTransId("DEF-12349", "12345-XYZ");
        EPPContactPendActionMsg theMsg = new EPPContactPendActionMsg(thePollTransId, "sh8013", true, thePendingTransId, new Date());
        theMsg.setResult(1301);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theMsg);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactPendActionMsg");
    }
}

