/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPSendReceiveLogger;
import com.verisign.epp.util.EPPXMLByteArray;
import com.verisign.epp.util.EPPXMLStream;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;

public class EPPRawSendReceiveLogger
implements EPPSendReceiveLogger {
    private static Logger cat = Logger.getLogger((String)EPPRawSendReceiveLogger.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static Logger packetCat = Logger.getLogger((String)(EPPXMLStream.class.getName() + ".packet"), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    public void logSend(byte[] aPacket, EPPMessage aMessage) {
        cat.debug((Object)"logSend(byte[], EPPMessage): enter");
        this.log("writePacket() : Sending [", aPacket, aMessage);
        cat.debug((Object)"logSend(byte[], EPPMessage): exit");
    }

    @Override
    public void logReceive(byte[] aPacket, EPPMessage aMessage) {
        cat.debug((Object)"logReceive(byte[], EPPMessage): enter");
        this.log("decodePacket() : Received [", aPacket, aMessage);
        cat.debug((Object)"logReceive(byte[], EPPMessage): exit");
    }

    private void log(String logPrefix, byte[] aPacket, EPPMessage aMessage) {
        cat.debug((Object)"log(byte[], EPPMessage): enter");
        if (!packetCat.isDebugEnabled()) {
            return;
        }
        if (aPacket != null) {
            packetCat.debug((Object)(logPrefix + new String(aPacket) + "]"));
        } else if (aMessage != null) {
            try {
                Document theDoc = EPPCodec.getInstance().encode(aMessage);
                EPPXMLByteArray theByteArray = new EPPXMLByteArray("EPP_XML_PARSER_POOL", "EPP_XML_TRANSFORMER_POOL");
                byte[] thePacket = theByteArray.encode(theDoc);
                packetCat.debug((Object)(logPrefix + new String(thePacket) + "]"));
            }
            catch (EPPException ex) {
                cat.error((Object)("log(byte[], EPPMessage); Error encoding message: " + ex));
                return;
            }
        } else {
            cat.error((Object)"log(byte[], EPPMessage); Both aPacket and aMessage are null");
        }
        cat.debug((Object)"log(byte[], EPPMessage): exit");
    }

    @Override
    public EPPCodecComponent maskMessage(EPPCodecComponent aMessage) {
        return aMessage;
    }

    @Override
    public String maskString(String aString) {
        return aString;
    }
}

