/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.org.EPPOrgAddress;
import com.verisign.epp.codec.org.EPPOrgCheckCmd;
import com.verisign.epp.codec.org.EPPOrgCheckResp;
import com.verisign.epp.codec.org.EPPOrgCheckResult;
import com.verisign.epp.codec.org.EPPOrgContact;
import com.verisign.epp.codec.org.EPPOrgCreateCmd;
import com.verisign.epp.codec.org.EPPOrgCreateResp;
import com.verisign.epp.codec.org.EPPOrgDeleteCmd;
import com.verisign.epp.codec.org.EPPOrgInfoCmd;
import com.verisign.epp.codec.org.EPPOrgInfoResp;
import com.verisign.epp.codec.org.EPPOrgPendActionMsg;
import com.verisign.epp.codec.org.EPPOrgPostalDefinition;
import com.verisign.epp.codec.org.EPPOrgRole;
import com.verisign.epp.codec.org.EPPOrgRoleStatus;
import com.verisign.epp.codec.org.EPPOrgStatus;
import com.verisign.epp.codec.org.EPPOrgUpdateCmd;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.EPPOrgHandler;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class OrgHandler
extends EPPOrgHandler {
    private static Logger cat = Logger.getLogger((String)OrgHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        super.preHandleEvent(aEvent, aData);
    }

    @Override
    protected EPPEventResponse doOrgCheck(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doOrgCheck: enter");
        EPPOrgCheckCmd theCommand = (EPPOrgCheckCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPOrgCheckResp theResp = new EPPOrgCheckResp(theTransId);
        for (String orgId : theCommand.getOrgIds()) {
            if (orgId.equalsIgnoreCase("re1523") || orgId.equalsIgnoreCase("notavailable")) {
                theResp.addCheckResult(new EPPOrgCheckResult(orgId, "In use"));
                continue;
            }
            theResp.addCheckResult(new EPPOrgCheckResult(orgId, true));
        }
        cat.debug((Object)"doOrgCheck: exit");
        return new EPPEventResponse(theResp);
    }

    @Override
    protected EPPEventResponse doOrgInfo(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doOrgInfo: enter");
        EPPOrgInfoCmd theCommand = (EPPOrgInfoCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPOrgInfoResp theResp = new EPPOrgInfoResp(theTransId, theCommand.getOrgId());
        theResp.setRoid("registrar1362-REP");
        theResp.addRole(new EPPOrgRole("registrar", EPPOrgRoleStatus.ok, "1362"));
        theResp.addStatus(EPPOrgStatus.ok);
        theResp.setParentId("1523res");
        EPPOrgAddress theAddress = new EPPOrgAddress();
        theAddress.setStreets("124 Example Dr.", "Suite 200");
        theAddress.setCity("Dulles");
        theAddress.setStateProvince("VA");
        theAddress.setPostalCode("20166-6503");
        theAddress.setCountry("US");
        theResp.addPostalInfo(new EPPOrgPostalDefinition(EPPOrgPostalDefinition.Type.INT, "Example Org Inc.", theAddress));
        theResp.setVoice("+1.7035555555");
        theResp.setVoiceExt("1234");
        theResp.setFax("+1.7035555556");
        theResp.setEmail("contact@org.example");
        theResp.setUrl("http://org.example");
        theResp.addContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.ADMINISTRATIVE));
        theResp.addContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.BILLING));
        theResp.addContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.CUSTOM, "customSample"));
        theResp.setClientId("ClientY");
        theResp.setCreatedBy("ClientX");
        theResp.setCreatedDate(new GregorianCalendar(1999, 4, 3, 22, 0).getTime());
        theResp.setLastUpdatedBy("ClientX");
        theResp.setLastUpdatedDate(new GregorianCalendar(1999, 12, 3, 0, 0).getTime());
        cat.debug((Object)"doOrgInfo: exit");
        return new EPPEventResponse(theResp);
    }

    @Override
    protected EPPEventResponse doOrgCreate(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doOrgCreate: enter");
        EPPOrgCreateCmd theCommand = (EPPOrgCreateCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPOrgCreateResp theResp = new EPPOrgCreateResp(theTransId, theCommand.getOrgId(), new Date());
        if (theCommand.getOrgId().equalsIgnoreCase("PENDING")) {
            theResp.setResult(1001);
            EPPTransId thePendingTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
            EPPOrgPendActionMsg theMsg = new EPPOrgPendActionMsg(null, theCommand.getOrgId(), true, thePendingTransId, new Date());
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:epp:org-1.0", theMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error((Object)("Exception inserting poll message: " + ex));
                theResp.setResult(2400);
            }
        }
        cat.debug((Object)"doOrgCreate: exit");
        return new EPPEventResponse(theResp);
    }

    @Override
    protected EPPEventResponse doOrgDelete(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doOrgDelete: enter");
        EPPOrgDeleteCmd theCommand = (EPPOrgDeleteCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResp = new EPPResponse(theTransId);
        cat.debug((Object)"doOrgDelete: exit");
        return new EPPEventResponse(theResp);
    }

    @Override
    protected EPPEventResponse doOrgUpdate(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"doOrgUpdate: enter");
        EPPOrgUpdateCmd theCommand = (EPPOrgUpdateCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResp = new EPPResponse(theTransId);
        cat.debug((Object)"doOrgUpdate: exit");
        return new EPPEventResponse(theResp);
    }
}

