/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.secureauthinfo;

import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import com.verisign.epp.util.secureauthinfo.EPPAuthInfoFactory;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPSecureAuthInfoTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPSecureAuthInfoTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPDomain domain = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPSecureAuthInfoTst(String name) {
        super(name);
    }

    public void testDomain() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.domainSuccessfulTransfer();
            this.domainUnsuccessfulTransfer();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    private void domainSuccessfulTransfer() {
        this.printStart("domainSuccessfulTransfer");
        try {
            String theDomainName = this.makeDomainName();
            String theAuthInfo = EPPAuthInfoFactory.createAuthInfoPasswordStr(20);
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainSuccessfulTransfer: Create the domain without authorization information");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName(theDomainName);
            this.domain.setAuthString("");
            EPPResponse response = this.domain.sendCreate();
            System.out.println("domainSuccessfulTransfer: Create Response = [" + response + "]\n\n");
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainSuccessfulTransfer: Update the domain with generated secure random authorization information");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(theDomainName);
            this.domain.setAuthString(theAuthInfo);
            this.domain.setUpdateAttrib(2, new EPPDomainStatus("clientTransferProhibited"), 2);
            response = this.domain.sendUpdate();
            System.out.println("domainSuccessfulTransfer: Update Response = [" + response + "]\n\n");
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainSuccessfulTransfer: Info the domain with generated secure random authorization information to validate it prior to a transfer request");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(theDomainName);
            this.domain.setAuthString(theAuthInfo);
            response = this.domain.sendInfo();
            System.out.println("domainSuccessfulTransfer: Info Response = [" + response + "]\n\n");
            if (((EPPDomainInfoResp)response).hasAuthInfo()) {
                Assert.fail((String)"domainSuccessfulTransfer: Info response must not return the authorization information value");
            }
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainSuccessfulTransfer: Transfer request with generated secure random authorization information, which should result in an immediate transfer");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName(theDomainName);
            this.domain.setAuthString(theAuthInfo);
            this.domain.setTransferOpCode("request");
            response = this.domain.sendTransfer();
            System.out.println("domainSuccessfulTransfer: Transfer Response = [" + response + "]\n\n");
            if (!response.hasResultCode(1000)) {
                Assert.fail((String)"domainSuccessfulTransfer: Transfer request did not result in 1000 result");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainSuccessfulTransfer");
    }

    private void domainUnsuccessfulTransfer() {
        this.printStart("domainUnsuccessfulTransfer");
        try {
            String theDomainName = this.makeDomainName();
            String theAuthInfo = EPPAuthInfoFactory.createAuthInfoPasswordStr(20);
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainUnsuccessfulTransfer: Create the domain without authorization information");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName(theDomainName);
            this.domain.setAuthString("");
            EPPResponse response = this.domain.sendCreate();
            System.out.println("domainUnsuccessfulTransfer: Create Response = [" + response + "]\n\n");
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainUnsuccessfulTransfer: Update the domain with generated secure random authorization information");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(theDomainName);
            this.domain.setAuthString(theAuthInfo);
            this.domain.setUpdateAttrib(2, new EPPDomainStatus("clientTransferProhibited"), 2);
            response = this.domain.sendUpdate();
            System.out.println("domainUnsuccessfulTransfer: Update Response (Set AuthInfo) = [" + response + "]\n\n");
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainUnsuccessfulTransfer: Update the domain to clear the authorization information with null authorization information based on expiry \n\t * of the Time-To-Live (TTL)");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(theDomainName);
            EPPAuthInfo theNullAuthInfo = new EPPAuthInfo();
            theNullAuthInfo.removePassword();
            this.domain.setAuthInfo(theNullAuthInfo);
            this.domain.setUpdateAttrib(2, new EPPDomainStatus("clientTransferProhibited"), 1);
            response = this.domain.sendUpdate();
            System.out.println("domainUnsuccessfulTransfer: Update Response (Unset AuthInfo with Null AuthInfo) = [" + response + "]\n\n");
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainUnsuccessfulTransfer: Update the domain to clear the authorization information with empty authorization information based on expiry \n\t * of the Time-To-Live (TTL)");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(theDomainName);
            this.domain.setAuthInfo(new EPPAuthInfo(""));
            this.domain.setUpdateAttrib(2, new EPPDomainStatus("clientTransferProhibited"), 1);
            response = this.domain.sendUpdate();
            System.out.println("domainUnsuccessfulTransfer: Update Response (Unset AuthInfo with Empty AuthInfo) = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainUnsuccessfulTransfer");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPSecureAuthInfoTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = ((EPPCommandException)aException).getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPSecureAuthInfoTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPSecureAuthInfoTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String("EPPSecureAuthInfoTst" + Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".com");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String aDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + aDomainName);
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("SAI" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.out.println(aMsg);
            cat.info((Object)aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.err.println(aMsg);
            cat.error((Object)aMsg);
        }
    }
}

