/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.registry.v01.EPPRegistryCheckCmd;
import com.verisign.epp.codec.registry.v01.EPPRegistryCheckResp;
import com.verisign.epp.codec.registry.v01.EPPRegistryCreateCmd;
import com.verisign.epp.codec.registry.v01.EPPRegistryCreateResp;
import com.verisign.epp.codec.registry.v01.EPPRegistryDeleteCmd;
import com.verisign.epp.codec.registry.v01.EPPRegistryInfoCmd;
import com.verisign.epp.codec.registry.v01.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.v01.EPPRegistryUpdateCmd;
import com.verisign.epp.codec.registry.v01.EPPRegistryZone;
import com.verisign.epp.codec.registry.v01.EPPRegistryZoneName;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class EPPRegistry {
    private EPPSession session = null;
    private String transId = null;
    private boolean allZones = false;
    private boolean system = false;
    private List<EPPRegistryZoneName> zoneList = null;
    private EPPRegistryZone zone = null;
    private Vector<EPPCodecComponent> extensions = null;

    public EPPRegistry(EPPSession aSession) {
        this.session = aSession;
    }

    public EPPRegistryCheckResp sendCheck() throws EPPCommandException {
        if (this.zoneList == null || this.zoneList.isEmpty()) {
            throw new EPPCommandException("At least one zone name is required for sendCheck()");
        }
        EPPRegistryCheckCmd theCommand = new EPPRegistryCheckCmd(this.transId, this.zoneList);
        theCommand.setExtensions(this.extensions);
        this.resetRegistry();
        return (EPPRegistryCheckResp)this.session.processDocument(theCommand, EPPRegistryCheckResp.class);
    }

    public EPPResponse sendDelete() throws EPPCommandException {
        if (this.zoneList == null || this.zoneList.size() != 1) {
            throw new EPPCommandException("One zone name is required for sendDelete()");
        }
        EPPRegistryDeleteCmd theCommand = new EPPRegistryDeleteCmd(this.transId, this.zoneList.get(0));
        theCommand.setExtensions(this.extensions);
        this.resetRegistry();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    public EPPRegistryInfoResp sendInfo() throws EPPCommandException {
        EPPRegistryInfoCmd theCommand = null;
        if (this.zoneList != null && !this.zoneList.isEmpty()) {
            if (this.isAllZones() || this.isSystem()) {
                throw new EPPCommandException("[1] Only one form of info command can be set.");
            }
            if (this.zoneList.size() != 1) {
                throw new EPPCommandException("One zone name is required for sendInfo()");
            }
            theCommand = new EPPRegistryInfoCmd(this.transId, this.zoneList.get(0));
        } else if (this.isAllZones()) {
            if (this.isSystem()) {
                throw new EPPCommandException("[2] Only one form of info command can be set.");
            }
            theCommand = new EPPRegistryInfoCmd(this.transId, true, false);
        } else if (this.isSystem()) {
            theCommand = new EPPRegistryInfoCmd(this.transId, false, true);
        } else {
            throw new EPPCommandException("None of the info command forms are set");
        }
        theCommand.setExtensions(this.extensions);
        this.resetRegistry();
        return (EPPRegistryInfoResp)this.session.processDocument(theCommand, EPPRegistryInfoResp.class);
    }

    public EPPRegistryCreateResp sendCreate() throws EPPCommandException {
        if (this.zone == null) {
            throw new EPPCommandException("Zone information is required for sendCreate()");
        }
        EPPRegistryCreateCmd theCommand = new EPPRegistryCreateCmd(this.transId, this.zone);
        theCommand.setExtensions(this.extensions);
        this.resetRegistry();
        return (EPPRegistryCreateResp)this.session.processDocument(theCommand, EPPRegistryCreateResp.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        if (this.zone == null) {
            throw new EPPCommandException("Zone information is required for sendUpdate()");
        }
        EPPRegistryUpdateCmd theCommand = new EPPRegistryUpdateCmd(this.transId, this.zone);
        theCommand.setExtensions(this.extensions);
        this.resetRegistry();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    public EPPSession getSession() {
        return this.session;
    }

    public void setSession(EPPSession aSession) {
        this.session = aSession;
    }

    public String getTransId() {
        return this.transId;
    }

    public void setTransId(String aTransId) {
        this.transId = aTransId;
    }

    public List<EPPRegistryZoneName> getZoneList() {
        return this.zoneList;
    }

    public void setZoneList(List<EPPRegistryZoneName> aZoneList) {
        if (aZoneList == null) {
            this.zoneList = new ArrayList<EPPRegistryZoneName>();
        } else {
            this.zoneList = aZoneList;
            this.allZones = false;
            this.system = false;
        }
    }

    public void addZone(String aZone) {
        if (this.zoneList == null) {
            this.zoneList = new ArrayList<EPPRegistryZoneName>();
        }
        this.zoneList.add(new EPPRegistryZoneName(aZone, EPPRegistryZoneName.Form.aLabel));
        this.allZones = false;
        this.system = false;
    }

    public void addZone(EPPRegistryZoneName aZone) {
        if (this.zoneList == null) {
            this.zoneList = new ArrayList<EPPRegistryZoneName>();
        }
        this.zoneList.add(aZone);
        this.allZones = false;
        this.system = false;
    }

    public boolean isAllZones() {
        return this.allZones;
    }

    public void setAllZones(boolean aAllZones) {
        this.allZones = aAllZones;
        if (aAllZones) {
            this.zoneList = new ArrayList<EPPRegistryZoneName>();
            this.system = false;
        }
    }

    public boolean isSystem() {
        return this.system;
    }

    public EPPRegistryZone getZoneInfo() {
        return this.zone;
    }

    public void setZone(EPPRegistryZone aZone) {
        this.zone = aZone;
    }

    public Vector<EPPCodecComponent> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Vector<EPPCodecComponent> aExtensions) {
        this.extensions = aExtensions;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public void setSystem(boolean aSystem) {
        this.system = aSystem;
        if (aSystem) {
            this.zoneList = new ArrayList<EPPRegistryZoneName>();
            this.allZones = false;
        }
    }

    public EPPResponse getResponse() {
        return this.session.getResponse();
    }

    private void resetRegistry() {
        this.transId = null;
        this.zoneList = new ArrayList<EPPRegistryZoneName>();
        this.allZones = false;
        this.system = false;
        this.extensions = null;
        this.zone = null;
    }
}

