/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.launchpolicy.v01;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyCreate;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyInfData;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyInfoPhase;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyPhase;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyPhaseStatus;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyPollPolicy;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyUpdate;
import com.verisign.epp.codec.launchpolicy.v01.EPPLaunchPolicyZone;
import com.verisign.epp.codec.registry.v01.EPPRegistryCheckResp;
import com.verisign.epp.codec.registry.v01.EPPRegistryCheckResult;
import com.verisign.epp.codec.registry.v01.EPPRegistryContact;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactAddress;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactCity;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactName;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactOrg;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactPostalCode;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactStateProvince;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactStreet;
import com.verisign.epp.codec.registry.v01.EPPRegistryCreateResp;
import com.verisign.epp.codec.registry.v01.EPPRegistryDNSSEC;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomain;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainContact;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainHostLimit;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainNSLimit;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainName;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainPeriod;
import com.verisign.epp.codec.registry.v01.EPPRegistryExternalHost;
import com.verisign.epp.codec.registry.v01.EPPRegistryGracePeriod;
import com.verisign.epp.codec.registry.v01.EPPRegistryHost;
import com.verisign.epp.codec.registry.v01.EPPRegistryIDN;
import com.verisign.epp.codec.registry.v01.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.v01.EPPRegistryInternalHost;
import com.verisign.epp.codec.registry.v01.EPPRegistryKey;
import com.verisign.epp.codec.registry.v01.EPPRegistryLanguage;
import com.verisign.epp.codec.registry.v01.EPPRegistryMaxSig;
import com.verisign.epp.codec.registry.v01.EPPRegistryMinMaxLength;
import com.verisign.epp.codec.registry.v01.EPPRegistryPendingDeletePeriodType;
import com.verisign.epp.codec.registry.v01.EPPRegistryPendingRestorePeriodType;
import com.verisign.epp.codec.registry.v01.EPPRegistryPeriodType;
import com.verisign.epp.codec.registry.v01.EPPRegistryPostal;
import com.verisign.epp.codec.registry.v01.EPPRegistryRGP;
import com.verisign.epp.codec.registry.v01.EPPRegistryRedemptionPeriodType;
import com.verisign.epp.codec.registry.v01.EPPRegistryRegex;
import com.verisign.epp.codec.registry.v01.EPPRegistryReservedNames;
import com.verisign.epp.codec.registry.v01.EPPRegistryServices;
import com.verisign.epp.codec.registry.v01.EPPRegistryServicesExt;
import com.verisign.epp.codec.registry.v01.EPPRegistrySupportedStatus;
import com.verisign.epp.codec.registry.v01.EPPRegistryTransferHoldPeriodType;
import com.verisign.epp.codec.registry.v01.EPPRegistryZone;
import com.verisign.epp.codec.registry.v01.EPPRegistryZoneName;
import com.verisign.epp.codec.registry.v01.EPPRegistryZoneSummary;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.interfaces.registry.v01.EPPRegistry;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPLaunchPolicyRegistryTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPLaunchPolicyRegistryTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPRegistry registry = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new SecureRandom();

    public EPPLaunchPolicyRegistryTst(String name) {
        super(name);
    }

    public void testRegistry() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            try {
                numIterations = Integer.parseInt(iterationsStr);
                numIterations = numIterations < 1 ? 1 : numIterations;
            }
            catch (Exception e) {
                numIterations = 1;
            }
        }
        this.printStart("Test Suite");
        this.registryCreate("launchpolicytst", true);
        this.registryUpdate("launchpolicytst", true);
        this.registryInfo("launchpolicytst", false, false);
        this.registryDelete("launchpolicytst", true);
        this.printEnd("Test Suite");
    }

    public void registryCheck(Map aZoneNames) {
        this.printStart("registryCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.print("registryCheck:");
            this.registry.setTransId("ABC-12345-XYZ");
            Iterator it = aZoneNames.entrySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next().getKey();
                System.out.print(" " + name + " ");
                this.registry.addZone(name);
            }
            System.out.println("");
            EPPRegistryCheckResp response = this.registry.sendCheck();
            System.out.println("registryCheck: Response = [" + response + "]\n\n");
            block3: for (Map.Entry entry : aZoneNames.entrySet()) {
                String name = (String)entry.getKey();
                Boolean available = (Boolean)entry.getValue();
                for (EPPRegistryCheckResult element : response.getCheckResults()) {
                    EPPRegistryCheckResult result = element;
                    if (!result.getName().equals(name)) continue;
                    if (result.isAvailable().booleanValue() == available.booleanValue()) continue block3;
                    EPPLaunchPolicyRegistryTst.fail((String)("Expected availability for tld \"" + name + "\": " + available + ", but got: " + result.isAvailable()));
                }
            }
            EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("registryCheck");
    }

    public void registryCreate(String aZoneName, boolean aShouldSucceed) {
        block4: {
            this.printStart("registryCreate");
            EPPRegistryCreateResp response = null;
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("registryCreate: " + aZoneName);
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.setZone(this.buildZoneInfo(new EPPRegistryZoneName(aZoneName)));
                EPPLaunchPolicyCreate launchPolicyExt = new EPPLaunchPolicyCreate(EPPLaunchPolicyRegistryTst.buildLaunchPolicyZone());
                this.registry.addExtension(launchPolicyExt);
                response = this.registry.sendCreate();
                System.out.println("registryCreate: Response = [" + response + "]\n\n");
                if (aShouldSucceed) {
                    EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                } else {
                    EPPLaunchPolicyRegistryTst.fail((String)"Expecting error in response");
                }
            }
            catch (EPPCommandException e) {
                if (!aShouldSucceed) break block4;
                this.handleException(e);
            }
        }
        this.printEnd("registryCreate");
    }

    public void registryDelete(String aZoneName, boolean aShouldSucceed) {
        block4: {
            this.printStart("registryDelete");
            EPPResponse response = null;
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("registryDelete: " + aZoneName);
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.addZone(aZoneName);
                response = this.registry.sendDelete();
                System.out.println("registryDelete: Response = [" + response + "]\n\n");
                if (aShouldSucceed) {
                    EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                } else {
                    EPPLaunchPolicyRegistryTst.fail((String)"Expecting error in response");
                }
            }
            catch (EPPCommandException e) {
                if (!aShouldSucceed) break block4;
                this.handleException(e);
            }
        }
        this.printEnd("registryDelete");
    }

    public void registryUpdate(String aZoneName, boolean aShouldSucceed) {
        block4: {
            this.printStart("registryUpdate");
            EPPResponse response = null;
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("registryUpdate: " + aZoneName);
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.setZone(this.buildZoneInfo(new EPPRegistryZoneName(aZoneName)));
                EPPLaunchPolicyUpdate launchPolicyExt = new EPPLaunchPolicyUpdate(EPPLaunchPolicyRegistryTst.buildLaunchPolicyZone());
                this.registry.addExtension(launchPolicyExt);
                response = this.registry.sendUpdate();
                System.out.println("registryUpdate: Response = [" + response + "]\n\n");
                if (aShouldSucceed) {
                    EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                } else {
                    EPPLaunchPolicyRegistryTst.fail((String)"Expecting error in response");
                }
            }
            catch (EPPCommandException e) {
                if (!aShouldSucceed) break block4;
                this.handleException(e);
            }
        }
        this.printEnd("registryUpdate");
    }

    public void registryInfo(String aZoneName, boolean aAll, boolean aSystem) {
        this.printStart("registryInfo");
        EPPRegistryInfoResp response = null;
        try {
            if (aZoneName != null) {
                if (aAll || aSystem) {
                    Assert.fail((String)"[1} Only one form of info command can be used at a time");
                }
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.addZone(aZoneName);
                response = this.registry.sendInfo();
                EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                EPPLaunchPolicyRegistryTst.assertTrue((response.getZoneList() == null && response.getZoneInfo() != null ? 1 : 0) != 0);
                EPPRegistryZone info = response.getZoneInfo();
                System.out.println("Zone name: " + info.getName());
                if (info.getServices() != null) {
                    System.out.println("Services:");
                    Iterator<EPPRegistryServices.EPPRegistryObjURI> iterator = info.getServices().getObjURIs().iterator();
                    while (iterator.hasNext()) {
                        EPPRegistryServices.EPPRegistryObjURI element;
                        EPPRegistryServices.EPPRegistryObjURI objUri = element = iterator.next();
                        System.out.println("\tobjURI: " + objUri.getUri() + ", required: " + objUri.getRequired());
                    }
                }
                if (info.getServices() != null && info.getServices().getExtension() != null) {
                    System.out.println("Services extension:");
                    for (EPPRegistryServicesExt.EPPRegistryExtURI extUri : info.getServices().getExtension().getExtURIs()) {
                        System.out.println("\textURI: " + extUri.getUri() + ", required: " + extUri.getRequired());
                    }
                }
                System.out.println("crId: " + info.getCreatedBy());
                System.out.println("crDate: " + info.getCreatedDate());
                System.out.println("upId: " + info.getLastUpdatedBy());
                System.out.println("upDate: " + info.getLastUpdatedDate());
                EPPRegistryDomain domain = info.getDomain();
                EPPLaunchPolicyRegistryTst.assertTrue((domain != null ? 1 : 0) != 0);
                System.out.println("Domain: " + domain);
                EPPRegistryHost host = info.getHost();
                EPPLaunchPolicyRegistryTst.assertTrue((host != null ? 1 : 0) != 0);
                System.out.println("Host: " + host);
                EPPRegistryContact contact = info.getContact();
                EPPLaunchPolicyRegistryTst.assertTrue((contact != null ? 1 : 0) != 0);
                System.out.println("Contact: " + contact);
                EPPLaunchPolicyInfData launchPolicyExt = (EPPLaunchPolicyInfData)response.getExtension(EPPLaunchPolicyInfData.class);
                EPPLaunchPolicyRegistryTst.assertTrue((launchPolicyExt != null ? 1 : 0) != 0);
                if (launchPolicyExt != null) {
                    System.out.println("Launch Policy Zone: " + launchPolicyExt.getZone());
                }
            } else if (aAll) {
                if (aSystem) {
                    Assert.fail((String)"[2] Only one form of info command can be used at a time");
                }
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.setAllZones(true);
                response = this.registry.sendInfo();
                EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                EPPLaunchPolicyRegistryTst.assertTrue((response.getZoneList() != null && response.getZoneList().getZoneList() != null && response.getZoneInfo() == null && response.getZoneList().getZoneList().size() > 0 ? 1 : 0) != 0);
                System.out.println("All TLDs: ");
                for (EPPRegistryZoneSummary tld : response.getZoneList().getZoneList()) {
                    EPPLaunchPolicyRegistryTst.assertTrue((tld.getName().getName() != null && tld.getName().getName().length() > 0 ? 1 : 0) != 0);
                    EPPLaunchPolicyRegistryTst.assertTrue((tld.getCreateDate() != null ? 1 : 0) != 0);
                    System.out.print(tld.getName() + "\tcreated on " + tld.getCreateDate());
                    if (tld.getUpdateDate() != null) {
                        System.out.println("\tupdated on " + tld.getUpdateDate());
                        continue;
                    }
                    System.out.println();
                }
            } else if (aSystem) {
                this.registry.setTransId("ABC-12345-XYZ");
                this.registry.setSystem(true);
                response = this.registry.sendInfo();
                EPPLaunchPolicyRegistryTst.assertTrue((response != null && response.isSuccess() ? 1 : 0) != 0);
                System.out.println("System Info Response = " + response);
            } else {
                Assert.fail((String)"At least one info command form must be specified");
            }
            this.printEnd("registryInfo");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
    }

    public String makeZoneName() {
        int len = this.rd.nextInt(15);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append(97 + this.rd.nextInt(26));
        }
        return sb.toString();
    }

    public void handleException(Exception aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = ((EPPCommandException)aException).getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPLaunchPolicyRegistryTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.registry = new EPPRegistry(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private EPPRegistryZone buildZoneInfo(EPPRegistryZoneName aZone) {
        EPPRegistryZone theZoneInfo = new EPPRegistryZone(aZone);
        theZoneInfo.setDomain(this.buildDomain());
        theZoneInfo.setHost(this.buildHost());
        theZoneInfo.setContact(this.buildContact());
        EPPRegistryServices services = new EPPRegistryServices();
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:registry-1.2", Boolean.TRUE));
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:registry-1.1", Boolean.FALSE));
        EPPRegistryServicesExt svcExt = new EPPRegistryServicesExt();
        services.setExtension(svcExt);
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:registry-1.2", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:registry-1.1", Boolean.FALSE));
        theZoneInfo.setServices(services);
        theZoneInfo.setCreatedBy("crId");
        theZoneInfo.setCreatedDate(new Date());
        return theZoneInfo;
    }

    private EPPRegistryDomain buildDomain() {
        EPPRegistryDomain domain = new EPPRegistryDomain();
        ArrayList<EPPRegistryDomainName> domainNames = new ArrayList<EPPRegistryDomainName>();
        EPPRegistryDomainName domainName = new EPPRegistryDomainName();
        domainName.setLevel(2);
        domainName.setMinLength(5);
        domainName.setMaxLength(50);
        domainName.setAlphaNumStart(true);
        domainName.setAlphaNumEnd(false);
        domainName.setALabelSupported(true);
        ArrayList<EPPRegistryRegex> regex = new ArrayList<EPPRegistryRegex>();
        EPPRegistryRegex r = new EPPRegistryRegex("^\\w+.*$", "test regex");
        regex.add(r);
        r = new EPPRegistryRegex("^\\d+.*$");
        regex.add(r);
        domainName.setRegex(regex);
        EPPRegistryReservedNames reservedNames = new EPPRegistryReservedNames();
        ArrayList<String> rNames = new ArrayList<String>();
        reservedNames.setReservedNames(rNames);
        rNames.add("reserved1");
        rNames.add("reserved2");
        domainName.setReservedNames(reservedNames);
        domainNames.add(domainName);
        try {
            domainName = (EPPRegistryDomainName)domainName.clone();
            domainName.setLevel(3);
            domainName.getReservedNames().setReservedNames(new ArrayList<String>());
            domainName.getReservedNames().setReservedNameURI("http://testrn.vrsn.com");
            domainNames.add(domainName);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        domain.setDomainNames(domainNames);
        EPPRegistryIDN idn = new EPPRegistryIDN();
        idn.setIdnVersion("1.1");
        idn.setIdnaVersion("2008");
        idn.setUnicodeVersion("6.0");
        idn.addLanguage(new EPPRegistryLanguage("CHI", "http://www.iana.org/domains/idn-tables/tables/com_zh_1.1.txt", EPPRegistryLanguage.VariantStrategy.restricted));
        idn.addLanguage(new EPPRegistryLanguage("LATN", "http://www.iana.org/domains/idn-tables/tables/eu_latn_1.0.html", EPPRegistryLanguage.VariantStrategy.blocked));
        idn.setCommingleAllowed(Boolean.TRUE);
        domain.setIdn(idn);
        domain.setPremiumSupport(true);
        domain.setContactsSupported(false);
        domain.addContact(new EPPRegistryDomainContact(EPPRegistryDomainContact.Type.admin, 1, 4));
        domain.addContact(new EPPRegistryDomainContact(EPPRegistryDomainContact.Type.billing, 2, 5));
        domain.addContact(new EPPRegistryDomainContact(EPPRegistryDomainContact.Type.tech, 3, 6));
        domain.setNameServerLimit(new EPPRegistryDomainNSLimit(1, 16));
        domain.setChildHostLimit(new EPPRegistryDomainHostLimit(2, 32));
        domain.addPeriod(new EPPRegistryDomainPeriod("create", Boolean.TRUE));
        domain.addPeriod(new EPPRegistryDomainPeriod("renew", 1, EPPRegistryPeriodType.Unit.y, 10, EPPRegistryPeriodType.Unit.y, 2, EPPRegistryPeriodType.Unit.y));
        domain.addPeriod(new EPPRegistryDomainPeriod("transfer", 1, EPPRegistryPeriodType.Unit.y, 8, EPPRegistryPeriodType.Unit.y, 3, EPPRegistryPeriodType.Unit.y));
        domain.setTransferHoldPeriod(new EPPRegistryTransferHoldPeriodType(1, EPPRegistryPeriodType.Unit.y));
        domain.addGracePeriod(new EPPRegistryGracePeriod("create", 1, EPPRegistryPeriodType.Unit.m));
        domain.addGracePeriod(new EPPRegistryGracePeriod("renew", 2, EPPRegistryPeriodType.Unit.h));
        domain.addGracePeriod(new EPPRegistryGracePeriod("transfer", 3, EPPRegistryPeriodType.Unit.d));
        EPPRegistryRGP rgp = new EPPRegistryRGP();
        rgp.setPendingDeletePeriod(new EPPRegistryPendingDeletePeriodType(1, EPPRegistryPeriodType.Unit.m));
        rgp.setRedemptionPeriod(new EPPRegistryRedemptionPeriodType(1, EPPRegistryPeriodType.Unit.m));
        rgp.setPendingRestorePeriod(new EPPRegistryPendingRestorePeriodType(1, EPPRegistryPeriodType.Unit.m));
        domain.setRgp(rgp);
        EPPRegistryDNSSEC dnssec = new EPPRegistryDNSSEC();
        EPPRegistryKey key = new EPPRegistryKey(2, 4, null);
        key.addAlgorithm("algKey1");
        key.addAlgorithm("algKey2");
        key.addAlgorithm("algKey3");
        dnssec.setKey(key);
        dnssec.setMaxSigLife(new EPPRegistryMaxSig(true, 1, 2, 3));
        dnssec.setUrgent(Boolean.TRUE);
        domain.setDnssec(dnssec);
        domain.setMaxCheckDomain(12);
        domain.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientHold");
        supportedStatus.addStatus("serverHold");
        supportedStatus.addStatus("clientRenewProhibited");
        supportedStatus.addStatus("serverRenewProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("inactive");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingRenew");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        domain.setSupportedStatus(supportedStatus);
        return domain;
    }

    private EPPRegistryContact buildContact() {
        EPPRegistryContact contact = new EPPRegistryContact();
        contact.setContactIdRegex(new EPPRegistryRegex("^.*$"));
        contact.setSharePolicy(EPPRegistryContact.SharePolicy.perZone);
        contact.setIntPostalInfoTypeSupport(EPPRegistryContact.PostalInfoTypeSupport.locSupport);
        contact.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        contact.setMaxCheckContact(15);
        EPPRegistryPostal postalInfo = new EPPRegistryPostal();
        postalInfo.setName(new EPPRegistryContactName(5, 15));
        postalInfo.setOrg(new EPPRegistryContactOrg(2, 12));
        postalInfo.setVoiceRequired(Boolean.TRUE);
        postalInfo.setEmailRegex(new EPPRegistryRegex("^.+\\..+$"));
        EPPRegistryContactAddress address = new EPPRegistryContactAddress();
        address.setStreet(new EPPRegistryContactStreet(2, 12, 0, 3));
        address.setCity(new EPPRegistryContactCity(5, 15));
        address.setStateProvince(new EPPRegistryContactStateProvince(1, 11));
        address.setPostalCode(new EPPRegistryContactPostalCode(2, 12));
        postalInfo.setAddress(address);
        postalInfo.setVoiceRequired(Boolean.TRUE);
        postalInfo.setVoiceExt(new EPPRegistryMinMaxLength(5, 15));
        postalInfo.setFaxExt(new EPPRegistryMinMaxLength(5, 15));
        contact.setMaxCheckContact(5);
        contact.setPostalInfo(postalInfo);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("linked");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        contact.setSupportedStatus(supportedStatus);
        return contact;
    }

    private EPPRegistryHost buildHost() {
        EPPRegistryHost host = new EPPRegistryHost();
        host.setInternal(new EPPRegistryInternalHost(5, 15, EPPRegistryInternalHost.SharePolicy.perZone, Boolean.FALSE));
        host.setExternal(new EPPRegistryExternalHost(2, 12, EPPRegistryExternalHost.SharePolicy.perZone, Boolean.FALSE));
        host.addNameRegex(new EPPRegistryRegex("^.*$", "exp1"));
        host.addNameRegex(new EPPRegistryRegex("^.*$", "exp2"));
        host.setMaxCheckHost(15);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("linked");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        host.setSupportedStatus(supportedStatus);
        return host;
    }

    public static EPPLaunchPolicyZone buildLaunchPolicyZone() {
        EPPLaunchPolicyZone zone = new EPPLaunchPolicyZone();
        EPPLaunchPolicyPhase sunrise = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.sunrise, new GregorianCalendar(2017, 11, 1, 0, 0).getTime());
        sunrise.setMode(EPPLaunchPolicyPhase.Mode.pendingApplication);
        sunrise.setEndDate(new GregorianCalendar(2017, 12, 1, 0, 0).getTime());
        sunrise.setValidatePhase(true);
        sunrise.addValidatorId("tmch");
        sunrise.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.pendingAllocation));
        sunrise.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.allocated));
        sunrise.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.rejected));
        sunrise.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.custom, "test", null, "test status"));
        sunrise.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        sunrise.setMaxMarks(1);
        sunrise.addSignedMarkSupported("urn:ietf:params:xml:ns:signedMark-1.0");
        sunrise.addEncodedSignedMarkSupported("urn:ietf:params:xml:ns:signedMark-1.0");
        sunrise.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.sunrise));
        sunrise.addCreateForm(EPPLaunchPolicyPhase.CreateForm.sunrise);
        sunrise.setCreateValidateType(true);
        zone.addPhase(sunrise);
        EPPLaunchPolicyPhase lrp1 = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.claims, new GregorianCalendar(2017, 12, 1, 0, 0).getTime());
        lrp1.setName("lrp1");
        lrp1.setMode(EPPLaunchPolicyPhase.Mode.pendingRegistration);
        lrp1.setEndDate(new GregorianCalendar(2017, 12, 8, 0, 0).getTime());
        lrp1.setValidatePhase(true);
        lrp1.addValidatorId("tmch");
        lrp1.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.pendingValidation));
        lrp1.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.allocated));
        lrp1.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.rejected));
        lrp1.setPendingCreate(true);
        lrp1.addCheckForm(EPPLaunchPolicyPhase.CheckForm.claims);
        lrp1.addCheckForm(EPPLaunchPolicyPhase.CheckForm.availability);
        lrp1.addCheckForm(EPPLaunchPolicyPhase.CheckForm.trademark);
        lrp1.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        lrp1.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.sunrise));
        lrp1.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "lrp1"));
        lrp1.addCreateForm(EPPLaunchPolicyPhase.CreateForm.claims);
        lrp1.setCreateValidateType(true);
        zone.addPhase(lrp1);
        EPPLaunchPolicyPhase landrush = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.claims, new GregorianCalendar(2017, 12, 8, 0, 0).getTime());
        landrush.setName("landrush");
        landrush.setMode(EPPLaunchPolicyPhase.Mode.pendingApplication);
        landrush.setEndDate(new GregorianCalendar(2017, 12, 15, 0, 0).getTime());
        landrush.setValidatePhase(true);
        landrush.addValidatorId("tmch");
        landrush.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.pendingAllocation));
        landrush.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.allocated));
        landrush.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.rejected));
        landrush.setPendingCreate(true);
        landrush.setPollPolicy(new EPPLaunchPolicyPollPolicy(false, false, false));
        landrush.addCheckForm(EPPLaunchPolicyPhase.CheckForm.claims);
        landrush.addCheckForm(EPPLaunchPolicyPhase.CheckForm.availability);
        landrush.addCheckForm(EPPLaunchPolicyPhase.CheckForm.trademark);
        landrush.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        landrush.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.sunrise));
        landrush.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "lrp1"));
        landrush.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "landrush"));
        landrush.addCreateForm(EPPLaunchPolicyPhase.CreateForm.claims);
        landrush.setCreateValidateType(true);
        zone.addPhase(landrush);
        EPPLaunchPolicyPhase claims = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.claims, new GregorianCalendar(2017, 12, 15, 0, 0).getTime());
        claims.setName("open");
        claims.setMode(EPPLaunchPolicyPhase.Mode.fcfs);
        claims.setEndDate(new GregorianCalendar(2018, 2, 15, 0, 0).getTime());
        claims.setValidatePhase(true);
        claims.addValidatorId("tmch");
        claims.addCheckForm(EPPLaunchPolicyPhase.CheckForm.claims);
        claims.addCheckForm(EPPLaunchPolicyPhase.CheckForm.availability);
        claims.addCheckForm(EPPLaunchPolicyPhase.CheckForm.trademark);
        claims.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        claims.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "landrush"));
        claims.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "open"));
        claims.addCreateForm(EPPLaunchPolicyPhase.CreateForm.claims);
        claims.addCreateForm(EPPLaunchPolicyPhase.CreateForm.general);
        claims.setCreateValidateType(true);
        zone.addPhase(claims);
        EPPLaunchPolicyPhase lrp2 = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.custom, new GregorianCalendar(2018, 2, 15, 0, 0).getTime());
        lrp2.setName("lrp2");
        lrp2.setMode(EPPLaunchPolicyPhase.Mode.pendingRegistration);
        lrp2.setEndDate(new GregorianCalendar(2018, 3, 15, 0, 0).getTime());
        lrp2.setValidatePhase(true);
        lrp2.addValidatorId("lrp2-custom");
        lrp2.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.custom, "pendingInternalValidation"));
        lrp2.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.allocated));
        lrp2.addStatus(new EPPLaunchPolicyPhaseStatus(EPPLaunchPolicyPhaseStatus.Status.rejected));
        lrp2.setPendingCreate(true);
        lrp2.setPollPolicy(new EPPLaunchPolicyPollPolicy(true, false, false));
        lrp2.addCheckForm(EPPLaunchPolicyPhase.CheckForm.claims);
        lrp2.addCheckForm(EPPLaunchPolicyPhase.CheckForm.availability);
        lrp2.addCheckForm(EPPLaunchPolicyPhase.CheckForm.trademark);
        lrp2.addMarkValidation(EPPLaunchPolicyPhase.MarkValidation.signedMark);
        sunrise.setMaxMarks(1);
        sunrise.addSignedMarkSupported("http://www.example.com/epp/lrp2-custom-1.0");
        sunrise.addEncodedSignedMarkSupported("http://www.example.com/epp/lrp2-custom-1.0");
        lrp2.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.claims, "open"));
        lrp2.addInfoPhase(new EPPLaunchPolicyInfoPhase(EPPLaunchPolicyPhase.Phase.custom, "lrp2"));
        lrp2.addCreateForm(EPPLaunchPolicyPhase.CreateForm.sunrise);
        lrp2.addCreateForm(EPPLaunchPolicyPhase.CreateForm.general);
        lrp2.addCreateForm(EPPLaunchPolicyPhase.CreateForm.claims);
        lrp2.addCreateForm(EPPLaunchPolicyPhase.CreateForm.mixed);
        lrp2.setCreateValidateType(true);
        zone.addPhase(lrp2);
        EPPLaunchPolicyPhase open = new EPPLaunchPolicyPhase(EPPLaunchPolicyPhase.Phase.open, new GregorianCalendar(2018, 3, 15, 0, 0).getTime());
        open.setValidatePhase(false);
        zone.addPhase(open);
        return zone;
    }
}

