/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPHello;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPLogoutCmd;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.gen.EPPPollCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPLoginAdapter;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.EPPConFactorySingle;
import com.verisign.epp.transport.client.EPPSSLContext;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPSendReceiveLogger;
import com.verisign.epp.util.EPPXMLStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;

public class EPPSession {
    public static final String OP_REQ = "req";
    public static final String OP_ACK = "ack";
    private static final Logger cat = Logger.getLogger((String)EPPSession.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final int MODE_SYNC = 0;
    public static final int MODE_ASYNC = 1;
    protected EPPCodec codec = EPPCodec.getInstance();
    protected String transId = null;
    protected String version = null;
    protected String language = null;
    protected String clientId = null;
    protected String password = null;
    protected String newPassword = null;
    protected EPPResponse response = null;
    protected byte[] responsePacket = null;
    protected Vector services = null;
    protected Vector extensionServices = null;
    protected EPPClientCon connection = null;
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;
    protected EPPXMLStream xmlStream = null;
    protected String pollOp = null;
    protected EPPMessage message = null;
    protected String msgID = null;
    private String statusTransId = null;
    private String statusCommandType = null;
    private int mode = 0;
    private EPPLoginAdapter loginAdapter;
    private static EPPSendReceiveLogger sendReceiveLogger = EPPEnv.getSendReceiveLogger();

    public EPPSession() throws EPPCommandException {
        this.init();
    }

    public EPPSession(String aHostName, int aPortNumber) throws EPPCommandException {
        this.init(aHostName, aPortNumber, null);
    }

    public EPPSession(String aHostName, int aPortNumber, String aClientHostName) throws EPPCommandException {
        this.init(aHostName, aPortNumber, aClientHostName, null);
    }

    public EPPSession(String aHostName, int aPortNumber, EPPSSLContext aSSLContext) throws EPPCommandException {
        this.init(aHostName, aPortNumber, aSSLContext);
    }

    public EPPSession(String aHostName, int aPortNumber, String aClientHostName, EPPSSLContext aSSLContext) throws EPPCommandException {
        this.init(aHostName, aPortNumber, aClientHostName, aSSLContext);
    }

    protected void init() throws EPPCommandException {
        cat.debug((Object)"init(): enter");
        this.connection = this.getConnection();
        try {
            this.connection.initialize();
        }
        catch (EPPConException ex) {
            cat.error((Object)("init(): Unable to initialize connection to the EPP Server: " + ex));
            throw new EPPCommandException("EPPSession() Unable to initialize connection to the EPP Server: " + ex);
        }
        this.initStreams();
        this.initLoginAdapter();
        cat.debug((Object)"init(): exit");
    }

    protected void init(String aHostName, int aPortNumber, EPPSSLContext aSSLContext) throws EPPCommandException {
        cat.debug((Object)"init(String, int, EPPSSLContext): enter");
        this.connection = this.getConnection();
        try {
            this.connection.initialize(aHostName, aPortNumber, aSSLContext);
        }
        catch (EPPConException ex) {
            cat.error((Object)("init(String, int, EPPSSLContext): Unable to initialize connection to the EPP Server (host = " + aHostName + ", port = " + aPortNumber + ": " + ex));
            throw new EPPCommandException("EPPSession() Unable to initialize connection to the EPP Server (host = " + aHostName + ", port = " + aPortNumber + ": " + ex);
        }
        this.initStreams();
        this.initLoginAdapter();
        cat.debug((Object)"init(String, int, EPPSSLContext): exit");
    }

    protected void init(String aHostName, int aPortNumber, String aClientHostName, EPPSSLContext aSSLContext) throws EPPCommandException {
        cat.debug((Object)"init(int, int, String, EPPSSLContext): enter");
        this.connection = this.getConnection();
        try {
            this.connection.initialize(aHostName, aPortNumber, aClientHostName, aSSLContext);
        }
        catch (EPPConException ex) {
            cat.error((Object)("init(int, int, String, EPPSSLContext): Unable to initialize connection to the EPP Server (host = " + aHostName + ", port = " + aPortNumber + " from client host " + aClientHostName + ": " + ex));
            throw new EPPCommandException("EPPSession() Unable to initialize connection to the EPP Server (host = " + aHostName + ", port = " + aPortNumber + " from client host " + aClientHostName + ": " + ex);
        }
        this.initStreams();
        this.initLoginAdapter();
        cat.debug((Object)"init(int, int, String, EPPSSLContext): exit");
    }

    protected EPPClientCon getConnection() throws EPPCommandException {
        cat.debug((Object)"getConnection(): enter");
        EPPClientCon theConnection = null;
        try {
            theConnection = EPPConFactorySingle.getInstance().getEPPConnection();
        }
        catch (EPPConException ex) {
            cat.error((Object)("getConnection(): Unable to get connection instance from factory: " + ex));
            throw new EPPCommandException("EPPSession() Unable to get connection instance from factory: " + ex);
        }
        cat.debug((Object)"getConnection(): exit");
        return theConnection;
    }

    protected void initStreams() throws EPPCommandException {
        try {
            this.outputStream = new BufferedOutputStream(this.connection.getOutputStream(), 20480);
            this.inputStream = this.connection.getInputStream();
        }
        catch (EPPConException ex) {
            cat.error((Object)("EPPSession() Unable to get streams from connection: " + ex));
            throw new EPPCommandException("EPPSession() Unable to get streams from connection: " + ex);
        }
        this.xmlStream = new EPPXMLStream("EPP_XML_PARSER_POOL");
    }

    protected void initLoginAdapter() {
        this.loginAdapter = EPPEnv.getLoginAdapter();
        if (this.loginAdapter == null) {
            cat.debug((Object)"initLoginAdapter(): login adapter is not configured");
        } else {
            cat.debug((Object)("initLoginAdapter(): login adapter " + this.loginAdapter.getClass().getName() + " is configured"));
        }
    }

    protected void login() throws EPPCommandException {
        cat.debug((Object)"login(): enter");
        Document myDoc = null;
        EPPGreeting myGreeting = null;
        EPPLoginCmd myCommand = null;
        myDoc = this.recDocument();
        try {
            myGreeting = this.codec.decodeGreeting(myDoc);
            sendReceiveLogger.logReceive(this.responsePacket, myGreeting);
        }
        catch (EPPDecodeException myException) {
            cat.error((Object)("login(): Exception decoding greeting: " + myException));
            throw new EPPCommandException("EPPSession.Login() decode [EppDecodeException]: " + myException.getMessage());
        }
        catch (NullPointerException myException) {
            cat.error((Object)("login(): Exception decoding greeting: " + myException));
            throw new EPPCommandException("EPPSession.Login () decode [Null Pointer Exception] : " + myException.getMessage());
        }
        myCommand = this.newPassword == null ? new EPPLoginCmd(this.transId, this.clientId, this.password) : new EPPLoginCmd(this.transId, this.clientId, this.password, this.newPassword);
        if (this.version != null) {
            myCommand.setVersion(this.version);
        }
        if (this.language != null) {
            myCommand.setLang(this.language);
        }
        myCommand.mergeServicesAndExtensionServices(myGreeting);
        if (this.extensionServices != null) {
            myCommand.setExtensions(this.extensionServices);
        }
        if (this.services != null) {
            myCommand.setServices(this.services);
        }
        if (cat.isDebugEnabled() && !myCommand.isValidServices(myGreeting)) {
            cat.debug((Object)("Login services does not match the greeting services, greeting = [" + myGreeting + "], login = [" + myCommand + "]"));
        }
        if (this.loginAdapter != null) {
            cat.debug((Object)("Adapt login command with " + this.loginAdapter.getClass().getName()));
            this.loginAdapter.adaptLogin(myCommand, myGreeting);
        } else {
            cat.debug((Object)"No login adapter defined");
        }
        cat.debug((Object)("Sending login command: " + myCommand));
        try {
            myDoc = this.codec.encode(myCommand);
        }
        catch (EPPEncodeException myException) {
            cat.error((Object)("login(): Exception encoding login command: " + myException));
            throw new EPPCommandException("EPPSession.login() decode : " + myException.getMessage());
        }
        this.sendDocument(myDoc, myCommand);
        myDoc = this.recDocument();
        try {
            this.response = this.codec.decodeResponse(myDoc);
            sendReceiveLogger.logReceive(this.responsePacket, this.response);
        }
        catch (EPPDecodeException myException) {
            cat.error((Object)("login(): Exception decoding login response: " + myException));
            throw new EPPCommandException("EPPSession.initialize() decode : " + myException.getMessage());
        }
        if (!this.response.isSuccess()) {
            cat.error((Object)("login(): Login failure response: " + this.response));
            throw new EPPCommandException("EPPSession.login() : Error in response from Server ", this.response);
        }
        this.validateClientTransId(myCommand, this.response);
        this.transId = null;
        cat.debug((Object)"login(): exit");
    }

    public EPPGreeting hello() throws EPPCommandException {
        cat.debug((Object)"hello(): enter");
        Document theDoc = null;
        EPPHello theHello = null;
        EPPGreeting theGreeting = null;
        theHello = new EPPHello();
        try {
            theDoc = this.codec.encode(theHello);
        }
        catch (EPPEncodeException myException) {
            throw new EPPCommandException("EPPSession.Hello() decode : " + myException.getMessage());
        }
        this.sendDocument(theDoc, theHello);
        theDoc = this.recDocument();
        try {
            theGreeting = this.codec.decodeGreeting(theDoc);
            sendReceiveLogger.logReceive(this.responsePacket, theGreeting);
            cat.debug((Object)("hello greeting response = [" + theGreeting + "]"));
        }
        catch (EPPDecodeException myException) {
            cat.error((Object)("hello(): Exception decoding greeting: " + myException));
            throw new EPPCommandException("EPPSession.Hello() decode [EppDecodeException]: " + myException.getMessage());
        }
        catch (NullPointerException myException) {
            cat.error((Object)("hello(): Exception decoding greeting: " + myException));
            throw new EPPCommandException("EPPSession.Hello() decode [Null Pointer Exception] : " + myException.getMessage());
        }
        cat.debug((Object)"hello(): exit");
        return theGreeting;
    }

    public EPPResponse sendPoll() throws EPPCommandException {
        cat.debug((Object)"sendPoll(): enter");
        EPPPollCmd myCommand = new EPPPollCmd(this.transId, this.pollOp);
        if (this.pollOp.equals(OP_ACK)) {
            myCommand.setMsgID(this.msgID);
        }
        cat.debug((Object)"sendPoll(): exit");
        return this.processDocument(myCommand, EPPResponse.class);
    }

    protected void logout() throws EPPCommandException {
        cat.debug((Object)"logout(): enter");
        Document myDoc = null;
        EPPLogoutCmd myCommand = null;
        myCommand = new EPPLogoutCmd(this.transId);
        try {
            myDoc = this.codec.encode(myCommand);
        }
        catch (EPPEncodeException myException) {
            cat.error((Object)("logout(): Exception encoding command: " + myException));
            throw new EPPCommandException("EPPSession.logout() decode : " + myException.getMessage());
        }
        try {
            this.xmlStream.write(myDoc, this.outputStream, myCommand);
        }
        catch (Exception myException) {
            cat.error((Object)("logout(): Exception writing to stream: " + myException));
            throw new EPPCommandException("EPPSession.logout() : " + myException.getMessage());
        }
        try {
            this.responsePacket = this.xmlStream.readPacket(this.inputStream);
            myDoc = this.xmlStream.decodePacket(this.responsePacket);
        }
        catch (Exception myException) {
            cat.error((Object)("logout(): Exception reading from stream: " + myException));
            throw new EPPCommandException("EPPCommand.logout() : " + myException.getMessage());
        }
        try {
            this.response = this.codec.decodeResponse(myDoc);
            sendReceiveLogger.logReceive(this.responsePacket, this.response);
        }
        catch (EPPDecodeException myException) {
            cat.error((Object)("logout(): Exception decoding response: " + myException));
            throw new EPPCommandException("EPPSession.logout() decode : " + myException.getMessage());
        }
        if (!this.response.isSuccess()) {
            cat.error((Object)("logout(): Logout failed due to server error: " + this.response));
            throw new EPPCommandException("EPPSession.logout() : Error in response from Server ", this.response);
        }
        this.validateClientTransId(myCommand, this.response);
        cat.debug((Object)"logout(): exit");
    }

    public void validateClientTransId(EPPCommand myCommand, EPPResponse response) throws EPPCommandException {
        String theRespTransId = response.getTransId().getClientTransId();
        String theCmdTransId = myCommand.getTransId();
        if (theCmdTransId == null && theRespTransId == null) {
            return;
        }
        if (theCmdTransId == null || theRespTransId == null) {
            throw new EPPCommandException("null check, Response trans id of [" + theRespTransId + "] != Command trans id of [" + theCmdTransId + "]", response);
        }
        if (theRespTransId.compareTo(theCmdTransId) != 0) {
            throw new EPPCommandException("Response trans id of [" + theRespTransId + "] != Command trans id of [" + theCmdTransId + "]", response);
        }
    }

    public Document recDocument() throws EPPCommandException {
        Document myDoc;
        try {
            this.responsePacket = this.xmlStream.readPacket(this.inputStream);
            myDoc = this.xmlStream.decodePacket(this.responsePacket);
        }
        catch (EPPException myException) {
            cat.error((Object)("recDocument(): Exception reading from stream: " + myException));
            throw new EPPCommandException("EPPCommand.recDocument : " + myException.getMessage());
        }
        catch (IOException myException) {
            cat.error((Object)("recDocument(): Exception reading from stream: " + myException));
            throw new EPPCommandException("EPPCommand.recDocument : " + myException.getMessage());
        }
        return myDoc;
    }

    public void sendMessage(EPPMessage aMessage) throws EPPCommandException {
        Document theDoc = null;
        try {
            theDoc = this.codec.encode(aMessage);
        }
        catch (Exception myException) {
            throw new EPPCommandException("EPPSession.sendMessage: Error sending message: " + myException.getMessage());
        }
        this.message = aMessage;
        this.sendDocument(theDoc, aMessage);
    }

    public void sendDocument(Document newDoc, EPPMessage aMessage) throws EPPCommandException {
        try {
            this.xmlStream.write(newDoc, this.outputStream, aMessage);
        }
        catch (EPPException myException) {
            cat.error((Object)("sendDocument(): Exception writing to stream: " + myException));
            throw new EPPCommandException("EPPSession.sendDocument() : " + myException.getMessage());
        }
    }

    public void sendPacket(byte[] aPacket) throws EPPCommandException {
        try {
            this.xmlStream.writePacket(aPacket, this.outputStream);
        }
        catch (IOException ex) {
            cat.error((Object)("sendPacket(): Exception writing to stream: " + ex));
            throw new EPPCommandException("EPPSession.sendPacket() : " + ex.getMessage());
        }
    }

    public EPPResponse processDocument(EPPCommand aCommand) throws EPPCommandException {
        return this.processDocument(aCommand, null);
    }

    public EPPResponse readResponse() throws EPPCommandException {
        this.response = null;
        Document theDoc = null;
        theDoc = this.recDocument();
        try {
            this.response = this.codec.decodeResponse(theDoc);
        }
        catch (EPPDecodeException myException) {
            throw new EPPCommandException("EPPSession.readResponse: On Response " + myException.getMessage());
        }
        return this.response;
    }

    public EPPResponse processDocument(EPPCommand aCommand, Class aExpectedResponse) throws EPPCommandException {
        Document theDoc = null;
        try {
            theDoc = this.codec.encode(aCommand);
        }
        catch (Exception myException) {
            throw new EPPCommandException("EPPSession.processDocument: On Command " + myException.getMessage());
        }
        this.sendDocument(theDoc, aCommand);
        if (this.mode == 1) {
            return null;
        }
        EPPResponse theResponse = this.readResponse();
        sendReceiveLogger.logReceive(this.responsePacket, theResponse);
        if (!theResponse.isSuccess()) {
            throw new EPPCommandException("EPPSession.processDocument() : Error in response from Server", this.response);
        }
        if (aExpectedResponse != null && !aExpectedResponse.isInstance(theResponse)) {
            throw new EPPCommandException("Unexpected response type of " + theResponse.getClass().getName() + ", expecting " + aExpectedResponse);
        }
        this.validateClientTransId(aCommand, theResponse);
        return theResponse;
    }

    public void endSession() throws EPPCommandException {
        cat.debug((Object)"endSession(): enter");
        try {
            this.logout();
        }
        finally {
            try {
                this.endConnection();
            }
            catch (Exception exception) {}
        }
        cat.debug((Object)"endSession(): exit");
    }

    public void endConnection() throws EPPCommandException {
        cat.debug((Object)"endConnection(): enter");
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (Exception ex) {
            cat.error((Object)("endConnection(): Exception closing connection: " + ex));
            throw new EPPCommandException("EPPApplication.CloseConnection() : " + ex.getMessage());
        }
        cat.debug((Object)"endConnection(): exit");
    }

    public void initSession() throws EPPCommandException {
        cat.debug((Object)"initSession(): enter");
        if (this.clientId == null) {
            throw new EPPCommandException("EPPSession.initSession Login requires ClientID");
        }
        if (this.password == null) {
            throw new EPPCommandException("EPPSession.initSession Login requires Password");
        }
        this.login();
        cat.debug((Object)"initSession(): exit");
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String newVersion) {
        this.version = newVersion;
    }

    public String setLang() {
        return this.language;
    }

    public void setLang(String newLanguage) {
        this.language = newLanguage;
    }

    public String getTransId() {
        return this.transId;
    }

    public void setTransId(String newTransId) {
        this.transId = newTransId;
    }

    public EPPResponse getResponse() {
        return this.response;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream newInput) {
        this.inputStream = newInput;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public EPPClientCon getClientCon() {
        return this.connection;
    }

    public void setOutputStream(OutputStream newOutput) {
        this.outputStream = newOutput;
    }

    public String getClientID() {
        return this.clientId;
    }

    public void setClientID(String newClientID) {
        this.clientId = newClientID;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public void setServices(String[] newServiceNS) throws EPPCommandException {
        Vector<EPPService> theServices = new Vector<EPPService>();
        Vector factoryServices = EPPFactory.getInstance().getServices();
        for (String element : newServiceNS) {
            boolean found = false;
            for (int facService = 0; !found && facService < factoryServices.size(); ++facService) {
                EPPService currFacService = (EPPService)factoryServices.elementAt(facService);
                if (!element.equals(currFacService.getNamespaceURI())) continue;
                theServices.addElement(currFacService);
                found = true;
            }
            if (found) continue;
            throw new EPPCommandException("EppSession.setServices() : Invalid service: " + element + " specified");
        }
        this.services = theServices;
    }

    public void setExtensions(Vector ProtocolExtensions, Vector CommandResponseExtensions) throws EPPCommandException {
        Vector<EPPService> theExtensions = new Vector<EPPService>();
        Vector factoryExtensions = EPPFactory.getInstance().getExtensions();
        Vector extensionsVector = new Vector();
        if (ProtocolExtensions != null && ProtocolExtensions.elements().hasMoreElements()) {
            for (int i = 0; i < ProtocolExtensions.size(); ++i) {
                extensionsVector.addElement(ProtocolExtensions.elementAt(i));
            }
        }
        if (CommandResponseExtensions != null && CommandResponseExtensions.elements().hasMoreElements()) {
            for (int j = 0; j < CommandResponseExtensions.size(); ++j) {
                extensionsVector.addElement(CommandResponseExtensions.elementAt(j));
            }
        }
        if (extensionsVector != null && extensionsVector.elements().hasMoreElements()) {
            for (int newExtension = 0; newExtension < extensionsVector.size(); ++newExtension) {
                boolean found = false;
                for (int facExtension = 0; !found && facExtension < factoryExtensions.size(); ++facExtension) {
                    EPPService currFacExtension = (EPPService)factoryExtensions.elementAt(facExtension);
                    String extensionNameSpace = (String)extensionsVector.elementAt(facExtension);
                    if (!extensionNameSpace.equals(currFacExtension.getNamespaceURI())) continue;
                    theExtensions.addElement(currFacExtension);
                    found = true;
                }
                if (found) continue;
                throw new EPPCommandException("EppSession.setExtenisons() : Invalid extension: " + (String)extensionsVector.elementAt(newExtension) + " specified");
            }
        }
        this.extensionServices = theExtensions;
        for (int k = 0; k < this.extensionServices.size(); ++k) {
            EPPService ePPService = (EPPService)this.extensionServices.elementAt(k);
        }
    }

    public void setPollOp(String aOp) {
        this.pollOp = aOp;
    }

    public String getPollOp() {
        return this.pollOp;
    }

    public String getStatusTransId() {
        return this.statusTransId;
    }

    public void setStatusTransId(String aStatusTrans) {
        this.statusTransId = aStatusTrans;
    }

    public String getStatusCommandType() {
        return this.statusCommandType;
    }

    public void setStatusCommandType(String aStatusCommandType) {
        this.statusCommandType = aStatusCommandType;
    }

    public String getMsgID() {
        return this.msgID;
    }

    public void setMsgID(String aMsgID) {
        this.msgID = aMsgID;
    }

    public int getMode() {
        return this.mode;
    }

    public int setMode(int aMode) {
        if (this.isModeSupported(aMode)) {
            int thePrevMode = this.mode;
            this.mode = aMode;
            return thePrevMode;
        }
        cat.error((Object)("EPPSession.setMode(): Mode " + aMode + " NOT supported, current mode " + this.mode + " unchanged"));
        return this.mode;
    }

    public boolean isModeSupported(int aMode) {
        return aMode == 0 || aMode == 1;
    }
}

