/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckResp;
import com.verisign.epp.codec.idntable.EPPIdnTableDomainLabel;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoResp;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPIdnTable;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPIdnTableTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPIdnTableTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPIdnTable idnTable = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPIdnTableTst(String name) {
        super(name);
    }

    public void testIdnTable() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.idnTableCheck();
            this.idnTableInfo();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void idnTableCheck() {
        EPPIdnTableCheckResp response;
        this.printStart("idnTableCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("idnTableCheck: Check idn1.example, idn2.example, and idn3.example in Domain Check Form.");
            this.idnTable.setTransId("ABC-12345");
            this.idnTable.addDomain("idn1.example", EPPIdnTableDomainLabel.Form.U_LABEL);
            this.idnTable.addDomain("idn2.example", EPPIdnTableDomainLabel.Form.A_LABEL);
            this.idnTable.addDomain("idn3.example", EPPIdnTableDomainLabel.Form.A_LABEL);
            response = this.idnTable.sendDomainCheck();
            System.out.println("idnTableCheck: Domain Check Form Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("idnTableCheck: Check CHI, JPN, and INVALID in Table Check Form.");
            this.idnTable.setTransId("ABC-12345");
            this.idnTable.addTable("CHI");
            this.idnTable.addTable("JPN");
            this.idnTable.addTable("INVALID");
            response = this.idnTable.sendTableCheck();
            System.out.println("idnTableCheck: Table Check Form Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainCheck");
    }

    public void idnTableInfo() {
        EPPIdnTableInfoResp response;
        this.printStart("idnTableInfo");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("idnTableCheck: Info idn1.example in Domain Info Form.");
            this.idnTable.setTransId("ABC-12345");
            this.idnTable.addDomain("idn1.example", EPPIdnTableDomainLabel.Form.U_LABEL);
            response = this.idnTable.sendDomainInfo();
            System.out.println("idnTableInfo: Domain Info Form Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("idnTableCheck: Info xn--idn1.example in Domain Info Form.");
            this.idnTable.setTransId("ABC-12345");
            this.idnTable.addDomain("xn--idn1.example", EPPIdnTableDomainLabel.Form.A_LABEL);
            response = this.idnTable.sendDomainInfo();
            System.out.println("idnTableInfo: Domain Info Form Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("idnTableInfo: Info CHI in Table Info Form.");
            this.idnTable.setTransId("ABC-12345");
            this.idnTable.addTable("CHI");
            response = this.idnTable.sendTableInfo();
            System.out.println("idnTableInfo: Table Info Form Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("idnTableInfo: Info THAI in Table Info Form.");
            this.idnTable.setTransId("ABC-12345");
            this.idnTable.addTable("THAI");
            response = this.idnTable.sendTableInfo();
            System.out.println("idnTableInfo: Table Info Form Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("idnTableInfo: Send List Info Form.");
            this.idnTable.setTransId("ABC-12345");
            response = this.idnTable.sendListInfo();
            System.out.println("idnTableInfo: List Info Form Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("idnTableInfo");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
        this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.idnTable = new EPPIdnTable(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPIdnTableTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPIdnTableTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPIdnTableTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.out.println(aMsg);
            cat.info((Object)aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.err.println(aMsg);
            cat.error((Object)aMsg);
        }
    }
}

