/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryCreateCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryDeleteCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryMapFactory;
import com.verisign.epp.codec.registry.v02.EPPRegistryUpdateCmd;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public abstract class EPPRegistryHandler
implements EPPEventHandler {
    private static final Logger cat = Logger.getLogger((String)EPPRegistryHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPRegistryHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPRegistryMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error((Object)"Couldn't load the Map Factory associated with the Registry Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        EPPEventResponse response = null;
        if (message instanceof EPPRegistryInfoCmd) {
            response = this.doRegistryInfo(aEvent, aData);
        }
        if (message instanceof EPPRegistryCheckCmd) {
            response = this.doRegistryCheck(aEvent, aData);
        }
        if (message instanceof EPPRegistryCreateCmd) {
            response = this.doRegistryCreate(aEvent, aData);
        }
        if (message instanceof EPPRegistryUpdateCmd) {
            response = this.doRegistryUpdate(aEvent, aData);
        }
        if (message instanceof EPPRegistryDeleteCmd) {
            response = this.doRegistryDelete(aEvent, aData);
        }
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected abstract EPPEventResponse doRegistryInfo(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doRegistryCheck(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doRegistryCreate(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doRegistryUpdate(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doRegistryDelete(EPPEvent var1, Object var2);

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }
}

